/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.os.AsyncTaskCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationListView;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.QuickConversationAdapter;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobiComQuickConversationFragment
extends Fragment {
    public static final String QUICK_CONVERSATION_EVENT = "quick_conversation";
    protected ConversationListView listView = null;
    protected ImageButton fabButton;
    protected TextView emptyTextView;
    protected Button startNewButton;
    protected SwipeRefreshLayout swipeLayout;
    protected int listIndex;
    protected Map<String, Message> latestMessageForEachContact = new HashMap<String, Message>();
    protected List<Message> messageList = new ArrayList<Message>();
    protected QuickConversationAdapter conversationAdapter = null;
    protected boolean loadMore = false;
    protected SyncCallService syncCallService;
    private ApplozicSetting applozicSetting;
    private Long minCreatedAtTime;
    private DownloadConversation downloadConversation;
    private BaseContactService baseContactService;
    private Toolbar toolbar;
    private MessageDatabaseService messageDatabaseService;
    private int visibleThreshold = 5;
    private int currentPage = 0;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private int startingPageIndex = 0;
    private ProgressBar progressBar;

    public ConversationListView getListView() {
        return this.listView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.applozicSetting = ApplozicSetting.getInstance((Context)this.getActivity());
        this.syncCallService = SyncCallService.getInstance((Context)this.getActivity());
        this.conversationAdapter = new QuickConversationAdapter((Context)this.getActivity(), this.messageList, null);
        this.baseContactService = new AppContactService((Context)this.getActivity());
        this.messageDatabaseService = new MessageDatabaseService((Context)this.getActivity());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComUserPreference.getInstance((Context)MobiComQuickConversationFragment.this.getActivity()).setDeviceTimeOffset(DateUtils.getTimeDiffFromUtc());
            }
        });
        thread.setPriority(10);
        thread.start();
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View list = inflater.inflate(R.layout.mobicom_message_list, container, false);
        this.listView = (ConversationListView)list.findViewById(R.id.messageList);
        this.listView.setBackgroundColor(this.getResources().getColor(R.color.conversation_list_all_background));
        this.listView.setScrollToBottomOnSizeChange(Boolean.FALSE);
        this.toolbar = (Toolbar)this.getActivity().findViewById(R.id.my_toolbar);
        this.toolbar.setClickable(false);
        this.fabButton = (ImageButton)list.findViewById(R.id.fab_start_new);
        this.loading = true;
        LinearLayout individualMessageSendLayout = (LinearLayout)list.findViewById(R.id.individual_message_send_layout);
        LinearLayout extendedSendingOptionLayout = (LinearLayout)list.findViewById(R.id.extended_sending_option_layout);
        individualMessageSendLayout.setVisibility(8);
        extendedSendingOptionLayout.setVisibility(8);
        View spinnerLayout = inflater.inflate(R.layout.mobicom_message_list_header_footer, null);
        this.progressBar = (ProgressBar)spinnerLayout.findViewById(R.id.load_more_progressbar);
        this.listView.addFooterView(spinnerLayout);
        this.emptyTextView = (TextView)list.findViewById(R.id.noConversations);
        this.fabButton.setVisibility(this.applozicSetting.isStartNewFloatingActionButtonVisible() ? 0 : 8);
        this.swipeLayout = (SwipeRefreshLayout)list.findViewById(R.id.swipe_container);
        this.swipeLayout.setColorScheme(new int[]{17170459, 17170452, 17170456, 0x1060016});
        this.listView.setLongClickable(true);
        this.registerForContextMenu((View)this.listView);
        return list;
    }

    protected View.OnClickListener startNewConversation() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                ((MobiComKitActivityInterface)MobiComQuickConversationFragment.this.getActivity()).startContactActivityForResult();
            }
        };
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu2, v, menuInfo);
        menu2.setHeaderTitle(R.string.conversation);
        menu2.add(0, 0, 0, (CharSequence)"Delete");
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int position = info.position;
        if (this.messageList.size() <= position) {
            return true;
        }
        Message message = this.messageList.get(position);
        switch (item.getItemId()) {
            case 0: {
                Channel channel = null;
                Contact contact = null;
                if (message.getGroupId() != null) {
                    channel = ChannelDatabaseService.getInstance((Context)this.getActivity()).getChannelByChannelKey(message.getGroupId());
                } else {
                    contact = this.baseContactService.getContactById(message.getContactIds());
                }
                new ConversationUIService(this.getActivity()).deleteConversationThread(contact, channel);
                break;
            }
            default: {
                return super.onContextItemSelected(item);
            }
        }
        return true;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        if (!ApplozicSetting.getInstance((Context)this.getActivity()).isStartNewButtonVisible()) {
            menu2.removeItem(R.id.start_new);
        } else {
            menu2.findItem(R.id.start_new).setVisible(true);
        }
        if (!ApplozicSetting.getInstance((Context)this.getActivity()).isStartNewGroupButtonVisible()) {
            menu2.removeItem(R.id.conversations);
        } else {
            menu2.findItem(R.id.conversations).setVisible(true);
        }
        menu2.findItem(R.id.refresh).setVisible(true);
        if (ApplozicSetting.getInstance((Context)this.getActivity()).isProfileOptionEnabled()) {
            menu2.findItem(R.id.applozicUserProfile).setVisible(true);
        }
    }

    public void addMessage(final Message message) {
        FragmentActivity context = this.getActivity();
        this.getActivity().runOnUiThread(new Runnable((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            @Override
            public void run() {
                message.processContactIds(this.val$context);
                Message recentMessage = message.getGroupId() != null ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + message.getGroupId()) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(message.getContactIds());
                if (recentMessage != null && message.getCreatedAtTime() >= recentMessage.getCreatedAtTime()) {
                    MobiComQuickConversationFragment.this.messageList.remove(recentMessage);
                } else if (recentMessage != null) {
                    return;
                }
                if (message.getGroupId() != null) {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + message.getGroupId(), message);
                } else {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put(message.getContactIds(), message);
                }
                MobiComQuickConversationFragment.this.messageList.add(0, message);
                MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                MobiComQuickConversationFragment.this.listView.setSelection(0);
                MobiComQuickConversationFragment.this.emptyTextView.setVisibility(8);
            }
        });
    }

    public void updateLastMessage(String keyString, String userId) {
        for (Message message : this.messageList) {
            if (message.getKeyString() == null || !message.getKeyString().equals(keyString)) continue;
            List lastMessage = message.getGroupId() != null ? this.messageDatabaseService.getLatestMessageByChannelKey(message.getGroupId()) : this.messageDatabaseService.getLatestMessage(message.getContactIds());
            if (lastMessage.isEmpty()) {
                this.removeConversation(message, userId);
                break;
            }
            this.deleteMessage((Message)lastMessage.get(0), userId);
            break;
        }
    }

    public String getLatestContact() {
        if (this.messageList != null && !this.messageList.isEmpty()) {
            Message message = this.messageList.get(0);
            return message.getTo();
        }
        return null;
    }

    public void updateUserName(Integer channelKey) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deleteMessage(final Message message, String userId) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Message recentMessage = message.getGroupId() != null ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + message.getGroupId()) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(message.getContactIds());
                if (recentMessage != null && message.getCreatedAtTime() <= recentMessage.getCreatedAtTime()) {
                    if (message.getGroupId() != null) {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + message.getGroupId(), message);
                    } else {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put(message.getContactIds(), message);
                    }
                    MobiComQuickConversationFragment.this.messageList.set(MobiComQuickConversationFragment.this.messageList.indexOf(recentMessage), message);
                    MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    if (MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                        MobiComQuickConversationFragment.this.emptyTextView.setVisibility(0);
                    }
                }
            }
        });
    }

    public void updateLatestMessage(Message message, String userId) {
        this.deleteMessage(message, userId);
    }

    public void removeConversation(final Message message, String userId) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (message.getGroupId() != null && message.getGroupId() != 0) {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.remove("group-" + message.getGroupId());
                } else {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.remove(message.getContactIds());
                }
                MobiComQuickConversationFragment.this.messageList.remove(message);
                MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                MobiComQuickConversationFragment.this.checkForEmptyConversations();
            }
        });
    }

    public void removeConversation(final Contact contact, final Integer channelKey, String response) {
        if ("success".equals(response)) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Message message = null;
                    message = channelKey != null && channelKey != 0 ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + channelKey) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(contact.getUserId());
                    MobiComQuickConversationFragment.this.messageList.remove(message);
                    if (channelKey != null && channelKey != 0) {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.remove("group-" + channelKey);
                    } else {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.remove(contact.getUserId());
                    }
                    MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    MobiComQuickConversationFragment.this.checkForEmptyConversations();
                }
            });
        } else if (!Utils.isInternetAvailable((Context)this.getActivity())) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.you_need_network_access_for_delete), (int)0).show();
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.delete_conversation_failed), (int)0).show();
        }
    }

    public void checkForEmptyConversations() {
        boolean isLodingConversation;
        boolean bl = isLodingConversation = this.downloadConversation != null && this.downloadConversation.getStatus() == AsyncTask.Status.RUNNING;
        if (this.latestMessageForEachContact.isEmpty() && !isLodingConversation) {
            this.emptyTextView.setVisibility(0);
        } else {
            this.emptyTextView.setVisibility(8);
        }
    }

    public void setLoadMore(boolean loadMore) {
        this.loadMore = loadMore;
    }

    public void onPause() {
        super.onPause();
        this.listIndex = this.listView.getFirstVisiblePosition();
        BroadcastService.currentUserId = null;
        if (this.conversationAdapter != null) {
            this.conversationAdapter.contactImageLoader.setPauseWork(false);
            this.conversationAdapter.channelImageLoader.setPauseWork(false);
        }
    }

    public void onResume() {
        this.toolbar.setTitle((CharSequence)"Chats");
        this.toolbar.setSubtitle((CharSequence)"");
        BroadcastService.selectMobiComKitAll();
        super.onResume();
        this.latestMessageForEachContact.clear();
        this.messageList.clear();
        if (this.listView != null) {
            if (this.listView.getCount() > this.listIndex) {
                this.listView.setSelection(this.listIndex);
            } else {
                this.listView.setSelection(0);
            }
        }
        this.downloadConversations();
        this.swipeLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                SyncMessages syncMessages = new SyncMessages();
                syncMessages.execute(new Void[0]);
            }
        });
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.listView.setAdapter((ListAdapter)this.conversationAdapter);
        this.fabButton.setOnClickListener(this.startNewConversation());
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (MobiComQuickConversationFragment.this.conversationAdapter != null) {
                    MobiComQuickConversationFragment.this.conversationAdapter.contactImageLoader.setPauseWork(scrollState == 2);
                    MobiComQuickConversationFragment.this.conversationAdapter.channelImageLoader.setPauseWork(scrollState == 2);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (MobiComQuickConversationFragment.this.loading && totalItemCount > MobiComQuickConversationFragment.this.previousTotalItemCount) {
                    if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                        MobiComQuickConversationFragment.this.loading = false;
                    }
                    MobiComQuickConversationFragment.this.previousTotalItemCount = totalItemCount;
                    MobiComQuickConversationFragment.this.currentPage++;
                }
                if (totalItemCount - visibleItemCount == 0) {
                    return;
                }
                if (MobiComQuickConversationFragment.this.loadMore && !MobiComQuickConversationFragment.this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + MobiComQuickConversationFragment.this.visibleThreshold) {
                    DownloadConversation downloadConversation = new DownloadConversation(view, false, firstVisibleItem, visibleItemCount, totalItemCount);
                    AsyncTaskCompat.executeParallel((AsyncTask)downloadConversation, (Object[])new Void[0]);
                    MobiComQuickConversationFragment.this.loading = true;
                }
            }
        });
    }

    public void downloadConversations() {
        this.downloadConversations(false);
    }

    public void downloadConversations(boolean showInstruction) {
        this.minCreatedAtTime = null;
        this.downloadConversation = new DownloadConversation((AbsListView)this.listView, true, 1, 0, 0, showInstruction);
        AsyncTaskCompat.executeParallel((AsyncTask)this.downloadConversation, (Object[])new Void[0]);
    }

    public void updateLastSeenStatus(final String userId) {
        if (!ApplozicSetting.getInstance((Context)this.getActivity()).isOnlineStatusInMasterListVisible()) {
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    int index;
                    View view;
                    Message message = MobiComQuickConversationFragment.this.latestMessageForEachContact.get(userId);
                    if (message != null && (view = MobiComQuickConversationFragment.this.listView.getChildAt((index = MobiComQuickConversationFragment.this.messageList.indexOf(message)) - MobiComQuickConversationFragment.this.listView.getFirstVisiblePosition())) != null) {
                        TextView onlineTextView = (TextView)view.findViewById(R.id.onlineTextView);
                        Contact contact = MobiComQuickConversationFragment.this.baseContactService.getContactById(userId);
                        onlineTextView.setVisibility(contact != null && contact.isOnline() ? 0 : 8);
                    }
                }
                catch (Exception ex) {
                    Log.w((String)"AL", (String)"Exception while updating online status.");
                }
            }
        });
    }

    private class SyncMessages
    extends AsyncTask<Void, Integer, Long> {
        SyncMessages() {
        }

        protected Long doInBackground(Void ... params) {
            MobiComQuickConversationFragment.this.syncCallService.syncMessages(null);
            return 1L;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            MobiComQuickConversationFragment.this.swipeLayout.setRefreshing(false);
        }
    }

    public class DownloadConversation
    extends AsyncTask<Void, Integer, Long> {
        private AbsListView view;
        private int firstVisibleItem;
        private int amountVisible;
        private int totalItems;
        private boolean initial;
        private boolean showInstruction;
        private List<Message> nextMessageList = new ArrayList<Message>();
        private Context context;
        private boolean loadMoreMessages;

        public DownloadConversation(AbsListView view, boolean initial, int firstVisibleItem, int amountVisible, int totalItems, boolean showInstruction) {
            this.context = MobiComQuickConversationFragment.this.getActivity();
            this.view = view;
            this.initial = initial;
            this.firstVisibleItem = firstVisibleItem;
            this.amountVisible = amountVisible;
            this.totalItems = totalItems;
            this.showInstruction = showInstruction;
        }

        public DownloadConversation(AbsListView view, boolean initial, int firstVisibleItem, int amountVisible, int totalItems) {
            this(view, initial, firstVisibleItem, amountVisible, totalItems, false);
            this.loadMoreMessages = true;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (MobiComQuickConversationFragment.this.progressBar != null && this.loadMoreMessages) {
                MobiComQuickConversationFragment.this.progressBar.setVisibility(0);
            } else {
                MobiComQuickConversationFragment.this.swipeLayout.setEnabled(true);
                MobiComQuickConversationFragment.this.swipeLayout.post(new Runnable(){

                    @Override
                    public void run() {
                        MobiComQuickConversationFragment.this.swipeLayout.setRefreshing(true);
                    }
                });
            }
        }

        protected Long doInBackground(Void ... voids) {
            if (this.initial) {
                this.nextMessageList = MobiComQuickConversationFragment.this.syncCallService.getLatestMessagesGroupByPeople();
                if (!this.nextMessageList.isEmpty()) {
                    MobiComQuickConversationFragment.this.minCreatedAtTime = this.nextMessageList.get(this.nextMessageList.size() - 1).getCreatedAtTime();
                }
            } else if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                MobiComQuickConversationFragment.this.listIndex = this.firstVisibleItem;
                Long createdAt = MobiComQuickConversationFragment.this.messageList.isEmpty() ? null : MobiComQuickConversationFragment.this.messageList.get(MobiComQuickConversationFragment.this.messageList.size() - 1).getCreatedAtTime();
                MobiComQuickConversationFragment.this.minCreatedAtTime = MobiComQuickConversationFragment.this.minCreatedAtTime == null ? createdAt : Math.min(MobiComQuickConversationFragment.this.minCreatedAtTime, createdAt);
                this.nextMessageList = MobiComQuickConversationFragment.this.syncCallService.getLatestMessagesGroupByPeople(MobiComQuickConversationFragment.this.minCreatedAtTime);
            }
            return 0L;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Long result) {
            if (!this.loadMoreMessages) {
                MobiComQuickConversationFragment.this.swipeLayout.setEnabled(true);
                MobiComQuickConversationFragment.this.swipeLayout.post(new Runnable(){

                    @Override
                    public void run() {
                        MobiComQuickConversationFragment.this.swipeLayout.setRefreshing(false);
                    }
                });
            }
            for (Message currentMessage : this.nextMessageList) {
                if (currentMessage.isSentToMany()) continue;
                Message recentSms = currentMessage.getGroupId() != null ? MobiComQuickConversationFragment.this.latestMessageForEachContact.get("group-" + currentMessage.getGroupId()) : MobiComQuickConversationFragment.this.latestMessageForEachContact.get(currentMessage.getContactIds());
                if (recentSms != null) {
                    if (currentMessage.getCreatedAtTime() < recentSms.getCreatedAtTime()) continue;
                    if (currentMessage.getGroupId() != null) {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + currentMessage.getGroupId(), currentMessage);
                    } else {
                        MobiComQuickConversationFragment.this.latestMessageForEachContact.put(currentMessage.getContactIds(), currentMessage);
                    }
                    Log.d((String)"Current message", (String)("message" + currentMessage));
                    MobiComQuickConversationFragment.this.messageList.remove(recentSms);
                    MobiComQuickConversationFragment.this.messageList.add(currentMessage);
                    continue;
                }
                if (currentMessage.getGroupId() != null) {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put("group-" + currentMessage.getGroupId(), currentMessage);
                } else {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put(currentMessage.getContactIds(), currentMessage);
                }
                MobiComQuickConversationFragment.this.messageList.add(currentMessage);
            }
            if (MobiComQuickConversationFragment.this.progressBar != null && this.loadMoreMessages) {
                MobiComQuickConversationFragment.this.progressBar.setVisibility(8);
            }
            MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            if (this.initial) {
                MobiComQuickConversationFragment.this.emptyTextView.setVisibility(MobiComQuickConversationFragment.this.messageList.isEmpty() ? 0 : 8);
                if (MobiComQuickConversationFragment.this.applozicSetting.isStartNewButtonVisible()) {
                    // empty if block
                }
                if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                    MobiComQuickConversationFragment.this.listView.setSelection(0);
                }
            } else if (!this.loadMoreMessages) {
                MobiComQuickConversationFragment.this.listView.setSelection(this.firstVisibleItem);
            }
            if (this.context != null && this.showInstruction) {
                InstructionUtil.showInstruction(this.context, R.string.instruction_open_conversation_thread, 5000, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
            }
            if (!this.nextMessageList.isEmpty()) {
                MobiComQuickConversationFragment.this.loadMore = true;
            }
        }
    }
}

