/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FileUtils;
import java.util.ArrayList;

public class MobiComAttachmentGridViewAdapter
extends BaseAdapter {
    public static final int REQUEST_CODE = 100;
    private Context context;
    private ArrayList<Uri> uris;
    ImageButton deleteButton;
    ImageView galleryImageView;
    TextView fileSize;
    ImageView attachmentImageView;
    TextView fileName;

    public MobiComAttachmentGridViewAdapter(Context context, ArrayList<Uri> uris) {
        this.context = context;
        this.uris = uris;
    }

    public int getCount() {
        return this.uris.size() + 1;
    }

    public Object getItem(int i) {
        return this.uris.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(final int position, View view, ViewGroup viewGroup) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        if (view == null) {
            view = inflater.inflate(R.layout.mobicom_attachment_gridview_item, viewGroup, false);
        }
        this.deleteButton = (ImageButton)view.findViewById(R.id.mobicom_attachment_delete_btn);
        this.galleryImageView = (ImageView)view.findViewById(R.id.galleryImageView);
        this.fileSize = (TextView)view.findViewById(R.id.mobicom_attachment_file_size);
        this.attachmentImageView = (ImageView)view.findViewById(R.id.mobicom_attachment_image);
        this.fileName = (TextView)view.findViewById(R.id.mobicom_attachment_file_name);
        this.galleryImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (position < MobiComAttachmentGridViewAdapter.this.getCount() - 1) {
                    return;
                }
                if (MobiComAttachmentGridViewAdapter.this.getCount() > ApplozicSetting.getInstance(MobiComAttachmentGridViewAdapter.this.context).getMaxAttachmentAllowed()) {
                    Toast.makeText((Context)MobiComAttachmentGridViewAdapter.this.context, (int)R.string.mobicom_max_attachment_warning, (int)1).show();
                    return;
                }
                Intent getContentIntent = FileUtils.createGetContentIntent();
                getContentIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                Intent intentPick = Intent.createChooser((Intent)getContentIntent, (CharSequence)MobiComAttachmentGridViewAdapter.this.context.getString(R.string.select_file));
                ((Activity)MobiComAttachmentGridViewAdapter.this.context).startActivityForResult(intentPick, 100);
            }
        });
        this.deleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobiComAttachmentGridViewAdapter.this.uris.remove(position);
                MobiComAttachmentGridViewAdapter.this.notifyDataSetChanged();
            }
        });
        if (position == this.getCount() - 1) {
            this.setNewAttachmentView();
            return view;
        }
        this.deleteButton.setVisibility(0);
        try {
            Uri uri = (Uri)this.getItem(position);
            Bitmap previewBitmap = ImageUtils.getPreview((Context)this.context, (Uri)uri);
            if (previewBitmap != null) {
                this.setGalleryView(previewBitmap);
            } else {
                this.setAttachmentView(uri);
            }
            this.fileSize.setText((CharSequence)this.getSize(uri));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    private void setAttachmentView(Uri uri) {
        this.attachmentImageView.setVisibility(0);
        this.fileName.setVisibility(0);
        this.fileName.setText((CharSequence)this.getFileName(uri));
        this.galleryImageView.setImageBitmap(null);
    }

    private void setGalleryView(Bitmap previewBitmap) {
        this.galleryImageView.setImageBitmap(previewBitmap);
        this.fileName.setVisibility(8);
        this.attachmentImageView.setVisibility(8);
    }

    private void setNewAttachmentView() {
        this.deleteButton.setVisibility(8);
        this.galleryImageView.setImageResource(R.drawable.applozic_ic_action_add);
        this.fileName.setVisibility(8);
        this.attachmentImageView.setVisibility(8);
        this.fileSize.setText((CharSequence)"New Attachment");
    }

    public String getFileName(Uri uri) {
        String fileName = null;
        Cursor returnCursor = this.context.getContentResolver().query(uri, null, null, null, null);
        if (returnCursor != null && returnCursor.moveToFirst()) {
            int columnIndex = returnCursor.getColumnIndex("_display_name");
            fileName = returnCursor.getString(columnIndex);
        }
        return fileName;
    }

    public String getSize(Uri uri) {
        String sizeInMB = null;
        Cursor returnCursor = this.context.getContentResolver().query(uri, null, null, null, null);
        if (returnCursor != null && returnCursor.moveToFirst()) {
            int columnIndex = returnCursor.getColumnIndex("_size");
            Long fileSize = returnCursor.getLong(columnIndex);
            sizeInMB = fileSize < 1024L ? (int)(fileSize / 0x100000L) + " B" : (fileSize < 0x100000L ? (int)(fileSize / 1024L) + " KB" : (int)(fileSize / 0x100000L) + " MB");
        }
        return sizeInMB;
    }
}

