/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.widget.TextView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.SpinnerNavItem;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.TitleNavigationAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;

public abstract class MobiComActivityForFragment
extends ActionBarActivity
implements ActionBar.OnNavigationListener,
MessageCommunicator,
MobiComKitActivityInterface {
    public static final int REQUEST_CODE_FULL_SCREEN_ACTION = 301;
    public static final int REQUEST_CODE_CONTACT_GROUP_SELECTION = 101;
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final int REQUEST_CODE_ATTACHMENT_ACTION = 201;
    public static final int ACCOUNT_REGISTERED = 121;
    public static final int INSTRUCTION_DELAY = 5000;
    protected static final long UPDATE_INTERVAL = 5L;
    protected static final long FASTEST_INTERVAL = 1L;
    private static final String TAG = "MobiComActivity";
    public static String currentOpenedUserId;
    public static boolean mobiTexterBroadcastReceiverActivated;
    public static String title;
    protected static boolean HOME_BUTTON_ENABLED;
    protected ActionBar mActionBar;
    protected MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    protected MobiComQuickConversationFragment quickConversationFragment;
    protected MobiComConversationFragment conversationFragment;
    protected ArrayList<SpinnerNavItem> navSpinner;
    protected TitleNavigationAdapter adapter;
    protected BaseContactService baseContactService;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onResume() {
        super.onResume();
        InstructionUtil.enabled = true;
    }

    protected void onPause() {
        super.onPause();
        InstructionUtil.enabled = false;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.removeItem(R.id.start_new);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        menu2.removeItem(R.id.conversations);
        return super.onCreateOptionsMenu(menu2);
    }

    protected void onStart() {
        super.onStart();
    }

    public abstract void processLocation();

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if ((requestCode == 12 || requestCode == 11) && resultCode == -1) {
            Uri selectedFileUri;
            Uri uri = selectedFileUri = intent == null ? null : intent.getData();
            if (selectedFileUri == null) {
                selectedFileUri = this.conversationFragment.getMultimediaOptionFragment().getCapturedImageUri();
                ImageUtils.addImageToGallery((String)FilePathFinder.getPath((Context)this, (Uri)selectedFileUri), (Context)this);
            }
            if (selectedFileUri == null) {
                Bitmap photo = (Bitmap)intent.getExtras().get("data");
                selectedFileUri = ImageUtils.getImageUri((Context)this.getApplicationContext(), (Bitmap)photo);
            }
            this.conversationFragment.loadFile(selectedFileUri);
            Log.i((String)TAG, (String)("File uri: " + selectedFileUri));
        } else if (requestCode == 101 && resultCode == -1) {
            this.checkForStartNewConversation(intent);
        }
    }

    @Override
    public abstract void startContactActivityForResult();

    public void startContactActivityForResult(Intent intent, Message message, String messageContent) {
        if (message != null) {
            intent.putExtra("forwardMessage", GsonUtils.getJsonFromObject((Object)message, message.getClass()));
        }
        if (messageContent != null) {
            intent.putExtra("SHARED_TEXT", messageContent);
        }
        this.startActivityForResult(intent, 101);
    }

    public abstract void startContactActivityForResult(Message var1, String var2);

    @Override
    public void onQuickConversationFragmentItemClick(View view, Contact contact, Channel channel, Integer conversationId) {
        TextView textView = (TextView)view.findViewById(R.id.unreadSmsCount);
        textView.setVisibility(8);
    }

    public void loadLatestInConversationFragment() {
        if (this.conversationFragment.getContact() != null || this.conversationFragment.getChannel() != null) {
            return;
        }
        String latestContact = this.quickConversationFragment.getLatestContact();
        if (latestContact != null) {
            Contact contact = this.baseContactService.getContactById(latestContact);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return keyCode == 82 && "LGE".equalsIgnoreCase(Build.BRAND) || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82 && "LGE".equalsIgnoreCase(Build.BRAND)) {
            this.openOptionsMenu();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void setNavSpinner(ArrayList<SpinnerNavItem> navSpinner) {
        this.navSpinner = navSpinner;
    }

    public void setAdapter(TitleNavigationAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void updateLatestMessage(Message message, String formattedContactNumber) {
        this.quickConversationFragment.updateLatestMessage(message, formattedContactNumber);
    }

    @Override
    public void removeConversation(Message message, String formattedContactNumber) {
        this.quickConversationFragment.removeConversation(message, formattedContactNumber);
    }

    public void checkForStartNewConversation(Intent intent) {
        String sharedText;
        String forwardMessage;
        boolean support;
        String messageJson;
        String userId;
        Uri uri;
        Contact contact = null;
        Channel channel = null;
        if ("android.intent.action.SEND".equals(intent.getAction()) && intent.getType() != null) {
            if ("text/plain".equals(intent.getType())) {
                String sharedText2 = intent.getStringExtra("android.intent.extra.TEXT");
                if (sharedText2 != null) {
                    this.startContactActivityForResult(null, sharedText2);
                }
            } else if (intent.getType().startsWith("image/")) {
                // empty if block
            }
        }
        if ((uri = intent.getData()) != null) {
            Long contactId = intent.getLongExtra("contactId", 0L);
            if (contactId == 0L) {
                return;
            }
            contact = this.baseContactService.getContactById(String.valueOf(contactId));
        }
        Integer groupId = intent.getIntExtra("groupId", -1);
        String groupName = intent.getStringExtra("groupName");
        if (groupId != -1) {
            channel = ChannelUtils.fetchGroup((Context)this, (Integer)groupId, (String)groupName);
        }
        String contactNumber = intent.getStringExtra("contactNumber");
        boolean firstTimeMTexterFriend = intent.getBooleanExtra("firstTimeMTexterFriend", false);
        if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
            contact = this.baseContactService.getContactById(contactNumber);
            this.conversationFragment.setFirstTimeMTexterFriend(firstTimeMTexterFriend);
        }
        if (!TextUtils.isEmpty((CharSequence)(userId = intent.getStringExtra("userId")))) {
            contact = new Contact((Context)this, userId);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageJson = intent.getStringExtra("message_json")))) {
            Message message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
            contact = this.baseContactService.getContactById(message.getTo());
        }
        if (support = intent.getBooleanExtra("SUPPORT_INTENT_KEY", false)) {
            contact = new Support((Context)this).getSupportContact();
        }
        if (contact != null) {
            // empty if block
        }
        if (channel != null) {
            // empty if block
        }
        if (!TextUtils.isEmpty((CharSequence)(forwardMessage = intent.getStringExtra("forwardMessage")))) {
            Message messageToForward = (Message)GsonUtils.getObjectFromJson((String)forwardMessage, Message.class);
            this.conversationFragment.forwardMessage(messageToForward, contact);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = intent.getStringExtra("SHARED_TEXT")))) {
            this.conversationFragment.sendMessage(sharedText);
        }
    }

    public boolean onNavigationItemSelected(int i, long l) {
        if (i == 0) {
            return false;
        }
        SpinnerNavItem spinnerNavItem = this.navSpinner.get(i);
        Contact contact = spinnerNavItem.getContact();
        contact.setContactNumber(spinnerNavItem.getContactNumber());
        this.conversationFragment.loadConversation(contact, null);
        return false;
    }

    public void onBackPressed() {
        if (this.conversationFragment != null && this.conversationFragment.emoticonsFrameLayout.getVisibility() == 0) {
            this.conversationFragment.emoticonsFrameLayout.setVisibility(8);
            return;
        }
        super.onBackPressed();
        this.finish();
    }

    static {
        title = "Conversations";
        HOME_BUTTON_ENABLED = false;
    }
}

