/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.schedule;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.contact.ContactUtils;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ScheduledMessageAdapter
extends ArrayAdapter<Message> {
    private ImageLoader mImageLoader;
    private BaseContactService baseContactService;

    public ScheduledMessageAdapter(Context context, int textViewResourceId, List<Message> smsList) {
        super(context, textViewResourceId, smsList);
        this.baseContactService = new AppContactService(context);
        this.mImageLoader = new ImageLoader(this.getContext(), ImageUtils.getLargestScreenDimension((Activity)((Activity)this.getContext()))){

            protected Bitmap processBitmap(Object data) {
                return ScheduledMessageAdapter.this.loadContactPhoto((Uri)data, this.getImageSize());
            }
        };
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.mImageLoader.setImageFadeIn(false);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Message messageListItem;
        View customView = convertView;
        if (customView == null) {
            LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            customView = inflater.inflate(R.layout.mobicom_message_row_view, null);
            ImageView sentOrReceived = (ImageView)customView.findViewById(R.id.sentOrReceivedIcon);
            sentOrReceived.setVisibility(8);
            TextView unreadSmsTxtView = (TextView)customView.findViewById(R.id.unreadSmsCount);
            unreadSmsTxtView.setVisibility(8);
        }
        if ((messageListItem = (Message)this.getItem(position)) != null) {
            TextView smReceivers = (TextView)customView.findViewById(R.id.smReceivers);
            TextView smTime = (TextView)customView.findViewById(R.id.createdAtTime);
            TextView scheduledMessage = (TextView)customView.findViewById(R.id.message);
            ImageView contactImage = (ImageView)customView.findViewById(R.id.contactImage);
            if (smReceivers != null) {
                String contactinfo;
                List<String> items = Arrays.asList(messageListItem.getTo().split("\\s*,\\s*"));
                Contact contact1 = ContactUtils.getContact((Context)this.getContext(), (String)items.get(0));
                String string2 = contactinfo = TextUtils.isEmpty((CharSequence)contact1.getFirstName()) ? contact1.getContactNumber() : contact1.getFirstName();
                if (items.size() > 1) {
                    Contact contact2 = this.baseContactService.getContactById(items.get(1));
                    contactinfo = contactinfo + " , " + (TextUtils.isEmpty((CharSequence)contact2.getFirstName()) ? contact2.getContactNumber() : contact2.getFirstName());
                }
                smReceivers.setText((CharSequence)(contactinfo.length() > 22 ? contactinfo.substring(0, 22) + "..." : contactinfo));
                String contactId = ContactUtils.getContactId((String)items.get(0), (ContentResolver)this.getContext().getContentResolver());
                Uri contactUri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_URI, (String)contactId);
                this.mImageLoader.loadImage((Object)contactUri, contactImage);
            }
            if (smTime != null) {
                Calendar calendarForCurrent = Calendar.getInstance();
                Calendar calendarForScheduled = Calendar.getInstance();
                Date currentDate = new Date();
                Date date = new Date(messageListItem.getScheduledAt());
                calendarForCurrent.setTime(currentDate);
                calendarForScheduled.setTime(date);
                boolean sameDay = calendarForCurrent.get(1) == calendarForScheduled.get(1) && calendarForCurrent.get(6) == calendarForScheduled.get(6);
                String formattedDate = sameDay ? DateFormat.getTimeInstance().format(date) : DateFormat.getDateInstance().format(date);
                smTime.setText((CharSequence)formattedDate);
            }
            if (scheduledMessage != null) {
                scheduledMessage.setText((CharSequence)messageListItem.getMessage());
            }
        }
        return customView;
    }

    @TargetApi(value=14)
    private Bitmap loadContactPhoto(Uri contactUri, int imageSize) {
        if (this.getContext() == null) {
            return null;
        }
        return ContactUtils.loadContactPhoto((Uri)contactUri, (int)imageSize, (Activity)((Activity)this.getContext()));
    }
}

