/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationListView;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.QuickConversationAdapter;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobiComQuickConversationFragment
extends Fragment {
    public static final String QUICK_CONVERSATION_EVENT = "quick_conversation";
    protected MobiComConversationService conversationService;
    protected ConversationListView listView = null;
    protected ImageButton fabButton;
    protected TextView emptyTextView;
    protected Button startNewButton;
    protected SwipeRefreshLayout swipeLayout;
    protected int listIndex;
    protected Map<String, Message> latestMessageForEachContact = new HashMap<String, Message>();
    protected List<Message> messageList = new ArrayList<Message>();
    protected QuickConversationAdapter conversationAdapter = null;
    protected boolean loadMore = false;
    private ApplozicSetting applozicSetting;
    private Long minCreatedAtTime;
    private DownloadConversation downloadConversation;
    private BaseContactService baseContactService;

    public ConversationListView getListView() {
        return this.listView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.applozicSetting = ApplozicSetting.getInstance((Context)this.getActivity());
        this.conversationService = new MobiComConversationService((Context)this.getActivity());
        this.conversationAdapter = new QuickConversationAdapter((Context)this.getActivity(), this.messageList, null);
        this.baseContactService = new AppContactService((Context)this.getActivity());
        new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComUserPreference.getInstance((Context)MobiComQuickConversationFragment.this.getActivity()).setDeviceTimeOffset(DateUtils.getTimeDiffFromUtc());
            }
        }).start();
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View list = inflater.inflate(R.layout.mobicom_message_list, container, false);
        this.listView = (ConversationListView)list.findViewById(R.id.messageList);
        this.listView.setScrollToBottomOnSizeChange(Boolean.FALSE);
        this.fabButton = (ImageButton)list.findViewById(R.id.fab_start_new);
        LinearLayout individualMessageSendLayout = (LinearLayout)list.findViewById(R.id.individual_message_send_layout);
        LinearLayout extendedSendingOptionLayout = (LinearLayout)list.findViewById(R.id.extended_sending_option_layout);
        individualMessageSendLayout.setVisibility(8);
        extendedSendingOptionLayout.setVisibility(8);
        View spinnerLayout = inflater.inflate(R.layout.mobicom_message_list_header_footer, null);
        this.listView.addFooterView(spinnerLayout);
        this.emptyTextView = (TextView)spinnerLayout.findViewById(R.id.noConversations);
        this.startNewButton = (Button)spinnerLayout.findViewById(R.id.start_new_conversation);
        this.fabButton.setVisibility(this.applozicSetting.isStartNewFloatingActionButtonVisible() ? 0 : 8);
        this.swipeLayout = (SwipeRefreshLayout)list.findViewById(R.id.swipe_container);
        this.swipeLayout.setColorScheme(new int[]{17170459, 17170452, 17170456, 0x1060016});
        this.listView.setLongClickable(true);
        this.registerForContextMenu((View)this.listView);
        return list;
    }

    protected View.OnClickListener startNewConversation() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                ((MobiComKitActivityInterface)MobiComQuickConversationFragment.this.getActivity()).startContactActivityForResult();
            }
        };
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu2, v, menuInfo);
        menu2.setHeaderTitle(R.string.conversation);
        menu2.add(0, 0, 0, (CharSequence)"Delete");
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int position = info.position;
        if (this.messageList.size() <= position) {
            return true;
        }
        Message message = this.messageList.get(position);
        switch (item.getItemId()) {
            case 0: {
                Contact contact = this.baseContactService.getContactById(message.getContactIds());
                new ConversationUIService(this.getActivity()).deleteConversationThread(contact, contact.getDisplayName());
                break;
            }
            default: {
                return super.onContextItemSelected(item);
            }
        }
        return true;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        menu2.removeItem(R.id.dial);
        menu2.removeItem(R.id.deleteConversation);
    }

    public void addMessage(final Message message) {
        FragmentActivity context = this.getActivity();
        this.getActivity().runOnUiThread(new Runnable((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            @Override
            public void run() {
                message.processContactIds(this.val$context);
                Message recentMessage = MobiComQuickConversationFragment.this.latestMessageForEachContact.get(message.getContactIds());
                if (recentMessage != null && message.getCreatedAtTime() >= recentMessage.getCreatedAtTime()) {
                    MobiComQuickConversationFragment.this.messageList.remove(recentMessage);
                } else if (recentMessage != null) {
                    return;
                }
                MobiComQuickConversationFragment.this.latestMessageForEachContact.put(message.getContactIds(), message);
                MobiComQuickConversationFragment.this.messageList.add(0, message);
                MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                MobiComQuickConversationFragment.this.listView.setSelection(0);
                MobiComQuickConversationFragment.this.emptyTextView.setVisibility(8);
                MobiComQuickConversationFragment.this.startNewButton.setVisibility(8);
            }
        });
    }

    public void updateLastMessage(String keyString, String userId) {
        for (Message message : this.messageList) {
            if (message.getKeyString() == null || !message.getKeyString().equals(keyString)) continue;
            MessageDatabaseService messageDatabaseService = new MessageDatabaseService((Context)this.getActivity());
            List lastMessage = messageDatabaseService.getLatestMessage(userId);
            if (lastMessage.isEmpty()) {
                this.removeConversation(message, userId);
                break;
            }
            this.deleteMessage((Message)lastMessage.get(0), userId);
            break;
        }
    }

    public String getLatestContact() {
        if (this.messageList != null && !this.messageList.isEmpty()) {
            Message message = this.messageList.get(0);
            return message.getTo();
        }
        return null;
    }

    public void deleteMessage(final Message message, final String userId) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Message recentMessage = MobiComQuickConversationFragment.this.latestMessageForEachContact.get(userId);
                if (recentMessage != null && message.getCreatedAtTime() <= recentMessage.getCreatedAtTime()) {
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put(userId, message);
                    MobiComQuickConversationFragment.this.messageList.set(MobiComQuickConversationFragment.this.messageList.indexOf(recentMessage), message);
                    MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    if (MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                        MobiComQuickConversationFragment.this.emptyTextView.setVisibility(0);
                        MobiComQuickConversationFragment.this.startNewButton.setVisibility(MobiComQuickConversationFragment.this.applozicSetting.isStartNewButtonVisible() ? 0 : 8);
                    }
                }
            }
        });
    }

    public void updateLatestMessage(Message message, String userId) {
        this.deleteMessage(message, userId);
    }

    public void removeConversation(final Message message, final String userId) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MobiComQuickConversationFragment.this.latestMessageForEachContact.remove(userId);
                MobiComQuickConversationFragment.this.messageList.remove(message);
                MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                MobiComQuickConversationFragment.this.checkForEmptyConversations();
            }
        });
    }

    public void removeConversation(final Contact contact, String response) {
        if ("success".equals(response)) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Message message = MobiComQuickConversationFragment.this.latestMessageForEachContact.get(contact.getUserId());
                    MobiComQuickConversationFragment.this.messageList.remove(message);
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.remove(contact.getUserId());
                    MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    MobiComQuickConversationFragment.this.checkForEmptyConversations();
                }
            });
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"delete failed ", (int)0).show();
        }
    }

    public void checkForEmptyConversations() {
        boolean isLodingConversation;
        boolean bl = isLodingConversation = this.downloadConversation != null && this.downloadConversation.getStatus() == AsyncTask.Status.RUNNING;
        if (this.latestMessageForEachContact.isEmpty() && !isLodingConversation) {
            this.emptyTextView.setVisibility(0);
            this.startNewButton.setVisibility(this.applozicSetting.isStartNewButtonVisible() ? 0 : 8);
        } else {
            this.emptyTextView.setVisibility(8);
            this.startNewButton.setVisibility(8);
        }
    }

    public void setLoadMore(boolean loadMore) {
        this.loadMore = loadMore;
    }

    public void onPause() {
        super.onPause();
        this.listIndex = this.listView.getFirstVisiblePosition();
        BroadcastService.currentUserId = null;
    }

    public void onResume() {
        ((ActionBarActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)"Conversations");
        BroadcastService.selectMobiComKitAll();
        super.onResume();
        this.latestMessageForEachContact.clear();
        this.messageList.clear();
        if (this.listView != null) {
            if (this.listView.getCount() > this.listIndex) {
                this.listView.setSelection(this.listIndex);
            } else {
                this.listView.setSelection(0);
            }
        }
        this.downloadConversations();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.listView.setAdapter((ListAdapter)this.conversationAdapter);
        this.startNewButton.setOnClickListener(this.startNewConversation());
        this.fabButton.setOnClickListener(this.startNewConversation());
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int i) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (firstVisibleItem + visibleItemCount == totalItemCount && totalItemCount != 0 && MobiComQuickConversationFragment.this.loadMore) {
                    MobiComQuickConversationFragment.this.loadMore = false;
                    new DownloadConversation(view, false, firstVisibleItem, visibleItemCount, totalItemCount).execute(new Void[0]);
                }
            }
        });
    }

    public void downloadConversations() {
        this.downloadConversations(false);
    }

    public void downloadConversations(boolean showInstruction) {
        this.minCreatedAtTime = null;
        this.downloadConversation = new DownloadConversation((AbsListView)this.listView, true, 1, 0, 0, showInstruction);
        this.downloadConversation.execute(new Void[0]);
    }

    public class DownloadConversation
    extends AsyncTask<Void, Integer, Long> {
        private AbsListView view;
        private int firstVisibleItem;
        private int amountVisible;
        private int totalItems;
        private boolean initial;
        private boolean showInstruction;
        private List<Message> nextMessageList = new ArrayList<Message>();
        private Context context;

        public DownloadConversation(AbsListView view, boolean initial, int firstVisibleItem, int amountVisible, int totalItems, boolean showInstruction) {
            this.context = MobiComQuickConversationFragment.this.getActivity();
            this.view = view;
            this.initial = initial;
            this.firstVisibleItem = firstVisibleItem;
            this.amountVisible = amountVisible;
            this.totalItems = totalItems;
            this.showInstruction = showInstruction;
        }

        public DownloadConversation(AbsListView view, boolean initial, int firstVisibleItem, int amountVisible, int totalItems) {
            this(view, initial, firstVisibleItem, amountVisible, totalItems, false);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MobiComQuickConversationFragment.this.loadMore = false;
            MobiComQuickConversationFragment.this.swipeLayout.setEnabled(true);
            MobiComQuickConversationFragment.this.swipeLayout.post(new Runnable(){

                @Override
                public void run() {
                    MobiComQuickConversationFragment.this.swipeLayout.setRefreshing(true);
                }
            });
        }

        protected Long doInBackground(Void ... voids) {
            if (this.initial) {
                this.nextMessageList = MobiComQuickConversationFragment.this.conversationService.getLatestMessagesGroupByPeople();
                if (!this.nextMessageList.isEmpty()) {
                    MobiComQuickConversationFragment.this.minCreatedAtTime = this.nextMessageList.get(this.nextMessageList.size() - 1).getCreatedAtTime();
                }
            } else if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                MobiComQuickConversationFragment.this.listIndex = this.firstVisibleItem;
                Long createdAt = MobiComQuickConversationFragment.this.messageList.isEmpty() ? null : MobiComQuickConversationFragment.this.messageList.get(MobiComQuickConversationFragment.this.messageList.size() - 1).getCreatedAtTime();
                MobiComQuickConversationFragment.this.minCreatedAtTime = MobiComQuickConversationFragment.this.minCreatedAtTime == null ? createdAt : Math.min(MobiComQuickConversationFragment.this.minCreatedAtTime, createdAt);
                this.nextMessageList = MobiComQuickConversationFragment.this.conversationService.getLatestMessagesGroupByPeople(MobiComQuickConversationFragment.this.minCreatedAtTime);
            }
            return 0L;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Long result) {
            MobiComQuickConversationFragment.this.swipeLayout.setEnabled(false);
            MobiComQuickConversationFragment.this.swipeLayout.post(new Runnable(){

                @Override
                public void run() {
                    MobiComQuickConversationFragment.this.swipeLayout.setRefreshing(false);
                }
            });
            for (Message currentMessage : this.nextMessageList) {
                if (currentMessage.isSentToMany()) continue;
                Message recentSms = MobiComQuickConversationFragment.this.latestMessageForEachContact.get(currentMessage.getContactIds());
                if (recentSms != null) {
                    if (currentMessage.getCreatedAtTime() < recentSms.getCreatedAtTime()) continue;
                    MobiComQuickConversationFragment.this.latestMessageForEachContact.put(currentMessage.getContactIds(), currentMessage);
                    Log.d((String)"Current message", (String)("message" + currentMessage));
                    MobiComQuickConversationFragment.this.messageList.remove(recentSms);
                    MobiComQuickConversationFragment.this.messageList.add(currentMessage);
                    continue;
                }
                MobiComQuickConversationFragment.this.latestMessageForEachContact.put(currentMessage.getContactIds(), currentMessage);
                MobiComQuickConversationFragment.this.messageList.add(currentMessage);
            }
            MobiComQuickConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            if (this.initial) {
                MobiComQuickConversationFragment.this.emptyTextView.setVisibility(MobiComQuickConversationFragment.this.messageList.isEmpty() ? 0 : 8);
                if (MobiComQuickConversationFragment.this.applozicSetting.isStartNewButtonVisible()) {
                    MobiComQuickConversationFragment.this.startNewButton.setVisibility(MobiComQuickConversationFragment.this.messageList.isEmpty() ? 0 : 8);
                }
                if (!MobiComQuickConversationFragment.this.messageList.isEmpty()) {
                    MobiComQuickConversationFragment.this.listView.setSelection(0);
                }
            } else {
                MobiComQuickConversationFragment.this.listView.setSelection(this.firstVisibleItem);
            }
            if (MobiComQuickConversationFragment.this.isAdded()) {
                String errorMessage = MobiComQuickConversationFragment.this.getResources().getString(R.string.internet_connection_not_available);
                Utils.isNetworkAvailable((Activity)MobiComQuickConversationFragment.this.getActivity(), (String)errorMessage);
            }
            if (this.context != null && this.showInstruction) {
                InstructionUtil.showInstruction(this.context, R.string.instruction_open_conversation_thread, 5000, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
            }
        }
    }
}

