/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.UIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FilePathFinder;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.group.Group;
import com.applozic.mobicommons.people.group.GroupUtils;

public class ConversationUIService {
    public static final int REQUEST_CODE_FULL_SCREEN_ACTION = 301;
    public static final int REQUEST_CODE_CONTACT_GROUP_SELECTION = 101;
    public static final int INSTRUCTION_DELAY = 5000;
    public static final String CONVERSATION_FRAGMENT = "ConversationFragment";
    public static final String QUICK_CONVERSATION_FRAGMENT = "QuickConversationFragment";
    private static final String TAG = "ConversationUIService";
    public static String DISPLAY_NAME = "displayName";
    private FragmentActivity fragmentActivity;
    private BaseContactService baseContactService;

    public ConversationUIService(FragmentActivity fragmentActivity) {
        this.fragmentActivity = fragmentActivity;
        this.baseContactService = new AppContactService((Context)fragmentActivity);
    }

    public MobiComQuickConversationFragment getQuickConversationFragment() {
        MobiComQuickConversationFragment quickConversationFragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
        if (quickConversationFragment == null) {
            quickConversationFragment = new MobiComQuickConversationFragment();
            ConversationActivity.addFragment(this.fragmentActivity, quickConversationFragment, QUICK_CONVERSATION_FRAGMENT);
        }
        return quickConversationFragment;
    }

    public ConversationFragment getConversationFragment() {
        ConversationFragment conversationFragment = (ConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, CONVERSATION_FRAGMENT);
        if (conversationFragment == null) {
            Contact contact = ((ConversationActivity)this.fragmentActivity).getContact();
            conversationFragment = new ConversationFragment(contact);
            ConversationActivity.addFragment(this.fragmentActivity, conversationFragment, CONVERSATION_FRAGMENT);
        }
        return conversationFragment;
    }

    public void onQuickConversationFragmentItemClick(View view, Contact contact) {
        TextView textView = (TextView)view.findViewById(R.id.unreadSmsCount);
        textView.setVisibility(8);
        this.openConversationFragment(contact);
    }

    public void openConversationFragment(final Contact contact) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ConversationFragment conversationFragment = new ConversationFragment(contact);
                ((MobiComKitActivityInterface)ConversationUIService.this.fragmentActivity).addFragment(conversationFragment);
            }
        });
    }

    public void openConversationFragment(Group group) {
        ConversationFragment conversationFragment = new ConversationFragment();
        ConversationActivity.addFragment(this.fragmentActivity, conversationFragment, CONVERSATION_FRAGMENT);
        conversationFragment.loadConversation(group);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        try {
            if ((requestCode == 12 || requestCode == 11) && resultCode == -1) {
                Uri selectedFileUri;
                Uri uri = selectedFileUri = intent == null ? null : intent.getData();
                if (selectedFileUri == null) {
                    ConversationActivity cfr_ignored_0 = (ConversationActivity)this.fragmentActivity;
                    selectedFileUri = ConversationActivity.getCapturedImageUri();
                    ImageUtils.addImageToGallery((String)FilePathFinder.getPath((Context)this.fragmentActivity, (Uri)selectedFileUri), (Context)this.fragmentActivity);
                }
                if (selectedFileUri == null) {
                    Bitmap photo = (Bitmap)(intent != null ? intent.getExtras().get("data") : null);
                    selectedFileUri = ImageUtils.getImageUri((Context)this.fragmentActivity, (Bitmap)photo);
                }
                this.getConversationFragment().loadFile(selectedFileUri);
                Log.i((String)TAG, (String)("File uri: " + selectedFileUri));
            }
            if (requestCode == 101 && resultCode == -1) {
                this.checkForStartNewConversation(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteConversationThread(final Contact contact, String name) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.fragmentActivity).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService((Context)ConversationUIService.this.fragmentActivity), contact, (Context)ConversationUIService.this.fragmentActivity).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setTitle((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_title).replace("[name]", name));
        alertDialog.setMessage((CharSequence)this.fragmentActivity.getString(R.string.dialog_delete_conversation_confir).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void updateLatestMessage(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLatestMessage(message, formattedContactNumber);
    }

    public void removeConversation(Message message, String formattedContactNumber) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().removeConversation(message, formattedContactNumber);
    }

    public void addMessage(Message message) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        MobiComQuickConversationFragment fragment = (MobiComQuickConversationFragment)UIService.getFragmentByTag(this.fragmentActivity, QUICK_CONVERSATION_FRAGMENT);
        if (fragment != null) {
            fragment.addMessage(message);
        }
    }

    public void updateLastMessage(String keyString, String userId) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().updateLastMessage(keyString, userId);
    }

    public boolean isBroadcastedToGroup(Long broadcastGroupId) {
        if (!BroadcastService.isIndividual()) {
            return false;
        }
        return this.getConversationFragment().isBroadcastedToGroup(broadcastGroupId);
    }

    public void syncMessages(Message message, String keyString) {
        ConversationFragment conversationFragment;
        String userId = message.getContactIds();
        if (BroadcastService.isIndividual() && (userId.equals((conversationFragment = this.getConversationFragment()).getCurrentUserId()) || conversationFragment.isBroadcastedToGroup(message.getBroadcastGroupId()))) {
            conversationFragment.addMessage(message);
        }
        if (message.getBroadcastGroupId() == null) {
            this.updateLastMessage(keyString, userId);
        }
    }

    public void downloadConversations(boolean showInstruction) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().downloadConversations(showInstruction);
    }

    public void setLoadMore(boolean loadMore) {
        if (!BroadcastService.isQuick()) {
            return;
        }
        this.getQuickConversationFragment().setLoadMore(loadMore);
    }

    public void updateMessageKeyString(Message message) {
        ConversationFragment conversationFragment;
        if (!BroadcastService.isIndividual()) {
            return;
        }
        String userId = message.getContactIds();
        if (userId.equals((conversationFragment = this.getConversationFragment()).getContact().getUserId()) || conversationFragment.isBroadcastedToGroup(message.getBroadcastGroupId())) {
            conversationFragment.updateMessageKeyString(message);
        }
    }

    public void deleteMessage(Message message, String keyString, String formattedContactNumber) {
        if (PhoneNumberUtils.compare((String)formattedContactNumber, (String)BroadcastService.currentUserId)) {
            this.getConversationFragment().deleteMessageFromDeviceList(keyString);
        } else {
            this.updateLastMessage(keyString, formattedContactNumber);
        }
    }

    public void updateDeliveryStatus(Message message, String formattedContactNumber) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        ConversationFragment conversationFragment = this.getConversationFragment();
        if (formattedContactNumber.equals(conversationFragment.getContact().getContactIds())) {
            conversationFragment.updateDeliveryStatus(message);
        }
    }

    public void deleteConversation(Contact contact, String response) {
        if (BroadcastService.isIndividual()) {
            this.getConversationFragment().clearList();
        }
        if (BroadcastService.isQuick()) {
            this.getQuickConversationFragment().removeConversation(contact, response);
        }
    }

    public void updateUploadFailedStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateUploadFailedStatus(message);
    }

    public void updateDownloadStatus(Message message) {
        if (!BroadcastService.isIndividual()) {
            return;
        }
        this.getConversationFragment().updateDownloadStatus(message);
    }

    public void startContactActivityForResult(Intent intent, Message message, String messageContent) {
        if (message != null) {
            intent.putExtra("forwardMessage", GsonUtils.getJsonFromObject((Object)message, message.getClass()));
        }
        if (messageContent != null) {
            intent.putExtra("SHARED_TEXT", messageContent);
        }
        this.fragmentActivity.startActivityForResult(intent, 101);
    }

    public void startContactActivityForResult() {
        this.startContactActivityForResult(null, null);
    }

    public void startContactActivityForResult(Message message, String messageContent) {
        Intent intent = new Intent((Context)this.fragmentActivity, MobiComKitPeopleActivity.class);
        this.startContactActivityForResult(intent, message, messageContent);
    }

    public void checkForStartNewConversation(Intent intent) {
        String sharedText;
        String forwardMessage;
        boolean support;
        String messageJson;
        String userId;
        Uri uri;
        Contact contact = null;
        Group group = null;
        if ("android.intent.action.SEND".equals(intent.getAction()) && intent.getType() != null) {
            if ("text/plain".equals(intent.getType())) {
                String sharedText2 = intent.getStringExtra("android.intent.extra.TEXT");
                if (sharedText2 != null) {
                    this.startContactActivityForResult(null, sharedText2);
                }
            } else if (intent.getType().startsWith("image/")) {
                // empty if block
            }
        }
        if ((uri = intent.getData()) != null) {
            Long contactId = intent.getLongExtra("contactId", 0L);
            if (contactId == 0L) {
                return;
            }
            contact = this.baseContactService.getContactById(String.valueOf(contactId));
        }
        Long groupId = intent.getLongExtra("groupId", -1L);
        String groupName = intent.getStringExtra("groupName");
        if (groupId != -1L) {
            group = GroupUtils.fetchGroup((Context)this.fragmentActivity, (Long)groupId, (String)groupName);
        }
        String contactNumber = intent.getStringExtra("contactNumber");
        boolean firstTimeMTexterFriend = intent.getBooleanExtra("firstTimeMTexterFriend", false);
        if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
            contact = this.baseContactService.getContactById(contactNumber);
            if (BroadcastService.isIndividual()) {
                this.getConversationFragment().setFirstTimeMTexterFriend(firstTimeMTexterFriend);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(userId = intent.getStringExtra("userId")))) {
            contact = this.baseContactService.getContactById(userId);
        }
        String fullName = intent.getStringExtra(DISPLAY_NAME);
        if (contact != null && TextUtils.isEmpty((CharSequence)contact.getFullName()) && !TextUtils.isEmpty((CharSequence)fullName)) {
            contact.setFullName(fullName);
            this.baseContactService.upsert(contact);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageJson = intent.getStringExtra("message_json")))) {
            Message message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
            contact = this.baseContactService.getContactById(message.getContactIds());
        }
        if (support = intent.getBooleanExtra("SUPPORT_INTENT_KEY", false)) {
            contact = new Support((Context)this.fragmentActivity).getSupportContact();
        }
        if (contact != null) {
            this.openConversationFragment(contact);
        }
        if (group != null) {
            this.openConversationFragment(group);
        }
        if (!TextUtils.isEmpty((CharSequence)(forwardMessage = intent.getStringExtra("forwardMessage")))) {
            Message messageToForward = (Message)GsonUtils.getObjectFromJson((String)forwardMessage, Message.class);
            this.getConversationFragment().forwardMessage(messageToForward, contact);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = intent.getStringExtra("SHARED_TEXT")))) {
            this.getConversationFragment().sendMessage(sharedText);
        }
    }
}

