/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.people;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.listners.AlChannelListener;
import com.applozic.mobicomkit.listners.AlContactListener;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.task.AlAsyncTask;

public class AlGetPeopleTask
extends AlAsyncTask<Object, Object> {
    private String userId;
    private String clientChannelKey;
    private Integer groupId;
    private AlChannelListener channelListener;
    private AlContactListener contactListener;
    private ChannelService channelService;
    private AppContactService appContactService;

    public AlGetPeopleTask(Context context, String userId, String clientChannelKey, Integer channelKey, AlChannelListener channelListener, AlContactListener contactListener, AppContactService appContactService, ChannelService channelService) {
        this.userId = userId;
        this.clientChannelKey = clientChannelKey;
        this.groupId = channelKey;
        this.channelListener = channelListener;
        this.contactListener = contactListener;
        this.appContactService = appContactService;
        this.appContactService = appContactService == null ? new AppContactService(context) : appContactService;
        this.channelService = channelService == null ? ChannelService.getInstance(context) : channelService;
    }

    protected Object doInBackground() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.userId)) {
                return this.appContactService.getContactById(this.userId);
            }
            if (!TextUtils.isEmpty((CharSequence)this.clientChannelKey)) {
                return this.channelService.getChannelByClientGroupId(this.clientChannelKey);
            }
            if (this.groupId != null && this.groupId > 0) {
                return this.channelService.getChannelByChannelKey(this.groupId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onPostExecute(Object o) {
        super.onPostExecute(o);
        if (o instanceof Contact && this.contactListener != null) {
            this.contactListener.onGetContact((Contact)o);
        }
        if (o instanceof Channel && this.channelListener != null) {
            this.channelListener.onGetChannel((Channel)o);
        }
    }
}

