/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.applozic.mobicomkit.broadcast.AlMessageEvent;
import com.applozic.mobicomkit.feed.MqttMessageResponse;
import com.applozic.mobicomkit.listners.AlMqttListener;
import com.applozic.mobicomkit.listners.ApplozicUIListener;
import com.applozic.mobicommons.json.GsonUtils;
import java.util.HashMap;
import java.util.Map;

public class AlEventManager {
    public static final String AL_EVENT = "AL_EVENT";
    private static AlEventManager eventManager;
    private Map<String, ApplozicUIListener> listenerMap;
    private Map<String, AlMqttListener> mqttListenerMap;
    private Handler uiHandler;

    public static AlEventManager getInstance() {
        if (eventManager == null) {
            eventManager = new AlEventManager();
        }
        return eventManager;
    }

    public void registerUIListener(String id, ApplozicUIListener listener) {
        if (this.listenerMap == null) {
            this.listenerMap = new HashMap<String, ApplozicUIListener>();
        }
        if (this.uiHandler == null) {
            this.uiHandler = new Handler(new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    AlEventManager.this.handleState(msg);
                    return false;
                }
            });
        }
        if (!this.listenerMap.containsKey(id)) {
            this.listenerMap.put(id, listener);
        }
    }

    public void unregisterUIListener(String id) {
        if (this.listenerMap != null) {
            this.listenerMap.remove(id);
        }
    }

    public void registerMqttListener(String id, AlMqttListener mqttListener) {
        if (this.mqttListenerMap == null) {
            this.mqttListenerMap = new HashMap<String, AlMqttListener>();
        }
        if (!this.mqttListenerMap.containsKey(id)) {
            this.mqttListenerMap.put(id, mqttListener);
        }
    }

    public void unregisterMqttListener(String id) {
        if (this.mqttListenerMap != null) {
            this.mqttListenerMap.remove(id);
        }
    }

    void postEventData(AlMessageEvent messageEvent) {
        if (this.uiHandler != null) {
            Message message = new Message();
            Bundle bundle = new Bundle();
            bundle.putString(AL_EVENT, GsonUtils.getJsonFromObject((Object)((Object)messageEvent), AlMessageEvent.class));
            message.setData(bundle);
            this.uiHandler.sendMessage(message);
        }
    }

    public void postMqttEventData(MqttMessageResponse messageResponse) {
        if (this.mqttListenerMap != null && !this.mqttListenerMap.isEmpty()) {
            for (AlMqttListener alMqttListener : this.mqttListenerMap.values()) {
                alMqttListener.onMqttMessageReceived(messageResponse);
            }
        }
    }

    private void handleState(Message message) {
        if (message != null && this.listenerMap != null && !this.listenerMap.isEmpty()) {
            Bundle bundle = message.getData();
            AlMessageEvent messageEvent = null;
            if (bundle != null) {
                messageEvent = (AlMessageEvent)((Object)GsonUtils.getObjectFromJson((String)bundle.getString(AL_EVENT), AlMessageEvent.class));
            }
            if (messageEvent == null) {
                return;
            }
            for (ApplozicUIListener listener : this.listenerMap.values()) {
                switch (messageEvent.getAction()) {
                    case "MESSAGE_SENT": {
                        listener.onMessageSent(messageEvent.getMessage());
                        break;
                    }
                    case "MESSAGE_RECEIVED": {
                        listener.onMessageReceived(messageEvent.getMessage());
                        break;
                    }
                    case "MESSAGE_SYNC": {
                        listener.onMessageSync(messageEvent.getMessage(), messageEvent.getMessageKey());
                        break;
                    }
                    case "LOAD_MORE": {
                        listener.onLoadMore(messageEvent.isLoadMore());
                        break;
                    }
                    case "MESSAGE_DELETED": {
                        listener.onMessageDeleted(messageEvent.getMessageKey(), messageEvent.getUserId());
                        break;
                    }
                    case "MESSAGE_DELIVERED": {
                        listener.onMessageDelivered(messageEvent.getMessage(), messageEvent.getUserId());
                        break;
                    }
                    case "ALL_MESSAGES_DELIVERED": {
                        listener.onAllMessagesDelivered(messageEvent.getUserId());
                        break;
                    }
                    case "ALL_MESSAGES_READ": {
                        listener.onAllMessagesRead(messageEvent.getUserId());
                        break;
                    }
                    case "CONVERSATION_DELETED": {
                        listener.onConversationDeleted(messageEvent.getUserId(), messageEvent.getGroupId(), messageEvent.getResponse());
                        break;
                    }
                    case "UPDATE_TYPING_STATUS": {
                        listener.onUpdateTypingStatus(messageEvent.getUserId(), messageEvent.isTyping());
                        break;
                    }
                    case "UPDATE_LAST_SEEN": {
                        listener.onUpdateLastSeen(messageEvent.getUserId());
                        break;
                    }
                    case "MQTT_DISCONNECTED": {
                        listener.onMqttDisconnected();
                        break;
                    }
                    case "MQTT_CONNECTED": {
                        listener.onMqttConnected();
                        break;
                    }
                    case "USER_OFFLINE": {
                        listener.onUserOffline();
                        break;
                    }
                    case "USER_ONLINE": {
                        listener.onUserOnline();
                        break;
                    }
                    case "CHANNEL_UPDATED": {
                        listener.onChannelUpdated();
                        break;
                    }
                    case "CONVERSATION_READ": {
                        listener.onConversationRead(messageEvent.getUserId(), messageEvent.isGroup());
                        break;
                    }
                    case "USER_DETAILS_UPDATED": {
                        listener.onUserDetailUpdated(messageEvent.getUserId());
                        break;
                    }
                    case "USER_ACTIVATED": {
                        listener.onUserActivated(true);
                        break;
                    }
                    case "USER_DEACTIVATED": {
                        listener.onUserActivated(false);
                        break;
                    }
                    case "MESSAGE_METADATA_UPDATED": {
                        listener.onMessageMetadataUpdated(messageEvent.getMessageKey());
                        break;
                    }
                    case "GROUP_MUTE": {
                        listener.onGroupMute(messageEvent.getGroupId());
                    }
                }
            }
        }
    }
}

