/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment.urlservice;

import android.content.Context;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.urlservice.ApplozicMongoStorageService;
import com.applozic.mobicomkit.api.attachment.urlservice.DefaultURLService;
import com.applozic.mobicomkit.api.attachment.urlservice.GoogleCloudURLService;
import com.applozic.mobicomkit.api.attachment.urlservice.S3URLService;
import com.applozic.mobicomkit.api.attachment.urlservice.URLService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicommons.ApplozicService;
import java.io.IOException;
import java.net.HttpURLConnection;

public class URLServiceProvider {
    private Context context;
    private URLService urlService;
    private MobiComKitClientService mobiComKitClientService;

    public URLServiceProvider(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.mobiComKitClientService = new MobiComKitClientService(context);
    }

    private URLService getUrlService(Context context) {
        if (this.urlService != null) {
            return this.urlService;
        }
        ApplozicClient appClient = ApplozicClient.getInstance(context);
        this.urlService = appClient.isS3StorageServiceEnabled() ? new S3URLService(context) : (appClient.isGoogleCloudServiceEnabled() ? new GoogleCloudURLService(context) : (appClient.isStorageServiceEnabled() ? new ApplozicMongoStorageService(context) : new DefaultURLService(context)));
        return this.urlService;
    }

    public HttpURLConnection getDownloadConnection(Message message) throws IOException {
        HttpURLConnection connection;
        try {
            connection = this.getUrlService(this.context).getAttachmentConnection(message);
        }
        catch (Exception e) {
            throw new IOException("Error connecting");
        }
        return connection;
    }

    public String getThumbnailURL(Message message) throws IOException {
        try {
            return this.getUrlService(this.context).getThumbnailURL(message);
        }
        catch (Exception e) {
            throw new IOException("Error connecting");
        }
    }

    public String getFileUploadUrl() {
        return this.getUrlService(this.context).getFileUploadUrl();
    }

    public String getImageURL(Message message) {
        return this.getUrlService(this.context).getImageUrl(message);
    }
}

