/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment.urlservice;

import android.content.Context;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.attachment.urlservice.ApplozicMongoStorageService;
import com.applozic.mobicomkit.api.attachment.urlservice.DefaultURLService;
import com.applozic.mobicomkit.api.attachment.urlservice.GoogleCloudURLService;
import com.applozic.mobicomkit.api.attachment.urlservice.S3URLService;
import com.applozic.mobicomkit.api.attachment.urlservice.URLService;
import com.applozic.mobicomkit.api.conversation.Message;
import java.io.IOException;
import java.net.HttpURLConnection;

public class URLServiceProvider {
    private Context context;
    private static URLService urlService;

    public URLServiceProvider(Context context) {
        this.context = context;
    }

    private static URLService getUrlService(Context context) {
        if (urlService != null) {
            return urlService;
        }
        ApplozicClient appClient = ApplozicClient.getInstance(context);
        urlService = appClient.isS3StorageServiceEnabled() ? new S3URLService(context) : (appClient.isGoogleCloudServiceEnabled() ? new GoogleCloudURLService(context) : (appClient.isStorageServiceEnabled() ? new ApplozicMongoStorageService(context) : new DefaultURLService(context)));
        return urlService;
    }

    public HttpURLConnection getDownloadConnection(Message message) throws IOException {
        HttpURLConnection connection;
        try {
            connection = URLServiceProvider.getUrlService(this.context).getAttachmentConnection(message);
        }
        catch (Exception e) {
            throw new IOException("Error connecting");
        }
        return connection;
    }

    public String getThumbnailURL(Message message) throws IOException {
        try {
            return URLServiceProvider.getUrlService(this.context).getThumbnailURL(message);
        }
        catch (Exception e) {
            throw new IOException("Error connecting");
        }
    }

    public String getFileUploadUrl() {
        return URLServiceProvider.getUrlService(this.context).getFileUploadUrl();
    }

    public String getImageURL(Message message) {
        return URLServiceProvider.getUrlService(this.context).getImageUrl(message);
    }
}

