/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.WearableNotificationWithVoice;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.listners.AlConstantsHandler;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.List;

public class NotificationService {
    public static final int NOTIFICATION_ID = 1000;
    private static final String TAG = "NotificationService";
    private static final String NOTIFICATION_SMALL_ICON_METADATA = "com.applozic.mobicomkit.notification.smallIcon";
    private static String GROUP_KEY = "applozic_key";
    MessageDatabaseService messageDatabaseService;
    List<Message> unReadMessageList = new ArrayList<Message>();
    long[] pattern = new long[]{0L, 100L, 1000L, 300L, 200L, 100L, 500L, 200L, 100L};
    private Context context;
    private int iconResourceId;
    private int wearable_action_title;
    private int wearable_action_label;
    private int wearable_send_icon;
    private AppContactService appContactService;
    private ApplozicClient applozicClient;
    private String activityToOpen;
    private String[] constArray = new String[]{"Location", "Audio", "Video", "Attachment"};

    public NotificationService(int iconResourceID, Context context, int wearable_action_label, int wearable_action_title, int wearable_send_icon) {
        this.context = context;
        this.iconResourceId = iconResourceID;
        this.wearable_action_label = wearable_action_label;
        this.wearable_action_title = wearable_action_title;
        this.wearable_send_icon = wearable_send_icon;
        this.applozicClient = ApplozicClient.getInstance(context);
        this.appContactService = new AppContactService(context);
        this.activityToOpen = Utils.getMetaDataValue((Context)context, (String)"activity.open.on.notification");
        this.messageDatabaseService = new MessageDatabaseService(context);
    }

    public void notifyUser(Contact contact, Channel channel, Message message) {
        Intent intent;
        if (ApplozicClient.getInstance(this.context).isNotificationDisabled()) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Notification is disabled !!");
            return;
        }
        Bitmap notificationIconBitmap = null;
        this.unReadMessageList = this.messageDatabaseService.getUnreadMessages();
        int count = this.appContactService.getChatConversationCount() + this.appContactService.getGroupConversationCount();
        int totalCount = this.messageDatabaseService.getTotalUnreadCount();
        Class<?> activity = null;
        try {
            activity = Class.forName(this.activityToOpen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (message.getGroupId() != null) {
            Contact newContact;
            String userId;
            if (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType())) {
                userId = ChannelService.getInstance(this.context).getGroupOfTwoReceiverUserId(channel.getKey());
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    newContact = this.appContactService.getContactById(userId);
                    notificationIconBitmap = this.appContactService.downloadContactImage(this.context, newContact);
                }
            } else if (Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType())) {
                userId = message.getTo();
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    newContact = this.appContactService.getContactById(userId);
                    notificationIconBitmap = this.appContactService.downloadContactImage(this.context, newContact);
                }
            } else {
                notificationIconBitmap = this.appContactService.downloadGroupImage(this.context, channel);
            }
        } else {
            notificationIconBitmap = this.appContactService.downloadContactImage(this.context, contact);
        }
        Integer smallIconResourceId = Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) != null ? Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) : this.iconResourceId;
        if (count < 2) {
            intent = new Intent(this.context, activity);
            intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        } else {
            intent = new Intent(this.context, activity);
            intent.putExtra("QUICK_LIST", true);
        }
        if (this.applozicClient.isChatListOnNotificationIsHidden()) {
            intent.putExtra("takeOrder", true);
        }
        if (this.applozicClient.isContextBasedChat()) {
            intent.putExtra("contextBasedChat", true);
        }
        intent.putExtra("sms_body", "text");
        intent.setType("vnd.android-dir/mms-sms");
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)((int)(System.currentTimeMillis() & 0xFFFFFFFL)), (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, "AL_PUSH_NOTIFICATION").setSmallIcon(smallIconResourceId.intValue()).setCategory("msg").setPriority(2).setWhen(System.currentTimeMillis());
        mBuilder.setSound(TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getNotificationSoundFilePath()) ? RingtoneManager.getDefaultUri((int)2) : Uri.parse((String)MobiComUserPreference.getInstance(this.context).getNotificationSoundFilePath()));
        if (Build.VERSION.SDK_INT < 26) {
            mBuilder.setGroup(GROUP_KEY);
            mBuilder.setGroupSummary(true);
        } else if (totalCount != 0) {
            mBuilder.setNumber(totalCount);
        }
        mBuilder.setContentIntent(pendingIntent);
        mBuilder.setAutoCancel(true);
        if (ApplozicClient.getInstance(this.context).getVibrationOnNotification()) {
            mBuilder.setVibrate(this.pattern);
        }
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle(this.getNotificationTitle(count, contact, channel, message));
        try {
            if (this.unReadMessageList != null) {
                for (Message messageString : this.unReadMessageList) {
                    Contact unreadCount;
                    Channel unreadChannel;
                    if (messageString.getGroupId() != null ? (unreadChannel = ChannelService.getInstance(this.context).getChannelByChannelKey(messageString.getGroupId())) != null && unreadChannel.getUnreadCount() == 0 : (unreadCount = this.appContactService.getContactById(messageString.getContactIds())) != null && unreadCount.getUnreadCount() == 0) continue;
                    inboxStyle.addLine(this.getMessageBody(messageString, count, channel, contact));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String summaryText = "";
        if (count < 1) {
            summaryText = "";
            mBuilder.setLargeIcon(notificationIconBitmap != null ? notificationIconBitmap : BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.context.getResources().getIdentifier(message.getGroupId() != null ? this.applozicClient.getDefaultChannelImage() : this.applozicClient.getDefaultContactImage(), "drawable", this.context.getPackageName())));
            mBuilder.setContentText(this.getMessageBody(message, count, channel, contact));
        } else if (count >= 1 && count < 2) {
            String string = summaryText = totalCount < 2 ? totalCount + " new message " : totalCount + " new messages ";
            mBuilder.setLargeIcon(notificationIconBitmap != null ? notificationIconBitmap : BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.context.getResources().getIdentifier(message.getGroupId() != null ? this.applozicClient.getDefaultChannelImage() : this.applozicClient.getDefaultContactImage(), "drawable", this.context.getPackageName())));
            mBuilder.setContentText((CharSequence)summaryText);
        } else {
            summaryText = totalCount + " messages from " + count + " chats";
            mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.iconResourceId));
            mBuilder.setContentText((CharSequence)summaryText);
        }
        inboxStyle.setSummaryText((CharSequence)summaryText);
        mBuilder.setContentTitle(this.getNotificationTitle(count, contact, channel, message));
        mBuilder.setStyle((NotificationCompat.Style)inboxStyle);
        if (message.hasAttachment()) {
            try {
                FileMeta fileMeta = message.getFileMetas();
                Object httpConn = null;
                if (fileMeta.getThumbnailBlobKey() != null) {
                    Bitmap bitmap = new FileClientService(this.context).loadThumbnailImage(this.context, message, 200, 200);
                    mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        WearableNotificationWithVoice notificationWithVoice = new WearableNotificationWithVoice(mBuilder, this.wearable_action_title, this.wearable_action_label, this.wearable_send_icon, 1000);
        notificationWithVoice.setCurrentContext(this.context);
        notificationWithVoice.setPendingIntent(pendingIntent);
        try {
            if (this.unReadMessageList != null && this.unReadMessageList.size() > 0) {
                notificationWithVoice.sendNotification();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CharSequence getNotificationTitle(int conversationCount, Contact contact, Channel channel, Message message) {
        if (conversationCount < 2) {
            String notificationTitle = null;
            if (channel != null) {
                if (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType())) {
                    Contact receiverContact;
                    String userId = ChannelService.getInstance(this.context).getGroupOfTwoReceiverUserId(channel.getKey());
                    if (!TextUtils.isEmpty((CharSequence)userId) && (receiverContact = this.appContactService.getContactById(userId)) != null) {
                        notificationTitle = receiverContact.getDisplayName();
                    }
                } else if (Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType())) {
                    Contact receiverContact;
                    String userId = message.getTo();
                    if (!TextUtils.isEmpty((CharSequence)userId) && (receiverContact = this.appContactService.getContactById(userId)) != null) {
                        notificationTitle = receiverContact.getDisplayName();
                    }
                } else {
                    notificationTitle = channel.getName().trim();
                }
            } else if (contact != null) {
                notificationTitle = contact.getDisplayName().trim();
            }
            return Utils.getStyleString(notificationTitle);
        }
        return Utils.getStyleString((String)ApplozicClient.getInstance(this.context).getAppName());
    }

    public CharSequence getMessageBody(Message message, int count, Channel channel, Contact contact) {
        Contact messageContactDisplayName;
        String notificationText = message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue() ? this.getText(0) : (message.getContentType() == Message.ContentType.AUDIO_MSG.getValue().shortValue() ? this.getText(1) : (message.getContentType() == Message.ContentType.VIDEO_MSG.getValue().shortValue() ? this.getText(2) : (message.hasAttachment() && TextUtils.isEmpty((CharSequence)message.getMessage()) ? this.getText(3) : message.getMessage())));
        Contact contact2 = messageContactDisplayName = contact != null ? contact : this.appContactService.getContactById(message.getTo());
        CharSequence messageBody = message.getGroupId() != null ? (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType()) || Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType()) ? Utils.getStyleStringForMessage((String)notificationText) : Utils.getStyledStringForChannel((String)messageContactDisplayName.getDisplayName(), (String)channel.getName(), (String)notificationText)) : (count < 2 ? Utils.getStyleStringForMessage((String)notificationText) : Utils.getStyledStringForContact((String)messageContactDisplayName.getDisplayName(), (String)notificationText));
        return messageBody;
    }

    public void notifyUserForNormalMessage(Contact contact, Channel channel, Message message) {
        int totalCount;
        if (ApplozicClient.getInstance(this.context).isNotificationDisabled()) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Notification is disabled");
            return;
        }
        String title = null;
        Bitmap notificationIconBitmap = null;
        Contact displayNameContact = null;
        if (message.getGroupId() != null) {
            Contact newContact;
            String userId;
            if (channel == null) {
                return;
            }
            if (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType())) {
                userId = ChannelService.getInstance(this.context).getGroupOfTwoReceiverUserId(channel.getKey());
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    newContact = this.appContactService.getContactById(userId);
                    notificationIconBitmap = this.appContactService.downloadContactImage(this.context, newContact);
                    title = newContact.getDisplayName();
                }
            } else if (Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType())) {
                userId = message.getTo();
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    newContact = this.appContactService.getContactById(userId);
                    notificationIconBitmap = this.appContactService.downloadGroupImage(this.context, channel);
                    title = newContact.getDisplayName();
                }
            } else {
                displayNameContact = this.appContactService.getContactById(message.getTo());
                title = ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance(this.context).getUserId());
                notificationIconBitmap = this.appContactService.downloadGroupImage(this.context, channel);
            }
        } else {
            title = contact.getDisplayName();
            notificationIconBitmap = this.appContactService.downloadContactImage(this.context, contact);
        }
        String notificationText = message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue() ? this.getText(0) : (message.getContentType() == Message.ContentType.AUDIO_MSG.getValue().shortValue() ? this.getText(1) : (message.getContentType() == Message.ContentType.VIDEO_MSG.getValue().shortValue() ? this.getText(2) : (message.hasAttachment() && TextUtils.isEmpty((CharSequence)message.getMessage()) ? this.getText(3) : message.getMessage())));
        Class<?> activity = null;
        try {
            activity = Class.forName(this.activityToOpen);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Integer smallIconResourceId = Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) != null ? Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) : this.iconResourceId;
        Intent intent = new Intent(this.context, activity);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        if (this.applozicClient.isChatListOnNotificationIsHidden()) {
            intent.putExtra("takeOrder", true);
        }
        if (this.applozicClient.isContextBasedChat()) {
            intent.putExtra("contextBasedChat", true);
        }
        intent.putExtra("sms_body", "text");
        intent.setType("vnd.android-dir/mms-sms");
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)((int)(System.currentTimeMillis() & 0xFFFFFFFL)), (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, "AL_PUSH_NOTIFICATION");
        mBuilder.setSmallIcon(smallIconResourceId.intValue()).setLargeIcon(ApplozicClient.getInstance(this.context).isShowAppIconInNotification() ? BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.iconResourceId) : (notificationIconBitmap != null ? notificationIconBitmap : BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.context.getResources().getIdentifier(channel != null && !Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType()) && !Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType()) ? this.applozicClient.getDefaultChannelImage() : this.applozicClient.getDefaultContactImage(), "drawable", this.context.getPackageName())))).setCategory("msg").setPriority(2).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)title).setContentText((CharSequence)(channel != null && !Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType()) && !Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType()) ? displayNameContact.getDisplayName() + ": " + notificationText : notificationText)).setSound(TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getNotificationSoundFilePath()) ? RingtoneManager.getDefaultUri((int)2) : Uri.parse((String)MobiComUserPreference.getInstance(this.context).getNotificationSoundFilePath()));
        mBuilder.setContentIntent(pendingIntent);
        mBuilder.setAutoCancel(true);
        if (ApplozicClient.getInstance(this.context).isUnreadCountBadgeEnabled() && (totalCount = this.messageDatabaseService.getTotalUnreadCount()) != 0) {
            mBuilder.setNumber(totalCount);
        }
        if (message.hasAttachment()) {
            try {
                FileMeta fileMeta = message.getFileMetas();
                Object httpConn = null;
                if (fileMeta.getThumbnailBlobKey() != null) {
                    Bitmap bitmap = new FileClientService(this.context).loadThumbnailImage(this.context, message, 200, 200);
                    mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        WearableNotificationWithVoice notificationWithVoice = new WearableNotificationWithVoice(mBuilder, this.wearable_action_title, this.wearable_action_label, this.wearable_send_icon, message.getGroupId() != null ? String.valueOf(message.getGroupId()).hashCode() : message.getContactIds().hashCode());
        notificationWithVoice.setCurrentContext(this.context);
        notificationWithVoice.setPendingIntent(pendingIntent);
        try {
            notificationWithVoice.sendNotification();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getText(int index) {
        if (this.context.getApplicationContext() instanceof AlConstantsHandler) {
            return this.getTextFromIndex(((AlConstantsHandler)this.context.getApplicationContext()).getNotificationTexts(), index);
        }
        return this.constArray[index];
    }

    public String getTextFromIndex(String[] texts, int index) {
        if (texts != null && texts.length == 4) {
            return texts[index];
        }
        return null;
    }
}

