/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.authentication;

import android.content.Context;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.authentication.Claim;
import com.applozic.mobicomkit.api.authentication.ClaimImpl;
import com.applozic.mobicomkit.api.authentication.DecodeException;
import com.applozic.mobicomkit.api.authentication.JWTPayload;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JWT {
    private Map<String, String> header;
    private JWTPayload payload;
    private String signature;
    private final String token;

    public JWT(@NonNull String token) {
        this.token = token;
        this.decode(token);
    }

    public boolean isExpired(long leeway) {
        if (leeway < 0L) {
            throw new IllegalArgumentException("The leeway must be a positive value.");
        }
        long todayTime = (long)(Math.floor(new Date().getTime() / 1000L) * 1000.0);
        Date futureToday = new Date(todayTime + leeway * 1000L);
        Date pastToday = new Date(todayTime - leeway * 1000L);
        boolean expValid = this.payload.exp == null || !pastToday.after(this.payload.exp);
        boolean iatValid = this.payload.iat == null || !futureToday.before(this.payload.iat);
        return !expValid || !iatValid;
    }

    private void decode(String token) {
        String[] parts = this.splitToken(token);
        Type mapType = new TypeToken<Map<String, String>>(){}.getType();
        this.header = (Map)this.parseJson(this.base64Decode(parts[0]), mapType);
        this.payload = (JWTPayload)this.parseJson(this.base64Decode(parts[1]), (Type)((Object)JWTPayload.class));
        this.signature = parts[2];
    }

    @NonNull
    public Map<String, String> getHeader() {
        return this.header;
    }

    @NonNull
    public String getSignature() {
        return this.signature;
    }

    @Nullable
    public String getIssuer() {
        return this.payload.iss;
    }

    @Nullable
    public String getSubject() {
        return this.payload.sub;
    }

    @Nullable
    public List<String> getAudience() {
        return this.payload.aud;
    }

    @Nullable
    public Date getExpiresAt() {
        return this.payload.exp;
    }

    @Nullable
    public Date getNotBefore() {
        return this.payload.nbf;
    }

    @Nullable
    public Date getIssuedAt() {
        return this.payload.iat;
    }

    @Nullable
    public String getId() {
        return this.payload.jti;
    }

    @NonNull
    public Claim getClaim(@NonNull String name) {
        return this.payload.claimForName(name);
    }

    @NonNull
    public Map<String, Claim> getClaims() {
        return this.payload.tree;
    }

    private String[] splitToken(String token) {
        String[] parts = token.split("\\.");
        if (parts.length == 2 && token.endsWith(".")) {
            parts = new String[]{parts[0], parts[1], ""};
        }
        if (parts.length != 3) {
            throw new DecodeException(String.format("The token was expected to have 3 parts, but got %s.", parts.length));
        }
        return parts;
    }

    @Nullable
    private String base64Decode(String string) {
        String decoded;
        try {
            byte[] bytes = Base64.decode((String)string, (int)11);
            decoded = new String(bytes, Charset.defaultCharset());
        }
        catch (IllegalArgumentException e) {
            throw new DecodeException("Received bytes didn't correspond to a valid Base64 encoded string.", e);
        }
        return decoded;
    }

    private <T> T parseJson(String json, Type typeOfT) {
        Object payload;
        try {
            payload = JWT.getGson().fromJson(json, typeOfT);
        }
        catch (Exception e) {
            throw new DecodeException("The token's payload had an invalid JSON format.", e);
        }
        return (T)payload;
    }

    static Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(JWTPayload.class, (Object)new JsonDeserializer<JWTPayload>(){

            public JWTPayload deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonNull() || !json.isJsonObject()) {
                    throw new DecodeException("The token's payload had an invalid JSON format.");
                }
                JsonObject object = json.getAsJsonObject();
                String iss = this.getString(object, "iss");
                String sub = this.getString(object, "sub");
                Date exp = this.getDate(object, "exp");
                Date nbf = this.getDate(object, "nbf");
                Date iat = this.getDate(object, "iat");
                String jti = this.getString(object, "jti");
                List<String> aud = this.getStringOrArray(object, "aud");
                HashMap<String, Claim> extra = new HashMap<String, Claim>();
                for (Map.Entry e : object.entrySet()) {
                    extra.put((String)e.getKey(), new ClaimImpl((JsonElement)e.getValue()));
                }
                return new JWTPayload(iss, sub, exp, nbf, iat, jti, aud, extra);
            }

            private List<String> getStringOrArray(JsonObject obj, String claimName) {
                List<String> list = Collections.emptyList();
                if (obj.has(claimName)) {
                    JsonElement arrElement = obj.get(claimName);
                    if (arrElement.isJsonArray()) {
                        JsonArray jsonArr = arrElement.getAsJsonArray();
                        list = new ArrayList<String>(jsonArr.size());
                        for (int i = 0; i < jsonArr.size(); ++i) {
                            list.add(jsonArr.get(i).getAsString());
                        }
                    } else {
                        list = Collections.singletonList(arrElement.getAsString());
                    }
                }
                return list;
            }

            private Date getDate(JsonObject obj, String claimName) {
                if (!obj.has(claimName)) {
                    return null;
                }
                long ms = obj.get(claimName).getAsLong() * 1000L;
                return new Date(ms);
            }

            private String getString(JsonObject obj, String claimName) {
                if (!obj.has(claimName)) {
                    return null;
                }
                return obj.get(claimName).getAsString();
            }
        }).create();
    }

    public static void parseToken(Context context, String token) {
        JWT jwtService = new JWT(token);
        MobiComUserPreference.getInstance(context).setUserAuthToken(token).setTokenCreatedAtTime(jwtService.getClaim("createdAtTime").asLong()).setTokenValidUptoMins(jwtService.getClaim("validUpto").asInt());
    }
}

