/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.authentication;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.authentication.JWT;
import com.applozic.mobicomkit.api.authentication.RefreshAuthTokenTask;
import com.applozic.mobicomkit.listners.AlCallback;

public class AlAuthService {
    public static boolean isTokenValid(long createdAtTime, int validUptoMins) {
        return (System.currentTimeMillis() - createdAtTime) / 60000L < (long)validUptoMins;
    }

    public static void refreshToken(Context context, AlCallback callback) {
        new RefreshAuthTokenTask(context, callback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static void verifyToken(Context context, String loadingMessage, AlCallback callback) {
        if (context == null) {
            return;
        }
        MobiComUserPreference userPreference = MobiComUserPreference.getInstance(context);
        if (userPreference == null) {
            return;
        }
        String token = userPreference.getUserAuthToken();
        long createdAtTime = userPreference.getTokenCreatedAtTime();
        int validUptoMins = userPreference.getTokenValidUptoMins();
        if (validUptoMins > 0 && !AlAuthService.isTokenValid(createdAtTime, validUptoMins) || TextUtils.isEmpty((CharSequence)token)) {
            AlAuthService.refreshToken(context, loadingMessage, callback);
        } else if (!TextUtils.isEmpty((CharSequence)token)) {
            if (createdAtTime == 0L || validUptoMins == 0) {
                JWT.parseToken(context, token);
                AlAuthService.verifyToken(context, loadingMessage, callback);
            }
            if (callback != null) {
                callback.onSuccess(true);
            }
        }
    }

    public static void refreshToken(Context context, String loadingMessage, final AlCallback callback) {
        final ProgressDialog progressDialog = new ProgressDialog((Context)AlAuthService.getActivity(context));
        progressDialog.setMessage((CharSequence)loadingMessage);
        progressDialog.setCancelable(false);
        progressDialog.show();
        AlAuthService.refreshToken(context, new AlCallback(){

            @Override
            public void onSuccess(Object response) {
                if (progressDialog != null) {
                    progressDialog.dismiss();
                }
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }

            @Override
            public void onError(Object error) {
                if (progressDialog != null) {
                    progressDialog.dismiss();
                }
                if (callback != null) {
                    callback.onSuccess(error);
                }
            }
        });
    }

    public static Activity getActivity(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

