/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.encryption.EncryptionUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;

public class HttpRequestUtils {
    private static final String TAG = "HttpRequestUtils";
    public static String APPLICATION_KEY_HEADER = "Application-Key";
    public static String USERID_HEADER = "UserId-Enabled";
    public static String USERID_HEADER_VALUE = "true";
    public static String DEVICE_KEY_HEADER = "Device-Key";
    public static String APP_MODULE_NAME_KEY_HEADER = "App-Module-Name";
    public static String ACCESS_TOKEN = "Access-Token";
    private static String SOURCE_HEADER = "Source";
    private static String SOURCE_HEADER_VALUE = "1";
    private static final String OF_USER_ID_HEADER = "Of-User-Id";
    private static final String APZ_PRODUCT_APP_HEADER = "Apz-Product-App";
    private static final String APZ_APP_ID_HEADER = "Apz-AppId";
    private static final String APZ_TOKEN_HEADER = "Apz-Token";
    private Context context;

    public HttpRequestUtils(Context context) {
        this.context = ApplozicService.getContext((Context)context);
    }

    public String postData(String urlString, String contentType, String accept, String data) throws Exception {
        return this.postData(urlString, contentType, accept, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postData(String urlString, String contentType, String accept, String data, String userId) throws Exception {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Calling url: " + urlString));
        try {
            if (!TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getEncryptionKey())) {
                data = EncryptionUtils.encrypt((String)MobiComUserPreference.getInstance(this.context).getEncryptionKey(), (String)data);
            }
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            this.addGlobalHeaders(connection, userId);
            connection.connect();
            if (connection == null) {
                return null;
            }
            if (data != null) {
                byte[] dataBytes = data.getBytes("UTF-8");
                DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                os.write(dataBytes);
                os.flush();
                os.close();
            }
            BufferedReader br = null;
            if (connection.getResponseCode() == 200 || connection.getResponseCode() == 201) {
                InputStream inputStream = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            }
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            Utils.printLog((Context)this.context, (String)TAG, (String)("Response : " + sb.toString()));
            if (!TextUtils.isEmpty((CharSequence)sb.toString()) && !TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getEncryptionKey())) {
                return EncryptionUtils.decrypt((String)MobiComUserPreference.getInstance(this.context).getEncryptionKey(), (String)sb.toString());
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)"Http call failed");
        return null;
    }

    public String postJsonToServer(String stringUrl, String data) throws Exception {
        return this.postJsonToServer(stringUrl, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postJsonToServer(String stringUrl, String data, String userId) throws Exception {
        URL url = new URL(stringUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        if (!TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getDeviceKeyString())) {
            connection.setRequestProperty(DEVICE_KEY_HEADER, MobiComUserPreference.getInstance(this.context).getDeviceKeyString());
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        this.addGlobalHeaders(connection, userId);
        connection.connect();
        byte[] dataBytes = data.getBytes("UTF-8");
        DataOutputStream os = new DataOutputStream(connection.getOutputStream());
        os.write(dataBytes);
        os.flush();
        os.close();
        BufferedReader br = null;
        if (connection.getResponseCode() == 200) {
            InputStream inputStream = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        } else {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Response code for post json is :" + connection.getResponseCode()));
        }
        StringBuilder sb = new StringBuilder();
        try {
            if (br != null) {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("Response: " + sb.toString()));
        return sb.toString();
    }

    public String getResponse(String urlString, String contentType, String accept) {
        return this.getResponse(urlString, contentType, accept, false, null);
    }

    public String getResponse(String urlString, String contentType, String accept, boolean isFileUpload) {
        return this.getResponse(urlString, contentType, accept, isFileUpload, null);
    }

    public String getResponseWithException(String urlString, String contentType, String accept, boolean isFileUpload, String userId) throws Exception {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Calling url: " + urlString));
        HttpURLConnection connection = null;
        try {
            String string;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            this.addGlobalHeaders(connection, userId);
            connection.connect();
            if (connection == null) {
                String string2 = null;
                return string2;
            }
            BufferedReader br = null;
            if (connection.getResponseCode() == 200) {
                InputStream inputStream = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            } else {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Response code for getResponse is  :" + connection.getResponseCode()));
            }
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            Utils.printLog((Context)this.context, (String)TAG, (String)("Response :" + sb.toString()));
            if (!TextUtils.isEmpty((CharSequence)sb.toString()) && !TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getEncryptionKey())) {
                string = isFileUpload ? sb.toString() : EncryptionUtils.decrypt((String)MobiComUserPreference.getInstance(this.context).getEncryptionKey(), (String)sb.toString());
                return string;
            }
            string = sb.toString();
            return string;
        }
        catch (ConnectException e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"failed to connect Internet is not working");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(String urlString, String contentType, String accept, boolean isFileUpload, String userId) {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Calling url: " + urlString));
        HttpURLConnection connection = null;
        try {
            String string;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            this.addGlobalHeaders(connection, userId);
            connection.connect();
            if (connection == null) {
                String string2 = null;
                return string2;
            }
            BufferedReader br = null;
            if (connection.getResponseCode() == 200) {
                InputStream inputStream = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            } else {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Response code for getResponse is  :" + connection.getResponseCode()));
            }
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            Utils.printLog((Context)this.context, (String)TAG, (String)("Response :" + sb.toString()));
            if (!TextUtils.isEmpty((CharSequence)sb.toString()) && !TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getEncryptionKey())) {
                string = isFileUpload ? sb.toString() : EncryptionUtils.decrypt((String)MobiComUserPreference.getInstance(this.context).getEncryptionKey(), (String)sb.toString());
                return string;
            }
            string = sb.toString();
            return string;
        }
        catch (ConnectException e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"failed to connect Internet is not working");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void addGlobalHeaders(HttpURLConnection connection, String userId) {
        try {
            connection.setRequestProperty(ACCESS_TOKEN, MobiComUserPreference.getInstance(this.context).getPassword());
            if (MobiComKitClientService.getAppModuleName(this.context) != null) {
                connection.setRequestProperty(APP_MODULE_NAME_KEY_HEADER, MobiComKitClientService.getAppModuleName(this.context));
            }
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                connection.setRequestProperty(OF_USER_ID_HEADER, URLEncoder.encode(userId, "UTF-8"));
            }
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            if (User.RoleType.AGENT.getValue().equals(userPreferences.getUserRoleType()) && !TextUtils.isEmpty((CharSequence)userId)) {
                connection.setRequestProperty(APZ_APP_ID_HEADER, MobiComKitClientService.getApplicationKey(this.context));
                connection.setRequestProperty(APZ_PRODUCT_APP_HEADER, "true");
                String userCredentials = this.getCredentialsWithPassword().getUserName() + ":" + String.valueOf(this.getCredentialsWithPassword().getPassword());
                String basicAuth = "Basic " + Base64.encodeToString((byte[])userCredentials.getBytes(), (int)2);
                connection.setRequestProperty(APZ_TOKEN_HEADER, basicAuth);
            } else {
                connection.setRequestProperty(APPLICATION_KEY_HEADER, MobiComKitClientService.getApplicationKey(this.context));
                connection.setRequestProperty(SOURCE_HEADER, SOURCE_HEADER_VALUE);
                connection.setRequestProperty(USERID_HEADER, USERID_HEADER_VALUE);
                connection.setRequestProperty(DEVICE_KEY_HEADER, MobiComUserPreference.getInstance(this.context).getDeviceKeyString());
                if (userPreferences.isRegistered()) {
                    String userCredentials = this.getCredentials().getUserName() + ":" + String.valueOf(this.getCredentials().getPassword());
                    String basicAuth = "Basic " + Base64.encodeToString((byte[])userCredentials.getBytes(), (int)2);
                    connection.setRequestProperty("Authorization", basicAuth);
                    connection.setRequestProperty("Application-User", basicAuth);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PasswordAuthentication getCredentials() {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isRegistered()) {
            return null;
        }
        return new PasswordAuthentication(userPreferences.getUserId(), userPreferences.getDeviceKeyString().toCharArray());
    }

    private PasswordAuthentication getCredentialsWithPassword() {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isRegistered()) {
            return null;
        }
        return new PasswordAuthentication(userPreferences.getUserId(), userPreferences.getPassword().toCharArray());
    }
}

