/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.MobiComPushReceiver;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.feed.GcmMessageResponse;
import com.applozic.mobicomkit.feed.InstantMessageResponse;
import com.applozic.mobicomkit.feed.MqttMessageResponse;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.Date;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class ApplozicMqttService
extends MobiComKitClientService
implements MqttCallback {
    private static final String STATUS = "status-v2";
    private static final String TAG = "ApplozicMqttService";
    private static final String TYPINGTOPIC = "typing-";
    private static final String OPEN_GROUP = "group-";
    private static ApplozicMqttService applozicMqttService;
    private MqttClient client;
    private MemoryPersistence memoryPersistence;
    private Context context;

    private ApplozicMqttService(Context context) {
        super(context);
        this.context = context;
        this.memoryPersistence = new MemoryPersistence();
    }

    public static ApplozicMqttService getInstance(Context context) {
        if (applozicMqttService == null) {
            applozicMqttService = new ApplozicMqttService(context.getApplicationContext());
        }
        return applozicMqttService;
    }

    private MqttClient connect() {
        String userId = MobiComUserPreference.getInstance(this.context).getUserId();
        try {
            if (TextUtils.isEmpty((CharSequence)userId)) {
                return this.client;
            }
            if (this.client == null) {
                this.client = new MqttClient(this.getMqttBaseUrl(), userId + "-" + new Date().getTime(), (MqttClientPersistence)this.memoryPersistence);
            }
            if (!this.client.isConnected()) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Connecting to mqtt...");
                MqttConnectOptions options = new MqttConnectOptions();
                options.setConnectionTimeout(60);
                options.setWill(STATUS, (MobiComUserPreference.getInstance(this.context).getSuUserKeyString() + "," + MobiComUserPreference.getInstance(this.context).getDeviceKeyString() + ",0").getBytes(), 0, true);
                this.client.setCallback((MqttCallback)this);
                this.client.connect(options);
            }
        }
        catch (MqttException e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Connecting already in progress.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.client;
    }

    public synchronized void connectPublish(String userKeyString, String deviceKeyString, String status) {
        try {
            MqttClient client = this.connect();
            if (client == null || !client.isConnected()) {
                return;
            }
            MqttMessage message = new MqttMessage();
            message.setRetained(false);
            message.setPayload((userKeyString + "," + deviceKeyString + "," + status).getBytes());
            Utils.printLog((Context)this.context, (String)TAG, (String)("UserKeyString,DeviceKeyString,status:" + userKeyString + "," + deviceKeyString + "," + status));
            message.setQos(0);
            client.publish(STATUS, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void subscribe() {
        if (!Utils.isInternetAvailable((Context)this.context)) {
            return;
        }
        String deviceKeyString = MobiComUserPreference.getInstance(this.context).getDeviceKeyString();
        String userKeyString = MobiComUserPreference.getInstance(this.context).getSuUserKeyString();
        if (TextUtils.isEmpty((CharSequence)deviceKeyString) || TextUtils.isEmpty((CharSequence)userKeyString)) {
            return;
        }
        try {
            MqttClient client = this.connect();
            if (client == null || !client.isConnected()) {
                return;
            }
            this.connectPublish(userKeyString, deviceKeyString, "1");
            this.subscribeToConversation();
            if (client != null) {
                client.setCallback((MqttCallback)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void unSubscribe() {
        this.unSubscribeToConversation();
    }

    public synchronized void subscribeToConversation() {
        try {
            String userKeyString = MobiComUserPreference.getInstance(this.context).getSuUserKeyString();
            if (TextUtils.isEmpty((CharSequence)userKeyString)) {
                return;
            }
            if (this.client != null && this.client.isConnected()) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Subscribing to conversation topic.");
                this.client.subscribe(userKeyString, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void unSubscribeToConversation() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ApplozicMqttService.this.client == null || !ApplozicMqttService.this.client.isConnected()) {
                        return;
                    }
                    String userKeyString = MobiComUserPreference.getInstance(ApplozicMqttService.this.context).getSuUserKeyString();
                    ApplozicMqttService.this.client.unsubscribe(userKeyString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public void disconnectPublish(String userKeyString, String deviceKeyString, String status) {
        try {
            this.connectPublish(userKeyString, deviceKeyString, status);
            if (!MobiComUserPreference.getInstance(this.context).isLoggedIn()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void connectionLost(Throwable throwable) {
        BroadcastService.sendUpdate(this.context, BroadcastService.INTENT_ACTIONS.MQTT_DISCONNECTED.toString());
    }

    public void messageArrived(String s, final MqttMessage mqttMessage) throws Exception {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Received MQTT message: " + new String(mqttMessage.getPayload())));
        try {
            if (!TextUtils.isEmpty((CharSequence)s) && s.startsWith(TYPINGTOPIC)) {
                String[] typingResponse = mqttMessage.toString().split(",");
                String applicationId = typingResponse[0];
                String userId = typingResponse[1];
                String isTypingStatus = typingResponse[2];
                BroadcastService.sendUpdateTypingBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_TYPING_STATUS.toString(), applicationId, userId, isTypingStatus);
            } else {
                final MqttMessageResponse mqttMessageResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), MqttMessageResponse.class));
                if (mqttMessageResponse != null) {
                    if (MobiComPushReceiver.processPushNotificationId(mqttMessageResponse.getId())) {
                        return;
                    }
                    final SyncCallService syncCallService = SyncCallService.getInstance(this.context);
                    MobiComPushReceiver.addPushNotificationId(mqttMessageResponse.getId());
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            InstantMessageResponse instantMessageResponse;
                            String keyString;
                            String[] splitKeyString;
                            GcmMessageResponse messageResponse;
                            Utils.printLog((Context)ApplozicMqttService.this.context, (String)ApplozicMqttService.TAG, (String)("MQTT message type: " + mqttMessageResponse.getType()));
                            if (NOTIFICATION_TYPE.MESSAGE_RECEIVED.getValue().equals(mqttMessageResponse.getType()) || "MESSAGE_RECEIVED".equals(mqttMessageResponse.getType())) {
                                messageResponse = (GcmMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), GcmMessageResponse.class));
                                if (messageResponse == null) {
                                    return;
                                }
                                Message message = messageResponse.getMessage();
                                if (message.getGroupId() != null) {
                                    Channel channel = ChannelService.getInstance(ApplozicMqttService.this.context).getChannelByChannelKey(message.getGroupId());
                                    if (channel != null && Channel.GroupType.OPEN.getValue().equals(channel.getType())) {
                                        if (!MobiComUserPreference.getInstance(ApplozicMqttService.this.context).getDeviceKeyString().equals(message.getDeviceKeyString())) {
                                            syncCallService.syncMessages(message.getKeyString(), message);
                                        }
                                    } else {
                                        syncCallService.syncMessages(null);
                                    }
                                } else {
                                    syncCallService.syncMessages(null);
                                }
                            }
                            if (NOTIFICATION_TYPE.MESSAGE_DELIVERED.getValue().equals(mqttMessageResponse.getType()) || "MT_MESSAGE_DELIVERED".equals(mqttMessageResponse.getType())) {
                                splitKeyString = mqttMessageResponse.getMessage().toString().split(",");
                                keyString = splitKeyString[0];
                                syncCallService.updateDeliveryStatus(keyString);
                            }
                            if (NOTIFICATION_TYPE.MESSAGE_DELIVERED_AND_READ.getValue().equals(mqttMessageResponse.getType()) || "MT_MESSAGE_DELIVERED_READ".equals(mqttMessageResponse.getType())) {
                                splitKeyString = mqttMessageResponse.getMessage().toString().split(",");
                                keyString = splitKeyString[0];
                                syncCallService.updateReadStatus(keyString);
                            }
                            if (NOTIFICATION_TYPE.CONVERSATION_DELIVERED_AND_READ.getValue().equals(mqttMessageResponse.getType())) {
                                String contactId = mqttMessageResponse.getMessage().toString();
                                syncCallService.updateDeliveryStatusForContact(contactId, true);
                            }
                            if (NOTIFICATION_TYPE.CONVERSATION_READ.getValue().equals(mqttMessageResponse.getType())) {
                                syncCallService.updateConversationReadStatus(mqttMessageResponse.getMessage().toString(), false);
                            }
                            if (NOTIFICATION_TYPE.GROUP_CONVERSATION_READ.getValue().equals(mqttMessageResponse.getType())) {
                                instantMessageResponse = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), InstantMessageResponse.class));
                                syncCallService.updateConversationReadStatus(instantMessageResponse.getMessage(), true);
                            }
                            if (NOTIFICATION_TYPE.USER_CONNECTED.getValue().equals(mqttMessageResponse.getType())) {
                                syncCallService.updateConnectedStatus(mqttMessageResponse.getMessage().toString(), new Date(), true);
                            }
                            if (NOTIFICATION_TYPE.USER_DISCONNECTED.getValue().equals(mqttMessageResponse.getType())) {
                                String[] parts = mqttMessageResponse.getMessage().toString().split(",");
                                String userId = parts[0];
                                Date lastSeenAt = new Date();
                                if (parts.length >= 2 && !parts[1].equals("null")) {
                                    lastSeenAt = new Date(Long.valueOf(parts[1]));
                                }
                                syncCallService.updateConnectedStatus(userId, lastSeenAt, false);
                            }
                            if (NOTIFICATION_TYPE.CONVERSATION_DELETED.getValue().equals(mqttMessageResponse.getType())) {
                                syncCallService.deleteConversationThread(mqttMessageResponse.getMessage().toString());
                                BroadcastService.sendConversationDeleteBroadcast(ApplozicMqttService.this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), mqttMessageResponse.getMessage().toString(), 0, "success");
                            }
                            if (NOTIFICATION_TYPE.GROUP_CONVERSATION_DELETED.getValue().equals(mqttMessageResponse.getType())) {
                                instantMessageResponse = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), InstantMessageResponse.class));
                                syncCallService.deleteChannelConversationThread(instantMessageResponse.getMessage());
                                BroadcastService.sendConversationDeleteBroadcast(ApplozicMqttService.this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), null, Integer.valueOf(instantMessageResponse.getMessage()), "success");
                            }
                            if (NOTIFICATION_TYPE.MESSAGE_DELETED.getValue().equals(mqttMessageResponse.getType())) {
                                String messageKey = mqttMessageResponse.getMessage().toString().split(",")[0];
                                syncCallService.deleteMessage(messageKey);
                                BroadcastService.sendMessageDeleteBroadcast(ApplozicMqttService.this.context, BroadcastService.INTENT_ACTIONS.DELETE_MESSAGE.toString(), messageKey, null);
                            }
                            if (NOTIFICATION_TYPE.MESSAGE_SENT.getValue().equals(mqttMessageResponse.getType())) {
                                messageResponse = (GcmMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), GcmMessageResponse.class));
                                Message sentMessageSync = messageResponse.getMessage();
                                syncCallService.syncMessages(sentMessageSync.getKeyString());
                            }
                            if (NOTIFICATION_TYPE.USER_BLOCKED.getValue().equals(mqttMessageResponse.getType()) || NOTIFICATION_TYPE.USER_UN_BLOCKED.getValue().equals(mqttMessageResponse.getType())) {
                                syncCallService.syncBlockUsers();
                            }
                            if (NOTIFICATION_TYPE.USER_DETAIL_CHANGED.getValue().equals(mqttMessageResponse.getType()) || NOTIFICATION_TYPE.USER_DELETE_NOTIFICATION.getValue().equals(mqttMessageResponse.getType())) {
                                String userId = mqttMessageResponse.getMessage().toString();
                                syncCallService.syncUserDetail(userId);
                            }
                            if (Applozic.getInstance(ApplozicMqttService.this.context).isDeviceContactSync() && NOTIFICATION_TYPE.CONTACT_SYNC.getValue().equals(mqttMessageResponse.getType())) {
                                syncCallService.processContactSync(mqttMessageResponse.getMessage().toString());
                            }
                            if (NOTIFICATION_TYPE.MESSAGE_METADATA_UPDATE.getValue().equals(mqttMessageResponse.getType())) {
                                String keyString2 = null;
                                String deviceKey = null;
                                try {
                                    GcmMessageResponse messageResponse2 = (GcmMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), GcmMessageResponse.class));
                                    keyString2 = messageResponse2.getMessage().getKeyString();
                                    deviceKey = messageResponse2.getMessage().getDeviceKeyString();
                                }
                                catch (Exception e) {
                                    try {
                                        InstantMessageResponse response = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), InstantMessageResponse.class));
                                        keyString2 = response.getMessage();
                                        Message message = new MessageDatabaseService(ApplozicMqttService.this.context).getMessage(keyString2);
                                        Utils.printLog((Context)ApplozicMqttService.this.context, (String)ApplozicMqttService.TAG, (String)("Message from db : " + (Object)((Object)message)));
                                        if (message != null) {
                                            deviceKey = message.getDeviceKeyString();
                                        }
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                if (deviceKey != null && deviceKey.equals(MobiComUserPreference.getInstance(ApplozicMqttService.this.context).getDeviceKeyString())) {
                                    return;
                                }
                                syncCallService.syncMessageMetadataUpdate(keyString2, false);
                            }
                            if (NOTIFICATION_TYPE.USER_MUTE_NOTIFICATION.getValue().equals(mqttMessageResponse.getType())) {
                                try {
                                    InstantMessageResponse response = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson((String)mqttMessage.toString(), InstantMessageResponse.class));
                                    if (response.getMessage() != null) {
                                        String muteFlag = String.valueOf(response.getMessage().charAt(response.getMessage().length() - 1));
                                        if ("1".equals(muteFlag)) {
                                            syncCallService.syncMutedUserList(false, null);
                                        } else if ("0".equals(muteFlag)) {
                                            String userId = response.getMessage().substring(0, response.getMessage().length() - 2);
                                            syncCallService.syncMutedUserList(false, userId);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                    thread.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void publishTopic(String applicationId, String status, String loggedInUserId, String userId) {
        try {
            MqttClient client = this.connect();
            if (client == null || !client.isConnected()) {
                return;
            }
            MqttMessage message = new MqttMessage();
            message.setRetained(false);
            message.setPayload((applicationId + "," + loggedInUserId + "," + status).getBytes());
            message.setQos(0);
            client.publish(TYPINGTOPIC + applicationId + "-" + userId, message);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Published " + new String(message.getPayload()) + " to topic: typing-" + applicationId + "-" + userId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void subscribeToTypingTopic(Channel channel) {
        try {
            String currentId = null;
            if (channel != null) {
                currentId = String.valueOf(channel.getKey());
            } else {
                MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
                currentId = mobiComUserPreference.getUserId();
            }
            MqttClient client = this.connect();
            if (client == null || !client.isConnected()) {
                return;
            }
            client.subscribe(TYPINGTOPIC + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId, 0);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Subscribed to topic: typing-" + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void unSubscribeToTypingTopic(Channel channel) {
        try {
            String currentId = null;
            if (channel != null) {
                currentId = String.valueOf(channel.getKey());
            } else {
                MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
                currentId = mobiComUserPreference.getUserId();
            }
            MqttClient client = this.connect();
            if (client == null || !client.isConnected()) {
                return;
            }
            client.unsubscribe(TYPINGTOPIC + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId);
            Utils.printLog((Context)this.context, (String)TAG, (String)("UnSubscribed to topic: typing-" + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void typingStarted(Contact contact, Channel channel) {
        String currentId = channel != null ? String.valueOf(channel.getKey()) : contact.getUserId();
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        this.publishTopic(ApplozicMqttService.getApplicationKey(this.context), "1", mobiComUserPreference.getUserId(), currentId);
    }

    public void typingStopped(Contact contact, Channel channel) {
        String currentId = channel != null ? String.valueOf(channel.getKey()) : contact.getUserId();
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        this.publishTopic(ApplozicMqttService.getApplicationKey(this.context), "0", mobiComUserPreference.getUserId(), currentId);
    }

    public synchronized void subscribeToOpenGroupTopic(Channel channel) {
        try {
            MqttClient client;
            String currentId = null;
            if (channel != null) {
                currentId = String.valueOf(channel.getKey());
            }
            if ((client = this.connect()) == null || !client.isConnected()) {
                return;
            }
            client.subscribe(OPEN_GROUP + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId, 0);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Subscribed to Open group: group-" + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void unSubscribeToOpenGroupTopic(Channel channel) {
        try {
            MqttClient client;
            String currentId = null;
            if (channel != null) {
                currentId = String.valueOf(channel.getKey());
            }
            if ((client = this.connect()) == null || !client.isConnected()) {
                return;
            }
            client.unsubscribe(OPEN_GROUP + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId);
            Utils.printLog((Context)this.context, (String)TAG, (String)("UnSubscribed to topic: group-" + ApplozicMqttService.getApplicationKey(this.context) + "-" + currentId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum NOTIFICATION_TYPE {
        MESSAGE_RECEIVED("APPLOZIC_01"),
        MESSAGE_SENT("APPLOZIC_02"),
        MESSAGE_SENT_UPDATE("APPLOZIC_03"),
        MESSAGE_DELIVERED("APPLOZIC_04"),
        MESSAGE_DELETED("APPLOZIC_05"),
        CONVERSATION_DELETED("APPLOZIC_06"),
        MESSAGE_READ("APPLOZIC_07"),
        MESSAGE_DELIVERED_AND_READ("APPLOZIC_08"),
        CONVERSATION_READ("APPLOZIC_09"),
        CONVERSATION_DELIVERED_AND_READ("APPLOZIC_10"),
        USER_CONNECTED("APPLOZIC_11"),
        USER_DISCONNECTED("APPLOZIC_12"),
        GROUP_DELETED("APPLOZIC_13"),
        GROUP_LEFT("APPLOZIC_14"),
        GROUP_SYNC("APPLOZIC_15"),
        USER_BLOCKED("APPLOZIC_16"),
        USER_UN_BLOCKED("APPLOZIC_17"),
        ACTIVATED("APPLOZIC_18"),
        DEACTIVATED("APPLOZIC_19"),
        REGISTRATION("APPLOZIC_20"),
        GROUP_CONVERSATION_READ("APPLOZIC_21"),
        GROUP_MESSAGE_DELETED("APPLOZIC_22"),
        GROUP_CONVERSATION_DELETED("APPLOZIC_23"),
        APPLOZIC_TEST("APPLOZIC_24"),
        USER_ONLINE_STATUS("APPLOZIC_25"),
        CONTACT_SYNC("APPLOZIC_26"),
        CONVERSATION_DELETED_NEW("APPLOZIC_27"),
        CONVERSATION_DELIVERED_AND_READ_NEW("APPLOZIC_28"),
        CONVERSATION_READ_NEW("APPLOZIC_29"),
        USER_DETAIL_CHANGED("APPLOZIC_30"),
        MESSAGE_METADATA_UPDATE("APPLOZIC_33"),
        USER_DELETE_NOTIFICATION("APPLOZIC_34"),
        USER_MUTE_NOTIFICATION("APPLOZIC_37");

        private String value;

        private NOTIFICATION_TYPE(String c) {
            this.value = c;
        }

        public String getValue() {
            return String.valueOf(this.value);
        }
    }
}

