/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.applozic.mobicomkit.AlUserUpdate;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.MuteUserResponse;
import com.applozic.mobicomkit.api.notification.NotificationChannels;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.SyncBlockUserApiResponse;
import com.applozic.mobicomkit.feed.UserDetailListFeed;
import com.applozic.mobicommons.ALSpecificSettings;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class UserClientService
extends MobiComKitClientService {
    public static final String APP_VERSION_UPDATE_URL = "/rest/ws/register/version/update";
    public static final String USER_INFO_URL = "/rest/ws/user/info?";
    public static final Short MOBICOMKIT_VERSION_CODE = 109;
    public static final String USER_DISPLAY_NAME_UPDATE = "/rest/ws/user/name?";
    public static final String BLOCK_USER_URL = "/rest/ws/user/block";
    public static final String BLOCK_USER_SYNC_URL = "/rest/ws/user/blocked/sync";
    public static final String UNBLOCK_USER_SYNC_URL = "/rest/ws/user/unblock";
    public static final String USER_DETAILS_URL = "/rest/ws/user/detail?";
    public static final String ONLINE_USER_LIST_URL = "/rest/ws/user/ol/list";
    public static final String REGISTERED_USER_LIST_URL = "/rest/ws/user/filter";
    public static final String USER_PROFILE_UPDATE_URL = "/rest/ws/user/update";
    public static final String USER_READ_URL = "/rest/ws/user/read";
    public static final String USER_DETAILS_LIST_POST_URL = "/rest/ws/user/detail";
    public static final String UPDATE_USER_PASSWORD = "/rest/ws/user/update/password";
    public static final String USER_LOGOUT = "/rest/ws/device/logout";
    private static final String MUTE_USER_URL = "/rest/ws/user/chat/mute";
    private static final String USER_SEARCH_URL = "/rest/ws/user/search/contact";
    private static final String GET_MUTED_USER_LIST = "/rest/ws/user/chat/mute/list";
    public static final int BATCH_SIZE = 60;
    private static final String TAG = "UserClientService";
    private HttpRequestUtils httpRequestUtils;

    public UserClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getUserProfileUpdateUrl() {
        return this.getBaseUrl() + USER_PROFILE_UPDATE_URL;
    }

    public String getAppVersionUpdateUrl() {
        return this.getBaseUrl() + APP_VERSION_UPDATE_URL;
    }

    public String getUpdateUserDisplayNameUrl() {
        return this.getBaseUrl() + USER_DISPLAY_NAME_UPDATE;
    }

    public String getUserInfoUrl() {
        return this.getBaseUrl() + USER_INFO_URL;
    }

    public String getBlockUserUrl() {
        return this.getBaseUrl() + BLOCK_USER_URL;
    }

    public String getBlockUserSyncUrl() {
        return this.getBaseUrl() + BLOCK_USER_SYNC_URL;
    }

    public String getUnBlockUserSyncUrl() {
        return this.getBaseUrl() + UNBLOCK_USER_SYNC_URL;
    }

    public String getUserDetailsListUrl() {
        return this.getBaseUrl() + USER_DETAILS_URL;
    }

    public String getOnlineUserListUrl() {
        return this.getBaseUrl() + ONLINE_USER_LIST_URL;
    }

    public String getRegisteredUserListUrl() {
        return this.getBaseUrl() + REGISTERED_USER_LIST_URL;
    }

    public String getUserDetailsListPostUrl() {
        return this.getBaseUrl() + USER_DETAILS_LIST_POST_URL;
    }

    public String getUserReadUrl() {
        return this.getBaseUrl() + USER_READ_URL;
    }

    public String getUpdateUserPasswordUrl() {
        return this.getBaseUrl() + UPDATE_USER_PASSWORD;
    }

    public String getUserLogout() {
        return this.getBaseUrl() + USER_LOGOUT;
    }

    private String getMuteUserUrl() {
        return this.getBaseUrl() + MUTE_USER_URL;
    }

    private String getMutedUserListUrl() {
        return this.getBaseUrl() + GET_MUTED_USER_LIST;
    }

    private String getUserSearchUrl() {
        return this.getBaseUrl() + USER_SEARCH_URL;
    }

    public ApiResponse logout() {
        return this.logout(false);
    }

    public void clearDataAndPreference() {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        String deviceKeyString = mobiComUserPreference.getDeviceKeyString();
        String userKeyString = mobiComUserPreference.getSuUserKeyString();
        String url = mobiComUserPreference.getUrl();
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        notificationManager.cancelAll();
        mobiComUserPreference.clearAll();
        ChannelService.clearInstance();
        MessageDatabaseService.recentlyAddedMessage.clear();
        MobiComDatabaseHelper.getInstance(this.context).delDatabase();
        mobiComUserPreference.setUrl(url);
        Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
        intent.putExtra("userKeyString", userKeyString);
        intent.putExtra("deviceKeyString", deviceKeyString);
        ApplozicMqttIntentService.enqueueWork(this.context, intent);
    }

    public ApiResponse logout(boolean fromLogin) {
        Utils.printLog((Context)this.context, (String)TAG, (String)"Al Logout call !!");
        ApiResponse apiResponse = this.userLogoutResponse();
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        String deviceKeyString = mobiComUserPreference.getDeviceKeyString();
        String userKeyString = mobiComUserPreference.getSuUserKeyString();
        String url = mobiComUserPreference.getUrl();
        if (Build.VERSION.SDK_INT >= 26) {
            Applozic.getInstance(this.context).setCustomNotificationSound(null);
            new NotificationChannels(this.context, null).deleteAllChannels();
        }
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        notificationManager.cancelAll();
        mobiComUserPreference.clearAll();
        ALSpecificSettings.getInstance((Context)this.context).clearAll();
        MessageDatabaseService.recentlyAddedMessage.clear();
        MobiComDatabaseHelper.getInstance(this.context).delDatabase();
        mobiComUserPreference.setUrl(url);
        if (!fromLogin) {
            Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
            intent.putExtra("userKeyString", userKeyString);
            intent.putExtra("deviceKeyString", deviceKeyString);
            ApplozicMqttIntentService.enqueueWork(this.context, intent);
        }
        return apiResponse;
    }

    public ApiResponse userLogoutResponse() {
        String response = "";
        ApiResponse apiResponse = null;
        try {
            response = this.httpRequestUtils.postData(this.getUserLogout(), "application/json", "application/json", null);
            if (!TextUtils.isEmpty((CharSequence)response)) {
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public void updateCodeVersion(String deviceKeyString) {
        String url = this.getAppVersionUpdateUrl() + "?appVersionCode=" + MOBICOMKIT_VERSION_CODE + "&deviceKey=" + deviceKeyString;
        String response = this.httpRequestUtils.getResponse(url, "text/plain", "text/plain");
        Utils.printLog((Context)this.context, (String)TAG, (String)("Version update response: " + response));
    }

    public Map<String, String> getUserInfo(Set<String> userIds) throws JSONException, UnsupportedEncodingException {
        if (userIds == null && userIds.isEmpty()) {
            return new HashMap<String, String>();
        }
        String userIdParam = "";
        for (String userId : userIds) {
            userIdParam = userIdParam + "&userIds=" + URLEncoder.encode(userId, "UTF-8");
        }
        String response = this.httpRequestUtils.getResponse(this.getUserInfoUrl() + userIdParam, "application/json", "application/json");
        Utils.printLog((Context)this.context, (String)TAG, (String)("Response: " + response));
        JSONObject jsonObject = new JSONObject(response);
        HashMap<String, String> info = new HashMap<String, String>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            info.put(key, value);
        }
        return info;
    }

    public void updateUserDisplayName(final String userId, final String displayName) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String parameters = "";
                try {
                    if (!TextUtils.isEmpty((CharSequence)userId) && !TextUtils.isEmpty((CharSequence)displayName)) {
                        parameters = "userId=" + URLEncoder.encode(userId, "UTF-8") + "&displayName=" + URLEncoder.encode(displayName, "UTF-8");
                        String response = UserClientService.this.httpRequestUtils.getResponse(UserClientService.this.getUpdateUserDisplayNameUrl() + parameters, "application/json", "application/json");
                        ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                        if (apiResponse != null) {
                            Utils.printLog((Context)UserClientService.this.context, (String)UserClientService.TAG, (String)(" Update display name Response :" + apiResponse.getStatus()));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public ApiResponse userBlock(String userId, boolean block) {
        String response = "";
        ApiResponse apiResponse = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                response = this.httpRequestUtils.getResponse((block ? this.getBlockUserUrl() : this.getUnBlockUserSyncUrl()) + "?userId=" + URLEncoder.encode(userId, "UTF-8"), "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public ApiResponse userUnBlock(String userId) {
        String response = "";
        ApiResponse apiResponse = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                response = this.httpRequestUtils.getResponse(this.getUnBlockUserSyncUrl() + "?userId=" + URLEncoder.encode(userId, "UTF-8"), "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public SyncBlockUserApiResponse getSyncUserBlockList(String lastSyncTime) {
        try {
            String url = this.getBlockUserSyncUrl() + "?lastSyncTime=" + lastSyncTime;
            String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
            if (response == null || TextUtils.isEmpty((CharSequence)response) || response.equals("UnAuthorized Access")) {
                return null;
            }
            return (SyncBlockUserApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, SyncBlockUserApiResponse.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUserDetails(Set<String> userIds) {
        try {
            if (userIds != null && userIds.size() > 0) {
                String response = "";
                String userIdParam = "";
                for (String userId : userIds) {
                    userIdParam = userIdParam + "&userIds=" + URLEncoder.encode(userId, "UTF-8");
                }
                response = this.httpRequestUtils.getResponse(this.getUserDetailsListUrl() + userIdParam, "application/json", "application/json");
                Utils.printLog((Context)this.context, (String)TAG, (String)("User details response is :" + response));
                if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
                    return null;
                }
                return response;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String postUserDetailsByUserIds(Set<String> userIds) {
        try {
            if (userIds != null && userIds.size() > 0) {
                ArrayList<String> userDetailsList = new ArrayList<String>();
                String response = "";
                int count = 0;
                for (String userId : userIds) {
                    userDetailsList.add(userId);
                    if (++count % 60 != 0) continue;
                    UserDetailListFeed userDetailListFeed = new UserDetailListFeed();
                    userDetailListFeed.setContactSync(true);
                    userDetailListFeed.setUserIdList(userDetailsList);
                    String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)userDetailListFeed), ((Object)((Object)userDetailListFeed)).getClass());
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Sending json:" + jsonFromObject));
                    response = this.httpRequestUtils.postData(this.getUserDetailsListPostUrl(), "application/json", "application/json", jsonFromObject);
                    userDetailsList = new ArrayList();
                    if (TextUtils.isEmpty((CharSequence)response)) continue;
                    UserService.getInstance(this.context).processUserDetailsResponse(response);
                }
                if (!userDetailsList.isEmpty() && userDetailsList.size() > 0) {
                    UserDetailListFeed userDetailListFeed = new UserDetailListFeed();
                    userDetailListFeed.setContactSync(true);
                    userDetailListFeed.setUserIdList(userDetailsList);
                    String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)userDetailListFeed), ((Object)((Object)userDetailListFeed)).getClass());
                    response = this.httpRequestUtils.postData(this.getUserDetailsListPostUrl(), "application/json", "application/json", jsonFromObject);
                    Utils.printLog((Context)this.context, (String)TAG, (String)("User details response is :" + response));
                    if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
                        return null;
                    }
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        UserService.getInstance(this.context).processUserDetailsResponse(response);
                    }
                }
                return response;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, String> getOnlineUserList(int numberOfUser) {
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            String response = this.httpRequestUtils.getResponse(this.getOnlineUserListUrl() + "?startIndex=0&pageSize=" + numberOfUser, "application/json", "application/json");
            if (response != null && !"error".equals(response)) {
                JSONObject jsonObject = new JSONObject(response);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = jsonObject.getString(key);
                    info.put(key, value);
                }
                return info;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public String getRegisteredUsers(Long startTime, int pageSize) {
        String response = null;
        try {
            String url = "?pageSize=" + pageSize;
            if (startTime > 0L) {
                url = url + "&startTime=" + startTime;
            }
            response = this.httpRequestUtils.getResponse(this.getRegisteredUserListUrl() + url, "application/json", "application/json");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public ApiResponse updateDisplayNameORImageLink(String displayName, String profileImageLink, String status, String contactNumber, String emailId, Map<String, String> metadata, String userId) {
        AlUserUpdate userUpdate = new AlUserUpdate();
        try {
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                userUpdate.setDisplayName(displayName);
            }
            if (!TextUtils.isEmpty((CharSequence)profileImageLink)) {
                userUpdate.setImageLink(profileImageLink);
            }
            if (!TextUtils.isEmpty((CharSequence)status)) {
                userUpdate.setStatusMessage(status);
            }
            if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
                userUpdate.setPhoneNumber(contactNumber);
            }
            if (!TextUtils.isEmpty((CharSequence)emailId)) {
                userUpdate.setEmail(emailId);
            }
            if (metadata != null && !metadata.isEmpty()) {
                userUpdate.setMetadata(metadata);
            }
            String response = this.httpRequestUtils.postData(this.getUserProfileUpdateUrl(), "application/json", "application/json", GsonUtils.getJsonFromObject((Object)((Object)userUpdate), AlUserUpdate.class), userId);
            Utils.printLog((Context)this.context, (String)TAG, (String)response);
            return (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ApiResponse muteUserNotifications(String userId, Long notificationAfterTime) {
        if (userId == null || notificationAfterTime == null) {
            return null;
        }
        JSONObject jsonFromObject = new JSONObject();
        try {
            String url = this.getMuteUserUrl() + "?userId=" + userId + "&notificationAfterTime=" + notificationAfterTime;
            String response = this.httpRequestUtils.postData(url, "application/json", "application/json", jsonFromObject.toString());
            Utils.printLog((Context)this.context, (String)TAG, (String)("Mute user chat response : " + response));
            if (!TextUtils.isEmpty((CharSequence)response)) {
                return (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public MuteUserResponse[] getMutedUserList() {
        try {
            String response = this.httpRequestUtils.getResponse(this.getMutedUserListUrl(), "application/json", "application/json");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Muted users list reponse : " + response));
            if (!TextUtils.isEmpty((CharSequence)response)) {
                return (MuteUserResponse[])GsonUtils.getObjectFromJson((String)response, MuteUserResponse[].class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public ApiResponse getUserReadServerCall() {
        String response = null;
        ApiResponse apiResponse = null;
        try {
            response = this.httpRequestUtils.getResponse(this.getUserReadUrl(), null, null);
            if (response != null) {
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
            Utils.printLog((Context)this.context, (String)TAG, (String)("User read response: " + response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public String updateUserPassword(String oldPassword, String newPassword) {
        if (TextUtils.isEmpty((CharSequence)oldPassword) || TextUtils.isEmpty((CharSequence)newPassword)) {
            return null;
        }
        String response = "";
        ApiResponse apiResponse = null;
        try {
            response = this.httpRequestUtils.getResponse(this.getUpdateUserPasswordUrl() + "?oldPassword=" + oldPassword + "&newPassword=" + newPassword, "application/json", "application/json");
            if (TextUtils.isEmpty((CharSequence)response)) {
                return null;
            }
            apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            if (apiResponse != null && apiResponse.isSuccess()) {
                return apiResponse.getStatus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ApiResponse getUsersBySearchString(String searchString) throws ApplozicException {
        ApiResponse apiResponse;
        if (TextUtils.isEmpty((CharSequence)searchString)) {
            return null;
        }
        try {
            String response = this.httpRequestUtils.getResponse(this.getUserSearchUrl() + "?name=" + URLEncoder.encode(searchString, "UTF-8"), "application/json", "application/json");
            if (TextUtils.isEmpty((CharSequence)response)) {
                return null;
            }
            Utils.printLog((Context)this.context, (String)TAG, (String)("Search user response : " + response));
            apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
        }
        catch (Exception e) {
            throw new ApplozicException(e.getMessage());
        }
        return apiResponse;
    }
}

