/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.JobIntentService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.DeviceContactService;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.Date;
import java.util.HashSet;

public class DeviceContactSyncService
extends JobIntentService {
    private static final String TAG = "DvcContactSync";
    public static final String PROCESS_USER_DETAILS = "PROCESS_USER_DETAILS";
    public static final String PROCESS_MODIFIED_DEVICE_CONTACTS = "PROCESS_MODIFIED_DEVICE_CONTACTS";
    static final int JOB_ID = 2000;

    public static void enqueueWork(Context context, Intent work) {
        DeviceContactSyncService.enqueueWork((Context)context, DeviceContactSyncService.class, (int)2000, (Intent)work);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        if (intent == null) {
            return;
        }
        Thread thread = new Thread(new DeviceContactSync(intent.getBooleanExtra(PROCESS_USER_DETAILS, false), intent.getBooleanExtra(PROCESS_MODIFIED_DEVICE_CONTACTS, false)));
        thread.start();
    }

    private void process(boolean processUserDetails) {
        Uri uri = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
        String[] projection = new String[]{"display_name", "data1", "lookup"};
        Cursor people = this.getApplicationContext().getContentResolver().query(uri, projection, null, null, null);
        AppContactService appContactService = new AppContactService((Context)this);
        Log.i((String)TAG, (String)("Found " + people.getCount() + " device contacts"));
        DeviceContactService deviceContactService = new DeviceContactService(this.getApplicationContext());
        HashSet<String> userIdList = new HashSet<String>();
        while (people.moveToNext()) {
            Contact contact = deviceContactService.getContactFromContactCursor(people);
            if (contact == null) continue;
            appContactService.upsert(contact);
            userIdList.add(contact.getFormattedContactNumber());
        }
        if (processUserDetails && !userIdList.isEmpty()) {
            UserService userService = UserService.getInstance((Context)this);
            userService.processUserDetailsByContactNos(userIdList);
        }
        if (processUserDetails) {
            MobiComUserPreference.getInstance((Context)this).setDeviceContactSyncTime(new Date().getTime());
        }
        if (people != null) {
            people.close();
        }
    }

    private void processModifiedContacts() {
        new DeviceContactService((Context)this).processModifiedContacts();
    }

    private class DeviceContactSync
    implements Runnable {
        private boolean processUserDetails;
        private boolean processModifiedContacts;

        public DeviceContactSync(boolean processUserDetails, boolean processModifiedContacts) {
            this.processUserDetails = processUserDetails;
            this.processModifiedContacts = processModifiedContacts;
        }

        @Override
        public void run() {
            try {
                if (this.processModifiedContacts) {
                    DeviceContactSyncService.this.processModifiedContacts();
                } else {
                    DeviceContactSyncService.this.process(this.processUserDetails);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

