/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.api.notification.NotificationService;
import com.applozic.mobicomkit.broadcast.AlEventManager;
import com.applozic.mobicomkit.broadcast.AlMessageEvent;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.Serializable;

public class BroadcastService {
    private static final String TAG = "BroadcastService";
    private static final String MOBICOMKIT_ALL = "MOBICOMKIT_ALL";
    public static String currentUserId = null;
    public static Integer parentGroupKey = null;
    public static Integer currentConversationId = null;
    public static String currentInfoId = null;
    public static boolean videoCallAcitivityOpend = false;
    public static boolean callRinging = false;
    public static int lastIndexForChats = 0;
    private static boolean contextBasedChatEnabled = false;
    public static String currentUserProfileUserId = null;

    public static void selectMobiComKitAll() {
        currentUserId = MOBICOMKIT_ALL;
    }

    public static boolean isQuick() {
        return currentUserId != null && currentUserId.equals(MOBICOMKIT_ALL);
    }

    public static boolean isChannelInfo() {
        return currentInfoId != null;
    }

    public static boolean isIndividual() {
        return currentUserId != null && !BroadcastService.isQuick();
    }

    public static synchronized boolean isContextBasedChatEnabled() {
        return contextBasedChatEnabled;
    }

    public static synchronized boolean setContextBasedChat(boolean contextBasedChat) {
        contextBasedChatEnabled = contextBasedChat;
        return contextBasedChatEnabled;
    }

    public static void sendLoadMoreBroadcast(Context context, boolean loadMore) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("LOAD_MORE").setLoadMore(loadMore));
        Utils.printLog((Context)context, (String)TAG, (String)("Sending " + INTENT_ACTIONS.LOAD_MORE.toString() + " broadcast"));
        Intent intent = new Intent();
        intent.setAction(INTENT_ACTIONS.LOAD_MORE.toString());
        intent.addCategory("android.intent.category.DEFAULT");
        intent.putExtra("loadMore", loadMore);
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendDeliveryReportForContactBroadcast(Context context, String action, String contactId) {
        if (INTENT_ACTIONS.MESSAGE_READ_AND_DELIVERED_FOR_CONTECT.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("ALL_MESSAGES_READ").setUserId(contactId));
        } else if (INTENT_ACTIONS.MESSAGE_DELIVERY_FOR_CONTACT.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("ALL_MESSAGES_DELIVERED").setUserId(contactId));
        }
        Utils.printLog((Context)context, (String)TAG, (String)("Sending message delivery report of contact broadcast for " + action + ", " + contactId));
        Intent intentUpdate = new Intent();
        intentUpdate.setAction(action);
        intentUpdate.addCategory("android.intent.category.DEFAULT");
        intentUpdate.putExtra("contactId", contactId);
        BroadcastService.sendBroadcast(context, intentUpdate);
    }

    public static void sendMessageUpdateBroadcast(Context context, String action, Message message) {
        if (!message.isSentToMany() && !message.isTypeOutbox()) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("MESSAGE_RECEIVED").setMessage(message));
        }
        if (INTENT_ACTIONS.MESSAGE_SYNC_ACK_FROM_SERVER.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("MESSAGE_SENT").setMessage(message));
        } else if (INTENT_ACTIONS.SYNC_MESSAGE.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("MESSAGE_SYNC").setMessage(message));
        } else if (INTENT_ACTIONS.MESSAGE_DELIVERY.toString().equals(action) || INTENT_ACTIONS.MESSAGE_READ_AND_DELIVERED.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("MESSAGE_DELIVERED").setMessage(message).setUserId(message.getContactIds()));
        }
        Utils.printLog((Context)context, (String)TAG, (String)("Sending message update broadcast for " + action + ", " + message.getKeyString()));
        Intent intentUpdate = new Intent();
        intentUpdate.setAction(action);
        intentUpdate.addCategory("android.intent.category.DEFAULT");
        intentUpdate.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        BroadcastService.sendBroadcast(context, intentUpdate);
    }

    public static void sendMessageDeleteBroadcast(Context context, String action, String keyString, String contactNumbers) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("MESSAGE_DELETED").setMessageKey(keyString).setUserId(contactNumbers));
        Utils.printLog((Context)context, (String)TAG, (String)("Sending message delete broadcast for " + action));
        Intent intentDelete = new Intent();
        intentDelete.setAction(action);
        intentDelete.putExtra("keyString", keyString);
        intentDelete.putExtra("contactNumbers", contactNumbers);
        intentDelete.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intentDelete);
    }

    public static void sendConversationDeleteBroadcast(Context context, String action, String contactNumber, Integer channelKey, String response) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("CONVERSATION_DELETED").setUserId(contactNumber).setGroupId(channelKey).setResponse(response));
        Utils.printLog((Context)context, (String)TAG, (String)("Sending conversation delete broadcast for " + action));
        Intent intentDelete = new Intent();
        intentDelete.setAction(action);
        intentDelete.putExtra("channelKey", (Serializable)channelKey);
        intentDelete.putExtra("contactNumber", contactNumber);
        intentDelete.putExtra("response", response);
        intentDelete.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intentDelete);
    }

    public static void sendNotificationBroadcast(Context context, Message message, int index) {
        if (message != null) {
            if (message.getMetadata() != null && message.getMetadata().containsKey("NO_ALERT") && "true".equals(message.getMetadata().get("NO_ALERT"))) {
                return;
            }
            int notificationId = Utils.getLauncherIcon((Context)context.getApplicationContext());
            NotificationService notificationService = new NotificationService(notificationId, context, 0, 0, 0);
            if (MobiComUserPreference.getInstance(context).isLoggedIn()) {
                Channel channel = ChannelService.getInstance(context).getChannelInfo(message.getGroupId());
                Contact contact = null;
                if (message.getConversationId() != null) {
                    ConversationService.getInstance(context).getConversation(message.getConversationId());
                }
                if (message.getGroupId() == null) {
                    contact = new AppContactService(context).getContactById(message.getContactIds());
                }
                if (ApplozicClient.getInstance(context).isNotificationStacking()) {
                    notificationService.notifyUser(contact, channel, message, index);
                } else {
                    notificationService.notifyUserForNormalMessage(contact, channel, message, index);
                }
            }
        }
    }

    public static void sendUpdateLastSeenAtTimeBroadcast(Context context, String action, String contactId) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("UPDATE_LAST_SEEN").setUserId(contactId));
        Utils.printLog((Context)context, (String)TAG, (String)"Sending lastSeenAt broadcast....");
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("contactId", contactId);
        intent.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendUpdateTypingBroadcast(Context context, String action, String applicationId, String userId, String isTyping) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("UPDATE_TYPING_STATUS").setUserId(userId).setTyping(isTyping));
        Utils.printLog((Context)context, (String)TAG, (String)"Sending typing Broadcast.......");
        Intent intentTyping = new Intent();
        intentTyping.setAction(action);
        intentTyping.putExtra("applicationId", applicationId);
        intentTyping.putExtra("userId", userId);
        intentTyping.putExtra("isTyping", isTyping);
        intentTyping.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intentTyping);
    }

    public static void sendUpdate(Context context, boolean isMetadataUpdate, String action) {
        if (INTENT_ACTIONS.MQTT_CONNECTED.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("MQTT_CONNECTED"));
        } else if (INTENT_ACTIONS.MQTT_DISCONNECTED.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("MQTT_DISCONNECTED"));
        } else if (INTENT_ACTIONS.USER_ONLINE.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("USER_ONLINE"));
        } else if (INTENT_ACTIONS.USER_OFFLINE.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("USER_OFFLINE"));
        } else if (INTENT_ACTIONS.CHANNEL_SYNC.toString().equals(action)) {
            BroadcastService.postEventData(context, new AlMessageEvent().setAction("CHANNEL_UPDATED"));
        }
        Utils.printLog((Context)context, (String)TAG, (String)action);
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("isMetadataUpdate", isMetadataUpdate);
        intent.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendUpdate(Context context, String action) {
        BroadcastService.sendUpdate(context, false, action);
    }

    public static void updateMessageMetadata(Context context, String messageKey, String action) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("MESSAGE_METADATA_UPDATED").setMessageKey(messageKey));
        Utils.printLog((Context)context, (String)TAG, (String)("Sending Message Metadata Update Broadcast for message key : " + messageKey));
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("keyString", messageKey);
        intent.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendConversationReadBroadcast(Context context, String action, String currentId, boolean isGroup) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("CONVERSATION_READ").setUserId(currentId).setGroup(isGroup));
        Utils.printLog((Context)context, (String)TAG, (String)"Sending  Broadcast for conversation read ......");
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("currentId", currentId);
        intent.putExtra("isGroup", isGroup);
        intent.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendMuteUserBroadcast(Context context, String action, boolean mute, String userId) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("ON_USER_MUTE").setUserId(userId).setLoadMore(mute));
        Utils.printLog((Context)context, (String)TAG, (String)("Sending Mute user Broadcast for user : " + userId + ", mute : " + mute));
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("mute", mute);
        intent.putExtra("userId", userId);
        intent.addCategory("android.intent.category.DEFAULT");
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendUpdateUserDetailBroadcast(Context context, String action, String contactId) {
        BroadcastService.postEventData(context, new AlMessageEvent().setAction("USER_DETAILS_UPDATED").setUserId(contactId));
        Utils.printLog((Context)context, (String)TAG, (String)"Sending profileImage update....");
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("contactId", contactId);
        BroadcastService.sendBroadcast(context, intent);
    }

    public static void sendUpdateGroupInfoBroadcast(Context context, String action) {
        Intent intent = new Intent();
        intent.setAction(action);
        BroadcastService.sendBroadcast(context, intent);
    }

    public static IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(INTENT_ACTIONS.FIRST_TIME_SYNC_COMPLETE.toString());
        intentFilter.addAction(INTENT_ACTIONS.LOAD_MORE.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_SYNC_ACK_FROM_SERVER.toString());
        intentFilter.addAction(INTENT_ACTIONS.SYNC_MESSAGE.toString());
        intentFilter.addAction(INTENT_ACTIONS.DELETE_MESSAGE.toString());
        intentFilter.addAction(INTENT_ACTIONS.DELETE_CONVERSATION.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_DELIVERY.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_DELIVERY_FOR_CONTACT.toString());
        intentFilter.addAction(INTENT_ACTIONS.UPLOAD_ATTACHMENT_FAILED.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_ATTACHMENT_DOWNLOAD_DONE.toString());
        intentFilter.addAction(INTENT_ACTIONS.INSTRUCTION.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_ATTACHMENT_DOWNLOAD_FAILD.toString());
        intentFilter.addAction(INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString());
        intentFilter.addAction(INTENT_ACTIONS.UPDATE_TYPING_STATUS.toString());
        intentFilter.addAction(INTENT_ACTIONS.MQTT_DISCONNECTED.toString());
        intentFilter.addAction(INTENT_ACTIONS.UPDATE_CHANNEL_NAME.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_READ_AND_DELIVERED.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_READ_AND_DELIVERED_FOR_CONTECT.toString());
        intentFilter.addAction(INTENT_ACTIONS.CHANNEL_SYNC.toString());
        intentFilter.addAction(INTENT_ACTIONS.UPDATE_TITLE_SUBTITLE.toString());
        intentFilter.addAction(INTENT_ACTIONS.CONVERSATION_READ.toString());
        intentFilter.addAction(INTENT_ACTIONS.UPDATE_USER_DETAIL.toString());
        intentFilter.addAction(INTENT_ACTIONS.MESSAGE_METADATA_UPDATE.toString());
        intentFilter.addAction(INTENT_ACTIONS.MUTE_USER_CHAT.toString());
        intentFilter.addAction(INTENT_ACTIONS.MQTT_CONNECTED.toString());
        intentFilter.addAction(INTENT_ACTIONS.USER_ONLINE.toString());
        intentFilter.addAction(INTENT_ACTIONS.USER_OFFLINE.toString());
        intentFilter.addCategory("android.intent.category.DEFAULT");
        return intentFilter;
    }

    public static void sendBroadcast(Context context, Intent intent) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    private static void postEventData(Context context, AlMessageEvent messageEvent) {
        AlEventManager.getInstance().postEventData(messageEvent);
    }

    public static enum INTENT_ACTIONS {
        LOAD_MORE,
        FIRST_TIME_SYNC_COMPLETE,
        MESSAGE_SYNC_ACK_FROM_SERVER,
        SYNC_MESSAGE,
        DELETE_MESSAGE,
        DELETE_CONVERSATION,
        MESSAGE_DELIVERY,
        MESSAGE_DELIVERY_FOR_CONTACT,
        INSTRUCTION,
        UPDATE_GROUP_INFO,
        UPLOAD_ATTACHMENT_FAILED,
        MESSAGE_ATTACHMENT_DOWNLOAD_DONE,
        MESSAGE_ATTACHMENT_DOWNLOAD_FAILD,
        UPDATE_LAST_SEEN_AT_TIME,
        UPDATE_TYPING_STATUS,
        MESSAGE_READ_AND_DELIVERED,
        MESSAGE_READ_AND_DELIVERED_FOR_CONTECT,
        CHANNEL_SYNC,
        CONTACT_VERIFIED,
        NOTIFY_USER,
        MQTT_DISCONNECTED,
        UPDATE_CHANNEL_NAME,
        UPDATE_TITLE_SUBTITLE,
        CONVERSATION_READ,
        UPDATE_USER_DETAIL,
        MESSAGE_METADATA_UPDATE,
        MUTE_USER_CHAT,
        MQTT_CONNECTED,
        USER_ONLINE,
        USER_OFFLINE;

    }
}

