/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit;

import android.content.Context;
import android.content.SharedPreferences;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ApplozicClient {
    public static final String AL_MESSAGE_META_DATA_KEY = "AL_MESSAGE_META_DATA_KEY";
    private static final String HANDLE_DISPLAY_NAME = "CLIENT_HANDLE_DISPLAY_NAME";
    private static final String HANDLE_DIAL = "CLIENT_HANDLE_DIAL";
    private static final String CHAT_LIST_HIDE_ON_NOTIFICATION = "CHAT_LIST_HIDE_ON_NOTIFICATION";
    private static final String CONTEXT_BASED_CHAT = "CONTEXT_BASED_CHAT";
    private static final String NOTIFICATION_SMALL_ICON = "NOTIFICATION_SMALL_ICON";
    private static final String APP_NAME = "APP_NAME";
    private static final String APPLICATION_KEY = "APPLICATION_KEY";
    private static final String NOTIFICATION_DISABLE = "NOTIFICATION_DISABLE";
    private static final String CONTACT_DEFAULT_IMAGE = "CONTACT_DEFAULT_IMAGE";
    private static final String GROUP_DEFAULT_IMAGE = "GROUP_DEFAULT_IMAGE";
    private static final String MESSAGE_META_DATA_SERVICE = "MESSAGE_META_DATA_SERVICE";
    private static final String ENABLE_IP_CALL = "ENABLE_IP_CALL";
    private static final String SHOW_MY_CONTACT_ONLY = "SHOW_MY_CONTACT_ONLY";
    private static final String START_GROUP_OF_TWO = "START_GROUP_OF_TWO";
    private static final String AL_SHOW_APP_ICON = "AL_SHOW_APP_ICON";
    private static String NOTIFICATION_STACKING = "NOTIFICATION_STACKING";
    private static final String BADGE_COUNT_ENABLE = "BADGE_COUNT_ENABLE";
    private static String vibration_notification = "vibration_notification";
    private static final String S3_STORAGE_SERVICE_ENABLED = "S3_STORAGE_SERVICE_ENABLED";
    private static final String STORAGE_SERVICE_ENABLE = "STORAGE_SERVICE_ENABLE";
    private static final String GOOGLE_CLOUD_SERVICE_ENABLE = "GOOGLE_CLOUD_SERVICE_ENABLE";
    private static final String CUSTOM_MESSAGE_TEMPLATE = "CUSTOM_MESSAGE_TEMPLATE";
    private static final String AL_SUBGROUP_SUPPORT = "AL_SUBGROUP_SUPPORT";
    private static final String HIDE_ACTION_MESSAGES = "HIDE_ACTION_MESSAGES";
    private static final String NOTIFICATION_MUTE_THRESHOLD = "NOTIFICATION_MUTE_THRESHOLD";
    private static final String SKIP_DELETED_GROUPS = "SKIP_DELETED_GROUPS";
    public static ApplozicClient applozicClient;
    public SharedPreferences sharedPreferences;
    private Context context;

    private ApplozicClient(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.sharedPreferences = ApplozicService.getContext((Context)context).getSharedPreferences(MobiComKitClientService.getApplicationKey(ApplozicService.getContext((Context)context)), 0);
    }

    public static ApplozicClient getInstance(Context context) {
        if (applozicClient == null) {
            applozicClient = new ApplozicClient(ApplozicService.getContext((Context)context));
        }
        return applozicClient;
    }

    public boolean isHandleDisplayName() {
        return this.sharedPreferences.getBoolean(HANDLE_DISPLAY_NAME, true);
    }

    public ApplozicClient setHandleDisplayName(boolean enable) {
        this.sharedPreferences.edit().putBoolean(HANDLE_DISPLAY_NAME, enable).commit();
        return this;
    }

    public boolean isHandleDial() {
        return this.sharedPreferences.getBoolean(HANDLE_DIAL, false);
    }

    public ApplozicClient setHandleDial(boolean enable) {
        this.sharedPreferences.edit().putBoolean(HANDLE_DIAL, enable).commit();
        return this;
    }

    public ApplozicClient hideChatListOnNotification() {
        this.sharedPreferences.edit().putBoolean(CHAT_LIST_HIDE_ON_NOTIFICATION, true).commit();
        return this;
    }

    public boolean isChatListOnNotificationIsHidden() {
        return this.sharedPreferences.getBoolean(CHAT_LIST_HIDE_ON_NOTIFICATION, false);
    }

    public boolean isContextBasedChat() {
        return this.sharedPreferences.getBoolean(CONTEXT_BASED_CHAT, false);
    }

    public ApplozicClient setContextBasedChat(boolean enable) {
        this.sharedPreferences.edit().putBoolean(CONTEXT_BASED_CHAT, enable).commit();
        return this;
    }

    public ApplozicClient hideNotificationSmallIcon() {
        this.sharedPreferences.edit().putBoolean(NOTIFICATION_SMALL_ICON, true).commit();
        return this;
    }

    public boolean isNotificationSmallIconHidden() {
        return this.sharedPreferences.getBoolean(NOTIFICATION_SMALL_ICON, false);
    }

    public boolean isNotAllowed() {
        MobiComUserPreference pref = MobiComUserPreference.getInstance(this.context);
        boolean isDebuggable = 0 != (this.context.getApplicationInfo().flags & 2);
        return !isDebuggable && (pref.getPricingPackage() == RegistrationResponse.PricingType.CLOSED.getValue().shortValue() || pref.getPricingPackage() == RegistrationResponse.PricingType.BETA.getValue().shortValue());
    }

    public boolean isServiceDisconnected() {
        int pricingPackage = MobiComUserPreference.getInstance(this.context).getPricingPackage();
        return pricingPackage == -1 || pricingPackage == 6 || pricingPackage == 0 && !Utils.isDebugBuild((Context)this.context);
    }

    public boolean isAccountClosed() {
        return MobiComUserPreference.getInstance(this.context).getPricingPackage() == RegistrationResponse.PricingType.CLOSED.getValue().shortValue();
    }

    public String getAppName() {
        return this.sharedPreferences.getString(APP_NAME, "Applozic");
    }

    public ApplozicClient setAppName(String notficationAppName) {
        this.sharedPreferences.edit().putString(APP_NAME, notficationAppName).commit();
        return this;
    }

    public String getApplicationKey() {
        return this.sharedPreferences.getString(APPLICATION_KEY, null);
    }

    public ApplozicClient setApplicationKey(String applicationKey) {
        this.sharedPreferences.edit().putString(APPLICATION_KEY, applicationKey).commit();
        return this;
    }

    public boolean isNotificationDisabled() {
        return this.sharedPreferences.getBoolean(NOTIFICATION_DISABLE, false);
    }

    public ApplozicClient enableNotification() {
        this.sharedPreferences.edit().putBoolean(NOTIFICATION_DISABLE, false).commit();
        return this;
    }

    public ApplozicClient disableNotification() {
        this.sharedPreferences.edit().putBoolean(NOTIFICATION_DISABLE, true).commit();
        return this;
    }

    public String getDefaultContactImage() {
        return this.sharedPreferences.getString(CONTACT_DEFAULT_IMAGE, "applozic_ic_contact_picture_holo_light");
    }

    public ApplozicClient setDefaultContactImage(String imageName) {
        this.sharedPreferences.edit().putString(CONTACT_DEFAULT_IMAGE, imageName).commit();
        return this;
    }

    public String getDefaultChannelImage() {
        return this.sharedPreferences.getString(GROUP_DEFAULT_IMAGE, "applozic_group_icon");
    }

    public ApplozicClient setDefaultChannelImage(String groupImageName) {
        this.sharedPreferences.edit().putString(GROUP_DEFAULT_IMAGE, groupImageName).commit();
        return this;
    }

    public String getMessageMetaDataServiceName() {
        return this.sharedPreferences.getString(MESSAGE_META_DATA_SERVICE, null);
    }

    public ApplozicClient setMessageMetaDataServiceName(String messageMetaDataServiceName) {
        this.sharedPreferences.edit().putString(MESSAGE_META_DATA_SERVICE, messageMetaDataServiceName).commit();
        return this;
    }

    public boolean isShowMyContacts() {
        return this.sharedPreferences.getBoolean(SHOW_MY_CONTACT_ONLY, false);
    }

    public ApplozicClient enableShowMyContacts() {
        this.sharedPreferences.edit().putBoolean(SHOW_MY_CONTACT_ONLY, true).commit();
        return this;
    }

    public ApplozicClient disableShowMyContacts() {
        this.sharedPreferences.edit().putBoolean(SHOW_MY_CONTACT_ONLY, false).commit();
        return this;
    }

    public boolean isIPCallEnabled() {
        return this.sharedPreferences.getBoolean(ENABLE_IP_CALL, false);
    }

    public void setIPCallEnabled(boolean iPCallEnabled) {
        this.sharedPreferences.edit().putBoolean(ENABLE_IP_CALL, iPCallEnabled).commit();
    }

    public String getMessageMetaData() {
        return this.sharedPreferences.getString(AL_MESSAGE_META_DATA_KEY, null);
    }

    public ApplozicClient setMessageMetaData(Map<String, String> messageMetaDataMap) {
        if (messageMetaDataMap != null) {
            this.sharedPreferences.edit().putString(AL_MESSAGE_META_DATA_KEY, new JSONObject(messageMetaDataMap).toString()).commit();
        }
        return this;
    }

    public ApplozicClient startGroupOfTwo() {
        this.sharedPreferences.edit().putBoolean(START_GROUP_OF_TWO, true).commit();
        return this;
    }

    public boolean isStartGroupOfTwo() {
        return this.sharedPreferences.getBoolean(START_GROUP_OF_TWO, false);
    }

    public ApplozicClient disableStartGroupOfTwo() {
        this.sharedPreferences.edit().putBoolean(START_GROUP_OF_TWO, false).commit();
        return this;
    }

    public ApplozicClient showAppIconInNotification(boolean showOrHide) {
        this.sharedPreferences.edit().putBoolean(AL_SHOW_APP_ICON, showOrHide).commit();
        return this;
    }

    public boolean isShowAppIconInNotification() {
        return this.sharedPreferences.getBoolean(AL_SHOW_APP_ICON, false);
    }

    public boolean isNotificationStacking() {
        return this.sharedPreferences.getBoolean(NOTIFICATION_STACKING, false);
    }

    public void setNotificationStacking(boolean enableOrDisable) {
        this.sharedPreferences.edit().putBoolean(NOTIFICATION_STACKING, enableOrDisable).commit();
    }

    public ApplozicClient enableShowUnreadCountBadge() {
        this.sharedPreferences.edit().putBoolean(BADGE_COUNT_ENABLE, true).commit();
        return this;
    }

    public boolean isUnreadCountBadgeEnabled() {
        return this.sharedPreferences.getBoolean(BADGE_COUNT_ENABLE, false);
    }

    public boolean getVibrationOnNotification() {
        return this.sharedPreferences.getBoolean(vibration_notification, false);
    }

    public void setVibrationOnNotification(boolean enable) {
        this.sharedPreferences.edit().putBoolean(vibration_notification, enable).commit();
    }

    public ApplozicClient enableS3StorageService() {
        this.sharedPreferences.edit().putBoolean(S3_STORAGE_SERVICE_ENABLED, true).commit();
        return this;
    }

    public boolean isS3StorageServiceEnabled() {
        return this.sharedPreferences.getBoolean(S3_STORAGE_SERVICE_ENABLED, false);
    }

    public ApplozicClient enableGoogleCloudService() {
        this.sharedPreferences.edit().putBoolean(GOOGLE_CLOUD_SERVICE_ENABLE, true).commit();
        return this;
    }

    public boolean isGoogleCloudServiceEnabled() {
        return this.sharedPreferences.getBoolean(GOOGLE_CLOUD_SERVICE_ENABLE, false);
    }

    public ApplozicClient setStorageServiceEnabled(boolean enable) {
        this.sharedPreferences.edit().putBoolean(STORAGE_SERVICE_ENABLE, enable).commit();
        return this;
    }

    public boolean isStorageServiceEnabled() {
        return this.sharedPreferences.getBoolean(STORAGE_SERVICE_ENABLE, false);
    }

    public Map<String, String> getMessageTemplates() {
        return (Map)GsonUtils.getObjectFromJson((String)this.sharedPreferences.getString(CUSTOM_MESSAGE_TEMPLATE, null), Map.class);
    }

    public ApplozicClient setMessageTemplates(Map<String, String> messageTemplates) {
        this.sharedPreferences.edit().putString(CUSTOM_MESSAGE_TEMPLATE, GsonUtils.getJsonFromObject(messageTemplates, Map.class)).commit();
        return this;
    }

    public boolean isSubGroupEnabled() {
        return this.sharedPreferences.getBoolean(AL_SUBGROUP_SUPPORT, false);
    }

    public ApplozicClient setSubGroupSupport(boolean subgroup) {
        this.sharedPreferences.edit().putBoolean(AL_SUBGROUP_SUPPORT, subgroup).commit();
        return this;
    }

    public boolean isActionMessagesHidden() {
        return this.sharedPreferences.getBoolean(HIDE_ACTION_MESSAGES, false);
    }

    public ApplozicClient hideActionMessages(boolean hide) {
        this.sharedPreferences.edit().putBoolean(HIDE_ACTION_MESSAGES, hide).commit();
        return this;
    }

    public ApplozicClient setNotificationMuteThreashold(int threshold) {
        this.sharedPreferences.edit().putInt(NOTIFICATION_MUTE_THRESHOLD, threshold).commit();
        return this;
    }

    public int getNotificationMuteThreshold() {
        return this.sharedPreferences.getInt(NOTIFICATION_MUTE_THRESHOLD, 0);
    }

    public ApplozicClient skipDeletedGroups(boolean skip) {
        this.sharedPreferences.edit().putBoolean(SKIP_DELETED_GROUPS, skip).commit();
        return this;
    }

    public boolean isSkipDeletedGroups() {
        return this.sharedPreferences.getBoolean(SKIP_DELETED_GROUPS, false);
    }

    public ApplozicClient disableChatForUser(final boolean disable, final AlCallback callback) {
        Map<String, String> userMetadata;
        Contact contact = new AppContactService(this.context).getContactById(MobiComUserPreference.getInstance(this.context).getUserId());
        if (contact != null && contact.getMetadata() != null) {
            userMetadata = contact.getMetadata();
            userMetadata.putAll(contact.getMetadata());
        } else {
            userMetadata = new HashMap<String, String>();
        }
        userMetadata.put("DISABLE_CHAT_WITH_USER", String.valueOf(disable));
        User user = new User();
        user.setMetadata(userMetadata);
        UserService.getInstance(this.context).updateUser(user, new AlCallback(){

            @Override
            public void onSuccess(Object response) {
                ApplozicClient.this.sharedPreferences.edit().putBoolean("DISABLE_CHAT_WITH_USER", disable).commit();
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }

            @Override
            public void onError(Object error) {
                if (callback != null) {
                    callback.onError(error);
                }
            }
        });
        return this;
    }

    public ApplozicClient setChatDisabled(boolean disable) {
        this.sharedPreferences.edit().putBoolean("DISABLE_CHAT_WITH_USER", disable).commit();
        return this;
    }

    public boolean isChatForUserDisabled() {
        return this.sharedPreferences.getBoolean("DISABLE_CHAT_WITH_USER", false);
    }
}

