/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.people.AlGetPeopleTask;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.listners.AlContactListener;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;
import java.util.Date;
import java.util.List;

public class AppContactService
implements BaseContactService {
    private static final String TAG = "AppContactService";
    ContactDatabase contactDatabase;
    Context context;
    FileClientService fileClientService;

    public AppContactService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.contactDatabase = new ContactDatabase(context);
        this.fileClientService = new FileClientService(context);
    }

    @Override
    public void add(Contact contact) {
        this.contactDatabase.addContact(contact);
    }

    @Override
    public void addAll(List<Contact> contactList) {
        for (Contact contact : contactList) {
            this.upsert(contact);
        }
    }

    @Override
    public void deleteContact(Contact contact) {
        this.contactDatabase.deleteContact(contact);
    }

    @Override
    public void deleteContactById(String contactId) {
        this.contactDatabase.deleteContactById(contactId);
    }

    @Override
    public List<Contact> getAll() {
        return this.contactDatabase.getAllContact();
    }

    @Override
    public Contact getContactById(String contactId) {
        Contact contact = this.contactDatabase.getContactById(contactId);
        if (contact != null) {
            contact.processContactNumbers(this.context);
        } else {
            contact = new Contact(this.context, contactId);
            this.upsert(contact);
        }
        return contact;
    }

    @Override
    public void updateContact(Contact contact) {
        if (Applozic.getInstance(this.context).isDeviceContactSync()) {
            contact.processContactNumbers(this.context);
        }
        this.contactDatabase.updateContact(contact);
    }

    @Override
    public void upsert(Contact contact) {
        if (Applozic.getInstance(this.context).isDeviceContactSync()) {
            contact.processContactNumbers(this.context);
            if (contact.getDeviceContactType() == null || TextUtils.isEmpty((CharSequence)contact.getFormattedContactNumber())) {
                if (this.contactDatabase.getContactById(contact.getUserId()) == null) {
                    this.contactDatabase.addContact(contact);
                } else {
                    this.contactDatabase.updateContact(contact);
                }
            } else if (this.contactDatabase.getContactByPhoneNo(contact.getFormattedContactNumber()) != null) {
                this.contactDatabase.updateContactByPhoneNumber(contact);
            } else if (this.contactDatabase.getContactById(contact.getUserId()) == null) {
                this.contactDatabase.addContact(contact);
            } else {
                this.contactDatabase.updateContact(contact);
            }
        } else if (this.contactDatabase.getContactById(contact.getUserId()) == null) {
            this.contactDatabase.addContact(contact);
        } else {
            this.contactDatabase.updateContact(contact);
        }
    }

    @Override
    public List<Contact> getContacts(Contact.ContactType contactType) {
        return this.contactDatabase.getContacts(contactType);
    }

    @Override
    public List<Contact> getAllContactListExcludingLoggedInUser() {
        return this.contactDatabase.getAllContactListExcludingLoggedInUser();
    }

    @Override
    public Bitmap downloadContactImage(Context context, Contact contact) {
        if (contact != null && TextUtils.isEmpty((CharSequence)contact.getImageURL())) {
            return null;
        }
        Bitmap attachedImage = ImageUtils.getBitMapFromLocalPath((String)contact.getLocalImageUrl());
        if (attachedImage != null) {
            return attachedImage;
        }
        Bitmap bitmap = this.fileClientService.downloadBitmap(contact, null);
        if (bitmap != null) {
            File file = FileClientService.getFilePath(contact.getContactIds(), context.getApplicationContext(), "image", true);
            String imageLocalPath = ImageUtils.saveImageToInternalStorage((File)file, (Bitmap)bitmap);
            contact.setLocalImageUrl(imageLocalPath);
        }
        if (!TextUtils.isEmpty((CharSequence)contact.getLocalImageUrl())) {
            this.updateLocalImageUri(contact);
        }
        return bitmap;
    }

    @Override
    public Bitmap downloadGroupImage(Context context, Channel channel) {
        if (channel != null && TextUtils.isEmpty((CharSequence)channel.getImageUrl())) {
            return null;
        }
        Bitmap attachedImage = ImageUtils.getBitMapFromLocalPath((String)channel.getLocalImageUri());
        if (attachedImage != null) {
            return attachedImage;
        }
        Bitmap bitmap = this.fileClientService.downloadBitmap(null, channel);
        if (bitmap != null) {
            File file = FileClientService.getFilePath(String.valueOf(channel.getKey()), context.getApplicationContext(), "image", true);
            String imageLocalPath = ImageUtils.saveImageToInternalStorage((File)file, (Bitmap)bitmap);
            channel.setLocalImageUri(imageLocalPath);
        }
        if (!TextUtils.isEmpty((CharSequence)channel.getLocalImageUri())) {
            ChannelService.getInstance(context).updateChannelLocalImageURI(channel.getKey(), channel.getLocalImageUri());
        }
        return bitmap;
    }

    @Override
    public Contact getContactReceiver(List<String> items, List<String> userIds) {
        if (userIds != null && !userIds.isEmpty()) {
            return this.getContactById(userIds.get(0));
        }
        if (items != null && !items.isEmpty()) {
            return this.getContactById(items.get(0));
        }
        return null;
    }

    @Override
    public boolean isContactExists(String contactId) {
        return this.contactDatabase.getContactById(contactId) != null;
    }

    @Override
    public void updateConnectedStatus(String contactId, Date date, boolean connected) {
        Contact contact = this.contactDatabase.getContactById(contactId);
        if (contact != null && contact.isConnected() != connected) {
            this.contactDatabase.updateConnectedOrDisconnectedStatus(contactId, date, connected);
            BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), contactId);
        }
    }

    @Override
    public void updateUserBlocked(String userId, boolean userBlocked) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            this.contactDatabase.updateUserBlockStatus(userId, userBlocked);
            BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), userId);
        }
    }

    @Override
    public void updateUserBlockedBy(String userId, boolean userBlockedBy) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            this.contactDatabase.updateUserBlockByStatus(userId, userBlockedBy);
            BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), userId);
        }
    }

    @Override
    public boolean isContactPresent(String userId) {
        return this.contactDatabase.isContactPresent(userId);
    }

    @Override
    public int getChatConversationCount() {
        return this.contactDatabase.getChatUnreadCount();
    }

    @Override
    public int getGroupConversationCount() {
        return this.contactDatabase.getGroupUnreadCount();
    }

    @Override
    public void updateLocalImageUri(Contact contact) {
        this.contactDatabase.updateLocalImageUri(contact);
    }

    public void getContactByIdAsync(String userId, AlContactListener contactListener) {
        new AlGetPeopleTask(this.context, userId, null, null, null, contactListener, this, null).execute(new Void[0]);
    }
}

