/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.listners.MessageListHandler;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MessageListTask
extends AsyncTask<Void, Void, List<Message>> {
    private WeakReference<Context> context;
    private Contact contact;
    private Channel channel;
    private Long startTime;
    private Long endTime;
    private MessageListHandler handler;
    private boolean isForMessageList;
    private ApplozicException exception;
    private String searchString;

    public MessageListTask(Context context, String searchString, Contact contact, Channel channel, Long startTime, Long endTime, MessageListHandler handler, boolean isForMessageList) {
        this.context = new WeakReference<Context>(context);
        this.contact = contact;
        this.channel = channel;
        this.startTime = startTime;
        this.endTime = endTime;
        this.handler = handler;
        this.isForMessageList = isForMessageList;
        this.searchString = searchString;
    }

    protected List<Message> doInBackground(Void ... voids) {
        List<Message> messageList = null;
        try {
            messageList = this.isForMessageList ? new MobiComConversationService((Context)this.context.get()).getLatestMessagesGroupByPeople(this.startTime, TextUtils.isEmpty((CharSequence)this.searchString) ? null : this.searchString) : new MobiComConversationService((Context)this.context.get()).getMessages(this.startTime, this.endTime, this.contact, this.channel, null);
            if (messageList == null && this.exception == null) {
                this.exception = new ApplozicException("Some internal error occurred");
            }
            if (this.isForMessageList) {
                ArrayList<String> recList = new ArrayList<String>();
                ArrayList<Message> messages = new ArrayList<Message>();
                if (messageList != null) {
                    for (Message message : messageList) {
                        if (!(message.getGroupId() != null && message.getGroupId() != 0 || recList.contains(message.getContactIds()))) {
                            recList.add(message.getContactIds());
                            messages.add(message);
                            continue;
                        }
                        if (message.getGroupId() == null || recList.contains("group" + message.getGroupId())) continue;
                        recList.add("group" + message.getGroupId());
                        messages.add(message);
                    }
                    if (!messageList.isEmpty()) {
                        MobiComUserPreference.getInstance((Context)this.context.get()).setStartTimeForPagination(messageList.get(messageList.size() - 1).getCreatedAtTime());
                    }
                    return messages;
                }
            } else {
                ArrayList<Message> mergedList = new ArrayList<Message>();
                if (messageList != null && !messageList.isEmpty()) {
                    mergedList.add(this.getDateMessage(messageList.get(0)));
                    for (int i = 0; i < messageList.size(); ++i) {
                        Message message;
                        if (i == 0) {
                            mergedList.add(messageList.get(0));
                            continue;
                        }
                        long dayDifference = DateUtils.daysBetween((Date)new Date(messageList.get(i - 1).getCreatedAtTime()), (Date)new Date(messageList.get(i).getCreatedAtTime()));
                        if (dayDifference >= 1L && !mergedList.contains((Object)(message = this.getDateMessage(messageList.get(i))))) {
                            mergedList.add(message);
                        }
                        if (mergedList.contains((Object)messageList.get(i))) continue;
                        mergedList.add(messageList.get(i));
                    }
                    return mergedList;
                }
            }
        }
        catch (Exception e) {
            this.exception = new ApplozicException(e.getMessage());
        }
        return messageList;
    }

    protected void onPostExecute(List<Message> messageList) {
        super.onPostExecute(messageList);
        if (this.handler != null) {
            this.handler.onResult(messageList, this.exception);
        }
    }

    private Message getDateMessage(Message message) {
        Message firstDateMessage = new Message();
        firstDateMessage.setTempDateType(Short.valueOf("100"));
        firstDateMessage.setCreatedAtTime(message.getCreatedAtTime());
        return firstDateMessage;
    }
}

