/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.core.app.AlJobIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.schedule.ScheduleMessageService;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.json.GsonUtils;
import java.util.HashMap;
import java.util.Map;

public class MessageIntentService
extends AlJobIntentService {
    private static final String TAG = "MessageIntentService";
    private MessageClientService messageClientService;
    private static Map<Long, Handler> uploadQueueMap = new HashMap<Long, Handler>();
    static final int JOB_ID = 1111;

    public static void enqueueWork(Context context, Intent work, Handler handler) {
        MessageIntentService.enqueueWork((Context)ApplozicService.getContext((Context)context), MessageIntentService.class, (int)1111, (Intent)work);
        if (work != null) {
            Message message = (Message)((Object)GsonUtils.getObjectFromJson((String)work.getStringExtra("message_json"), Message.class));
            if (uploadQueueMap != null && handler != null) {
                uploadQueueMap.put(message.getCreatedAtTime(), handler);
            }
        }
    }

    protected void onHandleWork(@NonNull Intent intent) {
        this.messageClientService = new MessageClientService((Context)this);
        Message message = (Message)((Object)GsonUtils.getObjectFromJson((String)intent.getStringExtra("message_json"), Message.class));
        try {
            Thread thread = new Thread(new MessageSender(message, uploadQueueMap.get(message.getCreatedAtTime())));
            thread.setPriority(10);
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MessageSender
    implements Runnable {
        private Message message;
        private Handler handler;

        public MessageSender(Message message, Handler handler) {
            this.message = message;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                MessageIntentService.this.messageClientService.sendMessageToServer(this.message, this.handler, ScheduleMessageService.class);
                MessageIntentService.this.messageClientService.syncPendingMessages(true);
                uploadQueueMap.remove(this.message.getCreatedAtTime());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

