/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicommons.people.contact.Contact;
import java.lang.ref.WeakReference;
import java.util.List;

public class AlUserSearchTask
extends AsyncTask<Void, Void, List<Contact>> {
    private WeakReference<Context> context;
    private String searchString;
    private Exception exception;
    private UserService userService;
    private AlUserSearchHandler listener;

    public AlUserSearchTask(Context context, String searchString, AlUserSearchHandler listener) {
        this.context = new WeakReference<Context>(context);
        this.searchString = searchString;
        this.listener = listener;
        this.userService = UserService.getInstance(context);
    }

    protected List<Contact> doInBackground(Void[] objects) {
        if (this.searchString == null) {
            this.exception = new ApplozicException("Empty search string");
            return null;
        }
        try {
            return this.userService.getUserListBySearch(this.searchString);
        }
        catch (Exception e) {
            this.exception = e;
            return null;
        }
    }

    protected void onPostExecute(List<Contact> contactList) {
        super.onPostExecute(contactList);
        if (this.listener != null) {
            if (contactList != null) {
                this.listener.onSuccess(contactList, (Context)this.context.get());
            } else {
                this.listener.onFailure(this.exception, (Context)this.context.get());
            }
        }
    }

    public static interface AlUserSearchHandler {
        public void onSuccess(List<Contact> var1, Context var2);

        public void onFailure(Exception var1, Context var2);
    }
}

