/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.register;

import android.content.Context;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.feed.SyncApiResponse;
import com.applozic.mobicommons.json.GsonUtils;

public class SyncClientService
extends MobiComKitClientService {
    private static final String TAG = "SyncClientService";
    public static final String SYNC_URL = "/rest/ws/sync/get";
    private HttpRequestUtils httpRequestUtils;

    public SyncClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getSyncUrl() {
        return this.getBaseUrl() + SYNC_URL;
    }

    public SyncApiResponse getSyncCall(Long syncTime, SyncType syncType) {
        try {
            String response = this.httpRequestUtils.getResponse(this.getSyncUrl() + "?syncTime=" + syncTime + "&syncType=" + syncType.getValue(), "application/json", "application/json");
            if (response != null) {
                Log.i((String)TAG, (String)("Sync call response: " + response));
                return (SyncApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, SyncApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum SyncType {
        MESSAGE(0),
        GROUP(1),
        CONVERSATION(2),
        CONTACT(3);

        private Integer value;

        private SyncType(Integer value) {
            this.value = value;
        }

        public Short getValue() {
            return this.value.shortValue();
        }
    }
}

