/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.contact.MobiComVCFParser;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ContactService {
    private Context context;

    public ContactService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File vCard(Uri contactData) throws Exception {
        try (Cursor cursor = null;){
            cursor = this.context.getContentResolver().query(contactData, null, null, null, null);
            cursor.moveToFirst();
            String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
            Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_VCARD_URI, (String)lookupKey);
            String name = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String imageFileName = "CONTACT_" + timeStamp + "_.vcf";
            File outputFile = FileClientService.getFilePath(imageFileName, this.context.getApplicationContext(), "text/x-vcard");
            BufferedReader br = null;
            InputStream inputStream = this.context.getContentResolver().openInputStream(uri);
            br = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] buf = sb.toString().trim().getBytes();
            if (!MobiComVCFParser.validateData(sb.toString())) {
                Utils.printLog((Context)this.context, (String)"vCard ::", (String)sb.toString().toString());
                throw new Exception("contact exported is not proper in proper format");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile.getAbsoluteFile());
            fileOutputStream.write(buf);
            fileOutputStream.close();
            if (inputStream != null) {
                inputStream.close();
            }
            File file = outputFile;
            return file;
        }
    }
}

