/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.people;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.listners.AlChannelListener;
import com.applozic.mobicomkit.listners.AlContactListener;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class AlGetPeopleTask
extends AsyncTask<Void, Object, Object> {
    private String userId;
    private String clientChannelKey;
    private Integer groupId;
    private AlChannelListener channelListener;
    private AlContactListener contactListener;
    private ContactDatabase contactDatabase;
    private ChannelDatabaseService channelDatabaseService;

    public AlGetPeopleTask(Context context, String userId, String clientChannelKey, Integer channelKey, AlChannelListener channelListener, AlContactListener contactListener, ContactDatabase contactDatabase, ChannelDatabaseService channelDatabaseService) {
        this.userId = userId;
        this.clientChannelKey = clientChannelKey;
        this.groupId = channelKey;
        this.channelListener = channelListener;
        this.contactListener = contactListener;
        this.contactDatabase = contactDatabase == null ? new ContactDatabase(context) : contactDatabase;
        this.channelDatabaseService = channelDatabaseService == null ? ChannelDatabaseService.getInstance(context) : channelDatabaseService;
    }

    protected Object doInBackground(Void ... voids) {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.userId)) {
                return this.contactDatabase.getContactById(this.userId);
            }
            if (!TextUtils.isEmpty((CharSequence)this.clientChannelKey)) {
                return this.channelDatabaseService.getChannelByClientGroupId(this.clientChannelKey);
            }
            if (this.groupId != null && this.groupId > 0) {
                return this.channelDatabaseService.getChannelByChannelKey(this.groupId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onPostExecute(Object o) {
        super.onPostExecute(o);
        if (o instanceof Contact && this.contactListener != null) {
            this.contactListener.onGetContact((Contact)o);
        }
        if (o instanceof Channel && this.channelListener != null) {
            this.channelListener.onGetChannel((Channel)o);
        }
    }
}

