/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.ApplozicIntentService;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static final String TAG = "ConnectivityReceiver";
    private static final String CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
    private static final String BOOT_COMPLETED = "android.intent.action.BOOT_COMPLETED";
    private static final String REBOOT_COMPLETED = "android.intent.action.QUICKBOOT_POWERON";
    Context context;
    private static boolean firstConnect = true;

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        this.context = context;
        String action = intent.getAction();
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent(action));
        Utils.printLog((Context)context, (String)TAG, (String)action);
        if (!MobiComUserPreference.getInstance(context).isLoggedIn()) {
            return;
        }
        if (BOOT_COMPLETED.equalsIgnoreCase(action) || REBOOT_COMPLETED.equalsIgnoreCase(action)) {
            Intent connectivityIntent = new Intent(context, ApplozicIntentService.class);
            connectivityIntent.putExtra("AL_SYNC_ON_CONNECTIVITY", true);
            ApplozicIntentService.enqueueWork(context, connectivityIntent);
        }
        if (CONNECTIVITY_CHANGE.equalsIgnoreCase(action)) {
            if (!Utils.isInternetAvailable((Context)context)) {
                firstConnect = true;
                return;
            }
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().isConnected() && firstConnect) {
                firstConnect = false;
                Intent connectivityIntent = new Intent(context, ApplozicIntentService.class);
                connectivityIntent.putExtra("AL_SYNC_ON_CONNECTIVITY", true);
                ApplozicIntentService.enqueueWork(context, connectivityIntent);
            }
        }
    }
}

