/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.schedule.ScheduleMessageService;
import com.applozic.mobicomkit.listners.MediaUploadProgressHandler;
import com.applozic.mobicommons.json.GsonUtils;
import java.util.HashMap;
import java.util.Map;

public class MessageIntentService
extends JobIntentService {
    private static final String TAG = "MessageIntentService";
    private MessageClientService messageClientService;
    private static Map<Long, MediaUploadProgressHandler> uploadQueueMap = new HashMap<Long, MediaUploadProgressHandler>();
    static final int JOB_ID = 1111;

    public static void enqueueWork(Context context, Intent work, MediaUploadProgressHandler handler) {
        MessageIntentService.enqueueWork((Context)context, MessageIntentService.class, (int)1111, (Intent)work);
        if (work != null) {
            Message message = (Message)((Object)GsonUtils.getObjectFromJson((String)work.getStringExtra("message_json"), Message.class));
            if (uploadQueueMap != null && message.isUploadRequired()) {
                uploadQueueMap.put(message.getCreatedAtTime(), handler);
            }
        }
    }

    protected void onHandleWork(@NonNull Intent intent) {
        this.messageClientService = new MessageClientService((Context)this);
        Message message = (Message)((Object)GsonUtils.getObjectFromJson((String)intent.getStringExtra("message_json"), Message.class));
        Thread thread = new Thread(new MessageSender(message, uploadQueueMap.get(message.getCreatedAtTime())));
        thread.start();
    }

    private class MessageSender
    implements Runnable {
        private Message message;
        private MediaUploadProgressHandler handler;

        public MessageSender(Message message, MediaUploadProgressHandler handler) {
            this.message = message;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                MessageIntentService.this.messageClientService.sendMessageToServer(this.message, this.handler, ScheduleMessageService.class);
                MessageIntentService.this.messageClientService.syncPendingMessages(true);
                uploadQueueMap.remove(this.message.getCreatedAtTime());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

