/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageInfoResponse;
import com.applozic.mobicomkit.api.conversation.MessageMetadataUpdate;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.schedule.ScheduledMessageUtil;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.MessageResponse;
import com.applozic.mobicomkit.listners.MediaUploadProgressHandler;
import com.applozic.mobicomkit.sync.SmsSyncRequest;
import com.applozic.mobicomkit.sync.SyncMessageFeed;
import com.applozic.mobicomkit.sync.SyncUserDetailsResponse;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MessageClientService
extends MobiComKitClientService {
    public static final int SMS_SYNC_BATCH_SIZE = 5;
    public static final String DEVICE_KEY = "deviceKey";
    public static final String LAST_SYNC_KEY = "lastSyncTime";
    public static final String REGISTRATION_ID = "registrationId";
    private static final String MESSAGE_METADATA_UPDATE = "metadataUpdate";
    public static final String FILE_META = "fileMeta";
    public static final String MTEXT_DELIVERY_URL = "/rest/ws/message/delivered";
    public static final String SERVER_SYNC_URL = "/rest/ws/message/sync";
    public static final String SEND_MESSAGE_URL = "/rest/ws/message/send";
    public static final String SYNC_SMS_URL = "/rest/ws/sms/add/batch";
    public static final String MESSAGE_LIST_URL = "/rest/ws/message/list";
    public static final String MESSAGE_DELETE_URL = "/rest/ws/message/delete";
    public static final String UPDATE_DELIVERY_FLAG_URL = "/rest/ws/sms/update/delivered";
    public static final String UPDATE_READ_STATUS_URL = "/rest/ws/message/read/conversation";
    public static final String MESSAGE_THREAD_DELETE_URL = "/rest/ws/message/delete/conversation";
    public static final String USER_DETAILS_URL = "/rest/ws/user/detail";
    public static final String USER_DETAILS_LIST_URL = "/rest/ws/user/status";
    public static final String PRODUCT_CONVERSATION_ID_URL = "/rest/ws/conversation/id";
    public static final String PRODUCT_TOPIC_ID_URL = "/rest/ws/conversation/topicId";
    public static final String ARGUMRNT_SAPERATOR = "&";
    public static final String UPDATE_READ_STATUS_FOR_SINGLE_MESSAGE_URL = "/rest/ws/message/read";
    public static final String MESSAGE_INFO_URL = "/rest/ws/message/info";
    public static final String MESSAGE_BY_MESSAGE_KEYS_URL = "/rest/ws/message/detail";
    private static final String UPDATE_MESSAGE_METADATA_URL = "/rest/ws/message/update/metadata";
    private static final String TAG = "MessageClientService";
    private Context context;
    private MessageDatabaseService messageDatabaseService;
    private HttpRequestUtils httpRequestUtils;
    private BaseContactService baseContactService;

    public MessageClientService(Context context) {
        super(context);
        this.context = context.getApplicationContext();
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
        this.baseContactService = new AppContactService(context);
    }

    public String getMtextDeliveryUrl() {
        return this.getBaseUrl() + MTEXT_DELIVERY_URL;
    }

    public String getServerSyncUrl() {
        return this.getBaseUrl() + SERVER_SYNC_URL;
    }

    public String getSendMessageUrl() {
        return this.getBaseUrl() + SEND_MESSAGE_URL;
    }

    public String getSyncSmsUrl() {
        return this.getBaseUrl() + SYNC_SMS_URL;
    }

    public String getMessageListUrl() {
        return this.getBaseUrl() + MESSAGE_LIST_URL;
    }

    public String getMessageDeleteUrl() {
        return this.getBaseUrl() + MESSAGE_DELETE_URL;
    }

    public String getUpdateDeliveryFlagUrl() {
        return this.getBaseUrl() + UPDATE_DELIVERY_FLAG_URL;
    }

    public String getMessageThreadDeleteUrl() {
        return this.getBaseUrl() + MESSAGE_THREAD_DELETE_URL;
    }

    public String getUpdateReadStatusUrl() {
        return this.getBaseUrl() + UPDATE_READ_STATUS_URL;
    }

    public String getUserDetailUrl() {
        return this.getBaseUrl() + USER_DETAILS_URL;
    }

    public String getUserDetailsListUrl() {
        return this.getBaseUrl() + USER_DETAILS_LIST_URL;
    }

    public String getProductConversationUrl() {
        return this.getBaseUrl() + PRODUCT_CONVERSATION_ID_URL;
    }

    public String getProductTopicIdUrl() {
        return this.getBaseUrl() + PRODUCT_TOPIC_ID_URL;
    }

    public String getMessageInfoUrl() {
        return this.getBaseUrl() + MESSAGE_INFO_URL;
    }

    public String getSingleMessageReadUrl() {
        return this.getBaseUrl() + UPDATE_READ_STATUS_FOR_SINGLE_MESSAGE_URL;
    }

    public String getMessageByMessageKeysUrl() {
        return this.getBaseUrl() + MESSAGE_BY_MESSAGE_KEYS_URL;
    }

    public void updateDeliveryStatus(String messageKeyString, String userId, String receiverNumber) {
        try {
            if (TextUtils.isEmpty((CharSequence)messageKeyString) || TextUtils.isEmpty((CharSequence)userId)) {
                return;
            }
            this.httpRequestUtils.getResponse(this.getMtextDeliveryUrl() + "?key=" + messageKeyString + "&userId=" + userId, "text/plain", "text/plain");
        }
        catch (Exception ex) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Exception while updating delivery report for MT message");
        }
    }

    public String getMessageMetadataUpdateUrl() {
        return this.getBaseUrl() + UPDATE_MESSAGE_METADATA_URL;
    }

    public synchronized void syncPendingMessages(boolean broadcast) {
        List<Message> pendingMessages = this.messageDatabaseService.getPendingMessages();
        Utils.printLog((Context)this.context, (String)TAG, (String)("Found " + pendingMessages.size() + " pending messages to sync."));
        for (Message message : pendingMessages) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Syncing pending message: " + (Object)((Object)message)));
            this.sendPendingMessageToServer(message, broadcast);
        }
    }

    public synchronized void syncDeleteMessages(boolean deleteMessage) {
        List<Message> pendingDeleteMessages = this.messageDatabaseService.getPendingDeleteMessages();
        Utils.printLog((Context)this.context, (String)TAG, (String)("Found " + pendingDeleteMessages.size() + " pending messages for Delete."));
        for (Message message : pendingDeleteMessages) {
            this.deletePendingMessages(message, deleteMessage);
        }
    }

    public void deletePendingMessages(Message message, boolean deleteMessage) {
        String contactNumberParameter = "";
        String response = "";
        if (message != null && !TextUtils.isEmpty((CharSequence)message.getContactIds())) {
            try {
                contactNumberParameter = "&userId=" + message.getContactIds();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (message.isSentToServer()) {
            response = this.httpRequestUtils.getResponse(this.getMessageDeleteUrl() + "?key=" + message.getKeyString() + contactNumberParameter, "text/plain", "text/plain");
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("Delete response from server for pending message: " + response));
        if ("success".equals(response)) {
            this.messageDatabaseService.deleteMessage(message, message.getContactIds());
        }
    }

    public boolean syncMessagesWithServer(List<Message> messageList) {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Total messages to sync: " + messageList.size()));
        ArrayList<Message> messages = new ArrayList<Message>(messageList);
        do {
            try {
                SmsSyncRequest smsSyncRequest = new SmsSyncRequest();
                if (messages.size() > 5) {
                    ArrayList<Message> subList = new ArrayList<Message>(messages.subList(0, 5));
                    smsSyncRequest.setSmsList(subList);
                    messages.removeAll(subList);
                } else {
                    smsSyncRequest.setSmsList(new ArrayList<Message>(messages));
                    messages.clear();
                }
                String response = this.syncMessages(smsSyncRequest);
                Utils.printLog((Context)this.context, (String)TAG, (String)("response from sync sms url::" + response));
                String[] keyStrings = null;
                if (!TextUtils.isEmpty((CharSequence)response) && !response.equals("error")) {
                    keyStrings = response.trim().split(",");
                }
                if (keyStrings == null) continue;
                int i = 0;
                for (Message message : smsSyncRequest.getSmsList()) {
                    if (!TextUtils.isEmpty((CharSequence)keyStrings[i])) {
                        message.setKeyString(keyStrings[i]);
                        this.messageDatabaseService.createMessage(message);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Utils.printLog((Context)this.context, (String)TAG, (String)("exception" + e));
                return false;
            }
        } while (messages.size() > 0);
        return true;
    }

    public void sendPendingMessageToServer(Message message, boolean broadcast) {
        try {
            if (message.isContactMessage()) {
                try {
                    this.processMessage(message, null);
                }
                catch (Exception e) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)"Exception while sending contact message.");
                }
                return;
            }
            if (message.hasAttachment()) {
                return;
            }
            MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
            message.setDeviceKeyString(mobiComUserPreference.getDeviceKeyString());
            message.setSuUserKeyString(mobiComUserPreference.getSuUserKeyString());
            String response = this.sendMessage(message);
            if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>") || response.equals("error")) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Error while sending pending messages.");
                return;
            }
            MessageResponse messageResponse = (MessageResponse)((Object)GsonUtils.getObjectFromJson((String)response, MessageResponse.class));
            String keyString = messageResponse.getMessageKey();
            String createdAt = messageResponse.getCreatedAtTime();
            message.setSentMessageTimeAtServer(Long.parseLong(createdAt));
            message.setKeyString(keyString);
            if (broadcast) {
                BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_SYNC_ACK_FROM_SERVER.toString(), message);
            }
            this.messageDatabaseService.updateMessageSyncStatus(message, keyString);
        }
        catch (Exception e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Error while sending pending messages.");
        }
    }

    public void sendMessageToServer(Message message, MediaUploadProgressHandler handler) throws Exception {
        this.sendMessageToServer(message, handler, null);
    }

    public void sendMessageToServer(Message message, MediaUploadProgressHandler handler, Class intentClass) throws Exception {
        this.processMessage(message, handler);
        if (message.getScheduledAt() != null && message.getScheduledAt() != 0L && intentClass != null) {
            new ScheduledMessageUtil(this.context, intentClass).createScheduleMessage(message, this.context);
        }
    }

    public void processMessage(Message message, MediaUploadProgressHandler handler) throws Exception {
        block35: {
            boolean isBroadcast = message.getMessageId() == null;
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            message.setSent(Boolean.TRUE);
            message.setSendToDevice(Boolean.FALSE);
            message.setSuUserKeyString(userPreferences.getSuUserKeyString());
            message.processContactIds(this.context);
            Contact contact = null;
            Channel channel = null;
            boolean isBroadcastOneByOneGroupType = false;
            boolean skipMessage = false;
            if (message.getGroupId() == null) {
                contact = this.baseContactService.getContactById(message.getContactIds());
            } else {
                channel = ChannelService.getInstance(this.context).getChannel(message.getGroupId());
                isBroadcastOneByOneGroupType = Channel.GroupType.BROADCAST_ONE_BY_ONE.getValue().equals(channel.getType());
            }
            long messageId = -1L;
            ArrayList fileKeys = new ArrayList();
            String keyString = null;
            if (!isBroadcastOneByOneGroupType) {
                keyString = UUID.randomUUID().toString();
                message.setKeyString(keyString);
                message.setSentToServer(false);
            } else {
                message.setSentToServer(true);
            }
            if (Message.MetaDataType.HIDDEN.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) {
                skipMessage = true;
            }
            if (!skipMessage) {
                messageId = this.messageDatabaseService.createMessage(message);
            }
            if (isBroadcast && !skipMessage) {
                BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
            }
            if (!isBroadcastOneByOneGroupType && message.isUploadRequired()) {
                for (String filePath : message.getFilePaths()) {
                    try {
                        String fileMetaResponse = new FileClientService(this.context).uploadBlobImage(filePath, handler);
                        if (fileMetaResponse == null) {
                            if (skipMessage) {
                                return;
                            }
                            if (handler != null) {
                                handler.onCompleted(new ApplozicException("Error while uploading"));
                            }
                            if (!message.isContactMessage()) {
                                this.messageDatabaseService.updateCanceledFlag(messageId, 1);
                            }
                            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPLOAD_ATTACHMENT_FAILED.toString(), message);
                            return;
                        }
                        if (ApplozicClient.getInstance(this.context).isCustomStorageServiceEnabled()) {
                            if (TextUtils.isEmpty((CharSequence)fileMetaResponse)) continue;
                            message.setFileMetas((FileMeta)((Object)GsonUtils.getObjectFromJson((String)fileMetaResponse, FileMeta.class)));
                            if (handler == null) continue;
                            handler.onCompleted(null);
                            continue;
                        }
                        JsonParser jsonParser = new JsonParser();
                        JsonObject jsonObject = jsonParser.parse(fileMetaResponse).getAsJsonObject();
                        if (!jsonObject.has(FILE_META)) continue;
                        Gson gson = new Gson();
                        message.setFileMetas((FileMeta)((Object)gson.fromJson(jsonObject.get(FILE_META), FileMeta.class)));
                        if (handler == null) continue;
                        handler.onCompleted(null);
                    }
                    catch (Exception ex) {
                        Utils.printLog((Context)this.context, (String)TAG, (String)("Error uploading file to server: " + filePath));
                        if (handler != null) {
                            handler.onCompleted(new ApplozicException("Error uploading file to server: " + filePath));
                        }
                        if (!message.isContactMessage() && !skipMessage) {
                            this.messageDatabaseService.updateCanceledFlag(messageId, 1);
                        }
                        if (!skipMessage) {
                            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPLOAD_ATTACHMENT_FAILED.toString(), message);
                        }
                        return;
                    }
                }
                if (messageId != -1L && !skipMessage) {
                    this.messageDatabaseService.updateMessageFileMetas(messageId, message);
                }
            }
            Message newMessage = new Message();
            newMessage.setTo(message.getTo());
            newMessage.setKeyString(message.getKeyString());
            newMessage.setMessage(message.getMessage());
            newMessage.setFileMetas(message.getFileMetas());
            newMessage.setCreatedAtTime(message.getCreatedAtTime());
            newMessage.setRead(Boolean.TRUE);
            newMessage.setDeviceKeyString(message.getDeviceKeyString());
            newMessage.setSuUserKeyString(message.getSuUserKeyString());
            newMessage.setSent(message.isSent());
            newMessage.setType(message.getType());
            newMessage.setTimeToLive(message.getTimeToLive());
            newMessage.setSource(message.getSource());
            newMessage.setScheduledAt(message.getScheduledAt());
            newMessage.setStoreOnDevice(message.isStoreOnDevice());
            newMessage.setDelivered(message.getDelivered());
            newMessage.setStatus(message.getStatus());
            newMessage.setMetadata(message.getMetadata());
            newMessage.setSendToDevice(message.isSendToDevice());
            newMessage.setContentType(message.getContentType());
            newMessage.setConversationId(message.getConversationId());
            if (message.getGroupId() != null) {
                newMessage.setGroupId(message.getGroupId());
            }
            if (!TextUtils.isEmpty((CharSequence)message.getClientGroupId())) {
                newMessage.setClientGroupId(message.getClientGroupId());
            }
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getApplicationId())) {
                newMessage.setApplicationId(contact.getApplicationId());
            } else {
                newMessage.setApplicationId(MessageClientService.getApplicationKey(this.context));
            }
            try {
                if (!isBroadcastOneByOneGroupType) {
                    MessageResponse messageResponse;
                    String response = this.sendMessage(newMessage);
                    if (message.hasAttachment() && TextUtils.isEmpty((CharSequence)response) && !message.isContactMessage() && !skipMessage) {
                        this.messageDatabaseService.updateCanceledFlag(messageId, 1);
                        if (handler != null) {
                            handler.onCompleted(new ApplozicException("Error uploading file to server"));
                        }
                        BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPLOAD_ATTACHMENT_FAILED.toString(), message);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(keyString = (messageResponse = (MessageResponse)((Object)GsonUtils.getObjectFromJson((String)response, MessageResponse.class))).getMessageKey()))) {
                        message.setSentMessageTimeAtServer(Long.parseLong(messageResponse.getCreatedAtTime()));
                        message.setConversationId(messageResponse.getConversationId());
                        message.setSentToServer(true);
                        message.setKeyString(keyString);
                    }
                    if (!skipMessage) {
                        this.messageDatabaseService.updateMessage(messageId, message.getSentMessageTimeAtServer(), keyString, message.isSentToServer());
                    }
                } else {
                    message.setSentMessageTimeAtServer(message.getCreatedAtTime());
                    this.messageDatabaseService.updateMessage(messageId, message.getSentMessageTimeAtServer(), keyString, message.isSentToServer());
                }
                if (message.isSentToServer() && handler != null) {
                    handler.onSent(message);
                }
                if (!TextUtils.isEmpty((CharSequence)keyString)) {
                    // empty if block
                }
                if (!skipMessage) {
                    BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_SYNC_ACK_FROM_SERVER.toString(), message);
                }
            }
            catch (Exception e) {
                if (handler == null) break block35;
                handler.onCompleted(new ApplozicException("Error uploading file"));
            }
        }
    }

    public String syncMessages(SmsSyncRequest smsSyncRequest) throws Exception {
        String data = GsonUtils.getJsonFromObject((Object)((Object)smsSyncRequest), SmsSyncRequest.class);
        return this.httpRequestUtils.postData(this.getSyncSmsUrl(), "application/json", null, data);
    }

    public String sendMessage(Message message) {
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)message), ((Object)((Object)message)).getClass());
            Utils.printLog((Context)this.context, (String)TAG, (String)("Sending message to server: " + jsonFromObject));
            return this.httpRequestUtils.postData(this.getSendMessageUrl(), "application/json;charset=utf-8", null, jsonFromObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public SyncMessageFeed getMessageFeed(String lastSyncTime, boolean isMetadataUpdate) {
        String url = isMetadataUpdate ? this.getServerSyncUrl() + "?" + MESSAGE_METADATA_UPDATE + "=true&" + LAST_SYNC_KEY + "=" + lastSyncTime : this.getServerSyncUrl() + "?" + LAST_SYNC_KEY + "=" + lastSyncTime;
        try {
            String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Sync call response: " + response));
            return (SyncMessageFeed)((Object)GsonUtils.getObjectFromJson((String)response, SyncMessageFeed.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void deleteConversationThreadFromServer(Contact contact) {
        if (TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            return;
        }
        try {
            String url = this.getMessageThreadDeleteUrl() + "?userId=" + contact.getContactIds();
            String response = this.httpRequestUtils.getResponse(url, "text/plain", "text/plain");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Delete messages response from server: " + response + contact.getContactIds()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String syncDeleteConversationThreadFromServer(Contact contact, Channel channel) {
        String response = null;
        String parameterString = "";
        try {
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
                parameterString = "?userId=" + contact.getContactIds();
            } else if (channel != null) {
                parameterString = "?groupId=" + channel.getKey();
            }
            String url = this.getMessageThreadDeleteUrl() + parameterString;
            response = this.httpRequestUtils.getResponse(url, "text/plain", "text/plain");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Delete messages response from server: " + response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public String deleteMessage(Message message, Contact contact) {
        String contactNumberParameter = "";
        String response = "";
        if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            try {
                contactNumberParameter = "&userId=" + contact.getContactIds();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (message.isSentToServer()) {
            response = this.httpRequestUtils.getResponse(this.getMessageDeleteUrl() + "?key=" + message.getKeyString() + contactNumberParameter, "text/plain", "text/plain");
            Utils.printLog((Context)this.context, (String)TAG, (String)("delete response is " + response));
        }
        return response;
    }

    public String getMessageByMessageKeys(List<String> messageKeys) {
        if (messageKeys != null && messageKeys.size() > 0) {
            String messageKeyUrlBuild = "";
            for (String messageKey : messageKeys) {
                messageKeyUrlBuild = messageKeyUrlBuild + "keys=" + messageKey + ARGUMRNT_SAPERATOR;
            }
            String response = this.httpRequestUtils.getResponse(this.getMessageByMessageKeysUrl() + "?" + messageKeyUrlBuild, "application/json", "application/json");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Message keys response is :" + response));
            if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
                return null;
            }
            return response;
        }
        return null;
    }

    public void updateReadStatus(Contact contact, Channel channel) {
        String contactNumberParameter = "";
        String response = "";
        if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            contactNumberParameter = "?userId=" + contact.getContactIds();
        } else if (channel != null) {
            contactNumberParameter = "?groupId=" + channel.getKey();
        }
        response = this.httpRequestUtils.getResponse(this.getUpdateReadStatusUrl() + contactNumberParameter, "text/plain", "text/plain");
        Utils.printLog((Context)this.context, (String)TAG, (String)("Read status response is " + response));
    }

    public void updateReadStatusForSingleMessage(String pairedmessagekey) {
        String singleReadMessageParm = "";
        String response = "";
        if (!TextUtils.isEmpty((CharSequence)pairedmessagekey)) {
            try {
                singleReadMessageParm = "?key=" + pairedmessagekey;
                response = this.httpRequestUtils.getResponse(this.getSingleMessageReadUrl() + singleReadMessageParm, "text/plain", "text/plain");
                Utils.printLog((Context)this.context, (String)TAG, (String)("Read status response for single message is " + response));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getMessages(Contact contact, Channel channel, Long startTime, Long endTime, Integer conversationId) throws UnsupportedEncodingException {
        return this.getMessages(contact, channel, startTime, endTime, conversationId, false);
    }

    public String getMessages(Contact contact, Channel channel, Long startTime, Long endTime, Integer conversationId, boolean isSkipRead) throws UnsupportedEncodingException {
        String contactNumber = contact != null ? contact.getFormattedContactNumber() : "";
        String params = "";
        if (contact != null || channel != null) {
            String string = params = isSkipRead ? "skipRead=" + isSkipRead + "&startIndex=0&pageSize=50&" : "startIndex=0&pageSize=50&";
        }
        if (contact == null && channel == null) {
            params = "startIndex=0&mainPageSize=60&";
        }
        if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getUserId())) {
            params = params + "userId=" + contact.getUserId() + ARGUMRNT_SAPERATOR;
        }
        params = params + (startTime != null && startTime.intValue() != 0 ? "startTime=" + startTime + ARGUMRNT_SAPERATOR : "");
        params = params + (endTime != null && endTime.intValue() != 0 ? "endTime=" + endTime + ARGUMRNT_SAPERATOR : "");
        params = params + (channel != null && channel.getKey() != null ? "groupId=" + channel.getKey() + ARGUMRNT_SAPERATOR : "");
        if (BroadcastService.isContextBasedChatEnabled()) {
            if (conversationId != null && conversationId != 0) {
                params = params + "conversationId=" + conversationId + ARGUMRNT_SAPERATOR;
            }
            if (endTime != null && endTime.intValue() == 0 || endTime == null) {
                params = params + "conversationReq=true";
            }
        }
        params = params + "&deletedGroupIncluded=true";
        return this.httpRequestUtils.getResponse(this.getMessageListUrl() + "?" + params, "application/json", "application/json");
    }

    public String deleteMessage(Message message) {
        return this.deleteMessage(message.getKeyString());
    }

    public String deleteMessage(String keyString) {
        return this.httpRequestUtils.getResponse(this.getMessageDeleteUrl() + "?key=" + keyString, "text/plain", "text/plain");
    }

    public SyncUserDetailsResponse getUserDetailsList(String lastSeenAt) {
        try {
            String url = this.getUserDetailsListUrl() + "?lastSeenAt=" + lastSeenAt;
            String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
            if (response == null || TextUtils.isEmpty((CharSequence)response) || response.equals("UnAuthorized Access")) {
                return null;
            }
            Utils.printLog((Context)this.context, (String)TAG, (String)("Sync UserDetails response is:" + response));
            SyncUserDetailsResponse userDetails = (SyncUserDetailsResponse)((Object)GsonUtils.getObjectFromJson((String)response, SyncUserDetailsResponse.class));
            return userDetails;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getConnectedUsers() {
        try {
            String response = this.getMessages(null, null, null, null, null);
            if (response == null || TextUtils.isEmpty((CharSequence)response) || response.equals("UnAuthorized Access") || !response.contains("{")) {
                return null;
            }
            JsonParser parser = new JsonParser();
            String element = parser.parse(response).getAsJsonObject().get("connectedUsers").toString();
            return (String[])GsonUtils.getObjectFromJson((String)element, String[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void processUserStatus(Contact contact) {
        if (contact != null && contact.getContactIds() != null) {
            this.processUserStatus(contact.getUserId(), false);
        }
    }

    public void processUserStatus(String userId) {
        this.processUserStatus(userId, false);
    }

    public void processUserStatus(String userId, boolean isProfileImageUpdated) {
        try {
            String contactNumberParameter = "";
            String response = "";
            try {
                contactNumberParameter = "?userIds=" + URLEncoder.encode(userId);
            }
            catch (Exception e) {
                contactNumberParameter = "?userIds=" + userId;
                e.printStackTrace();
            }
            response = this.httpRequestUtils.getResponse(this.getUserDetailUrl() + contactNumberParameter, "application/json", "application/json");
            Utils.printLog((Context)this.context, (String)TAG, (String)("User details response is " + response));
            if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
                return;
            }
            UserDetail[] userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)response, UserDetail[].class);
            if (userDetails != null) {
                for (UserDetail userDetail : userDetails) {
                    Contact contact = new Contact();
                    contact.setUserId(userDetail.getUserId());
                    contact.setFullName(userDetail.getDisplayName());
                    contact.setConnected(userDetail.isConnected());
                    contact.setContactNumber(userDetail.getPhoneNumber());
                    contact.setLastSeenAt(userDetail.getLastSeenAtTime());
                    contact.setImageURL(userDetail.getImageLink());
                    contact.setStatus(userDetail.getStatusMessage());
                    contact.setUserTypeId(userDetail.getUserTypeId());
                    contact.setDeletedAtTime(userDetail.getDeletedAtTime());
                    contact.setUnreadCount(Integer.valueOf(0));
                    contact.setRoleType(userDetail.getRoleType());
                    contact.setMetadata(userDetail.getMetadata());
                    contact.setLastMessageAtTime(userDetail.getLastMessageAtTime());
                    this.baseContactService.upsert(contact);
                }
                if (isProfileImageUpdated) {
                    BroadcastService.sendUpdateUserDetailBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_USER_DETAIL.toString(), userId);
                } else {
                    BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), userId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTopicId(Integer conversationId) {
        try {
            String topicId = null;
            String url = this.getProductTopicIdUrl() + "?conversationId=" + conversationId;
            String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
            if (response == null || TextUtils.isEmpty((CharSequence)response) || response.equals("UnAuthorized Access")) {
                return null;
            }
            ApiResponse productConversationIdResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            if ("success".equals(productConversationIdResponse.getStatus())) {
                topicId = productConversationIdResponse.getResponse().toString();
                return topicId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public MessageInfoResponse getMessageInfoList(String messageKey) {
        String url = this.getMessageInfoUrl() + "?key=" + messageKey;
        String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
        if (response == null || TextUtils.isEmpty((CharSequence)response) || response.equals("UnAuthorized Access")) {
            return null;
        }
        MessageInfoResponse messageInfoResponse = (MessageInfoResponse)((Object)GsonUtils.getObjectFromJson((String)response, MessageInfoResponse.class));
        return messageInfoResponse;
    }

    public ApiResponse updateMessageMetadata(String key, Map<String, String> metadata) {
        MessageMetadataUpdate metadataUpdate = new MessageMetadataUpdate();
        metadataUpdate.setKey(key);
        metadataUpdate.setMetadata(metadata);
        String jsonFromObject = GsonUtils.getJsonFromObject((Object)metadataUpdate, MessageMetadataUpdate.class);
        Utils.printLog((Context)this.context, (String)TAG, (String)("Sending message to server: " + jsonFromObject));
        try {
            String response = this.httpRequestUtils.postData(this.getMessageMetadataUpdateUrl(), "application/json", "application/json", jsonFromObject);
            ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            if (apiResponse != null) {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Message metadata update response : " + apiResponse.toString()));
                return apiResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

