/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.listners.MediaUploadProgressHandler;
import java.util.ArrayList;
import java.util.Map;

public class MessageBuilder {
    private Message message = new Message();
    private Context context;

    public MessageBuilder(Context context) {
        this.context = context;
    }

    public MessageBuilder setTo(String to) {
        this.message.setTo(to);
        return this;
    }

    public MessageBuilder setMessage(String message) {
        this.message.setMessage(message);
        return this;
    }

    public MessageBuilder setType(Short type) {
        this.message.setType(type);
        return this;
    }

    public MessageBuilder setFilePath(String filePath) {
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(filePath);
        this.message.setFilePaths(pathList);
        return this;
    }

    public MessageBuilder setContentType(short contentType) {
        this.message.setContentType(contentType);
        return this;
    }

    public MessageBuilder setGroupId(Integer groupId) {
        this.message.setGroupId(groupId);
        return this;
    }

    public MessageBuilder setMetadata(Map<String, String> metadata) {
        this.message.setMetadata(metadata);
        return this;
    }

    public MessageBuilder setClientGroupId(String clientGroupId) {
        this.message.setClientGroupId(clientGroupId);
        return this;
    }

    public void send() {
        new MobiComConversationService(this.context).sendMessage(this.message);
    }

    public void send(MediaUploadProgressHandler handler) {
        if (handler == null || !this.message.hasAttachment()) {
            new MobiComConversationService(this.context).sendMessage(this.message);
        } else if (this.message.hasAttachment()) {
            new MobiComConversationService(this.context).sendMessage(this.message, handler);
        }
    }
}

