/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.register.RegisterUserClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.listners.AlLoginHandler;
import java.lang.ref.WeakReference;

public class UserLoginTask
extends AsyncTask<Void, Void, Boolean> {
    private TaskListener taskListener;
    private final WeakReference<Context> context;
    private User user;
    private Exception mException;
    private RegistrationResponse registrationResponse;
    private UserClientService userClientService;
    private RegisterUserClientService registerUserClientService;
    private UserService userService;
    private AlLoginHandler loginHandler;

    public UserLoginTask(User user, TaskListener listener, Context context) {
        this.taskListener = listener;
        this.context = new WeakReference<Context>(context);
        this.user = user;
        this.userClientService = new UserClientService(context);
        this.registerUserClientService = new RegisterUserClientService(context);
        this.userService = UserService.getInstance(context);
    }

    public UserLoginTask(User user, AlLoginHandler listener, Context context) {
        this.loginHandler = listener;
        this.context = new WeakReference<Context>(context);
        this.user = user;
        this.userClientService = new UserClientService(context);
        this.registerUserClientService = new RegisterUserClientService(context);
        this.userService = UserService.getInstance(context);
    }

    protected Boolean doInBackground(Void ... params) {
        try {
            this.userClientService.clearDataAndPreference();
            this.registrationResponse = this.registerUserClientService.createAccount(this.user);
            this.userService.processPackageDetail();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mException = e;
            return false;
        }
        return true;
    }

    protected void onPostExecute(Boolean result) {
        if (this.taskListener != null) {
            if (this.registrationResponse != null) {
                if (this.registrationResponse.isRegistrationSuccess()) {
                    this.taskListener.onSuccess(this.registrationResponse, (Context)this.context.get());
                } else {
                    this.taskListener.onFailure(this.registrationResponse, this.mException);
                }
            } else {
                this.taskListener.onFailure(null, this.mException);
            }
        }
        if (this.loginHandler != null) {
            if (this.registrationResponse != null) {
                if (this.registrationResponse.isRegistrationSuccess()) {
                    this.loginHandler.onSuccess(this.registrationResponse, (Context)this.context.get());
                } else {
                    this.loginHandler.onFailure(this.registrationResponse, this.mException);
                }
            } else {
                this.loginHandler.onFailure(null, this.mException);
            }
        }
    }

    public static interface TaskListener {
        public void onSuccess(RegistrationResponse var1, Context var2);

        public void onFailure(RegistrationResponse var1, Exception var2);
    }
}

