/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.feed.ErrorResponseFeed;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ALGroupInfoTask
extends AsyncTask<Void, Void, ChannelModel> {
    private Context context;
    private Integer groupId;
    private String clientGroupId;
    private ChannelInfoListener listener;
    private ChannelDatabaseService channelDatabaseService;
    private ChannelService channelService;
    private boolean isUserListRequest;
    private static final String BASE_URL_METADATA = "com.applozic.server.url";
    private String DEFAULT_URL = "https://apps.applozic.com";
    private static final String CHANNEL_INFO_URL = "/rest/ws/group/info";
    private static final String GROUP_ID = "groupId";
    private static final String CLIENT_GROUPID = "clientGroupId";

    public ALGroupInfoTask(Context context, Integer groupId, String clientGroupId, boolean isUserListRequest, ChannelInfoListener listener) {
        this.context = (Context)new WeakReference<Context>(context).get();
        this.groupId = groupId;
        this.clientGroupId = clientGroupId;
        this.listener = listener;
        this.isUserListRequest = isUserListRequest;
        this.channelDatabaseService = ChannelDatabaseService.getInstance(this.context);
    }

    protected ChannelModel doInBackground(Void ... voids) {
        ChannelModel model = new ChannelModel();
        Channel channel = null;
        Exception exception = null;
        try {
            if (this.clientGroupId != null) {
                channel = this.channelDatabaseService.getChannelByClientGroupId(this.clientGroupId);
            } else if (this.groupId != null) {
                channel = this.channelDatabaseService.getChannelByChannelKey(this.groupId);
            }
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        if (channel != null) {
            model.setChannel(channel);
        } else {
            try {
                if (this.clientGroupId != null) {
                    model = this.getChannelInfoByParameters("clientGroupId=" + this.clientGroupId);
                } else if (this.groupId != null) {
                    model = this.getChannelInfoByParameters("groupId=" + this.groupId);
                }
            }
            catch (Exception e) {
                exception = e;
                e.printStackTrace();
            }
        }
        if (model != null) {
            model.setException(exception);
        }
        return model;
    }

    protected void onPostExecute(ChannelModel model) {
        super.onPostExecute((Object)model);
        if (this.listener != null) {
            if (model.getChannel() != null) {
                ChannelInfoModel infoModel = new ChannelInfoModel();
                if (this.isUserListRequest) {
                    List<ChannelUserMapper> mapperList = ChannelService.getInstance(this.context).getListOfUsersFromChannelUserMapper(model.getChannel().getKey());
                    ArrayList<String> users = new ArrayList<String>();
                    for (ChannelUserMapper channelUserMapper : mapperList) {
                        users.add(channelUserMapper.getUserKey());
                    }
                    infoModel.setUserList(users);
                }
                infoModel.setChannel(model.getChannel());
                this.listener.onSuccess(infoModel, "Success, found in local DB", this.context);
            } else if (model.getChannelFeedApiResponse() != null) {
                if (model.getChannelFeedApiResponse().isSuccess()) {
                    ChannelFeed channelFeed = model.getChannelFeedApiResponse().getResponse();
                    if (channelFeed != null) {
                        this.channelService = ChannelService.getInstance(this.context);
                        channelFeed.setUnreadCount(0);
                        ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                        this.channelService.processChannelFeedList(channelFeeds, false);
                        Channel channel = this.channelService.getChannel(channelFeed);
                        if (channel != null) {
                            ChannelInfoModel infoModel = new ChannelInfoModel();
                            if (this.isUserListRequest) {
                                ArrayList<String> users = new ArrayList<String>();
                                users.addAll(channelFeed.getMembersName());
                                infoModel.setUserList(users);
                            }
                            infoModel.setChannel(channel);
                            this.listener.onSuccess(infoModel, "Success, fetched from server", this.context);
                        }
                    }
                } else if (model.getChannelFeedApiResponse().getErrorResponse() != null) {
                    this.listener.onFailure(GsonUtils.getJsonFromObject((Object)model.getChannelFeedApiResponse().getErrorResponse().toArray(new ErrorResponseFeed[model.getChannelFeedApiResponse().getErrorResponse().size()]), ErrorResponseFeed[].class), model.getException(), this.context);
                } else {
                    this.listener.onFailure(null, model.getException(), this.context);
                }
            } else {
                this.listener.onFailure(null, model.getException(), this.context);
            }
        }
    }

    public ChannelModel getChannelInfoByParameters(String parameters) {
        String response = "";
        HttpRequestUtils httpRequestUtils = new HttpRequestUtils(this.context);
        ChannelModel model = new ChannelModel();
        try {
            response = httpRequestUtils.getResponse(this.getChannelInfoUrl() + "?" + parameters, "application/json", "application/json");
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ChannelFeedApiResponse.class));
            Utils.printLog((Context)this.context, (String)"ChannelInfoTask", (String)("Channel info response  is :" + response));
            if (channelFeedApiResponse != null) {
                model.setChannelFeedApiResponse(channelFeedApiResponse);
            }
        }
        catch (Exception e) {
            model.setException(e);
            e.printStackTrace();
        }
        return model;
    }

    protected String getBaseUrl() {
        String SELECTED_BASE_URL = MobiComUserPreference.getInstance(this.context).getUrl();
        if (!TextUtils.isEmpty((CharSequence)SELECTED_BASE_URL)) {
            return SELECTED_BASE_URL;
        }
        String BASE_URL = Utils.getMetaDataValue((Context)this.context.getApplicationContext(), (String)BASE_URL_METADATA);
        if (!TextUtils.isEmpty((CharSequence)BASE_URL)) {
            return BASE_URL;
        }
        return this.DEFAULT_URL;
    }

    private String getChannelInfoUrl() {
        return this.getBaseUrl() + CHANNEL_INFO_URL;
    }

    class ChannelModel {
        private ChannelFeedApiResponse channelFeedApiResponse;
        private Exception exception;
        private Channel channel;

        ChannelModel() {
        }

        public ChannelFeedApiResponse getChannelFeedApiResponse() {
            return this.channelFeedApiResponse;
        }

        public void setChannelFeedApiResponse(ChannelFeedApiResponse channelFeedApiResponse) {
            this.channelFeedApiResponse = channelFeedApiResponse;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public void setChannel(Channel channel) {
            this.channel = channel;
        }
    }

    public class ChannelInfoModel {
        Channel channel;
        ArrayList<String> groupMemberList;

        public Channel getChannel() {
            return this.channel;
        }

        public void setChannel(Channel channel) {
            this.channel = channel;
        }

        public ArrayList<String> getUserList() {
            return this.groupMemberList;
        }

        public void setUserList(ArrayList<String> userList) {
            this.groupMemberList = userList;
        }

        public String toString() {
            return "ChannelInfoModel{channel=" + this.channel + ", groupMemberList=" + this.groupMemberList + '}';
        }
    }

    public static interface ChannelInfoListener {
        public void onSuccess(ChannelInfoModel var1, String var2, Context var3);

        public void onFailure(String var1, Exception var2, Context var3);
    }
}

