/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment.urlservice;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.urlservice.URLService;
import com.applozic.mobicomkit.api.conversation.Message;
import java.io.IOException;
import java.net.HttpURLConnection;

public class S3URLService
implements URLService {
    private MobiComKitClientService mobiComKitClientService;
    private HttpRequestUtils httpRequestUtils;
    private Context context;
    private static final String GET_SIGNED_URL = "/rest/ws/file/url?key=";

    S3URLService(Context context) {
        this.mobiComKitClientService = new MobiComKitClientService(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
        this.context = context;
    }

    @Override
    public HttpURLConnection getAttachmentConnection(Message message) throws IOException {
        String response = this.httpRequestUtils.getResponse(this.mobiComKitClientService.getBaseUrl() + GET_SIGNED_URL + message.getFileMetas().getBlobKeyString(), "application/json", "application/json", true);
        if (TextUtils.isEmpty((CharSequence)response)) {
            return null;
        }
        return this.mobiComKitClientService.openHttpConnection(response);
    }

    @Override
    public String getThumbnailURL(Message message) throws IOException {
        return this.httpRequestUtils.getResponse(this.mobiComKitClientService.getBaseUrl() + GET_SIGNED_URL + message.getFileMetas().getThumbnailBlobKey(), "application/json", "application/json", true);
    }

    @Override
    public String getFileUploadUrl() {
        return this.mobiComKitClientService.getBaseUrl() + "/rest/ws/upload/image" + "?" + "aclsPrivate" + "=" + true;
    }

    @Override
    public String getImageUrl(Message message) {
        return message.getFileMetas().getBlobKeyString();
    }
}

