/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.AttachmentManager;
import com.applozic.mobicomkit.api.attachment.AttachmentTask;
import com.applozic.mobicomkit.api.conversation.Message;

public class AttachmentView
extends ImageView {
    private boolean mCacheFlag = true;
    private boolean mIsDrawn;
    private int mHideShowResId = -1;
    private ProgressBar proressBar;
    private RelativeLayout downloadProgressLayout;
    private Message message;
    private AttachmentTask mDownloadThread;
    private Context context;

    public AttachmentView(Context context) {
        super(context);
        this.context = context;
    }

    public AttachmentView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public AttachmentView(Context context, AttributeSet attributeSet, int defaultStyle) {
        super(context, attributeSet, defaultStyle);
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mHideShowResId != -1 && this.getParent() instanceof View) {
            View view = ((View)this.getParent()).findViewById(this.mHideShowResId);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        Bitmap bitmap;
        super.onDraw(canvas);
        if (this.message != null && this.mCacheFlag && (bitmap = AttachmentManager.getInstance().getBitMapFromCache(this.message.getKeyString())) != null) {
            this.setImageBitmap(bitmap);
            return;
        }
        if (!this.mIsDrawn && !AttachmentManager.isAttachmentInProgress(this.message.getKeyString())) {
            this.mDownloadThread = AttachmentManager.startDownload(this, this.mCacheFlag);
            this.mIsDrawn = true;
        }
        if (this.mDownloadThread == null) {
            this.mDownloadThread = AttachmentManager.getBGThreadForAttachment(this.message.getKeyString());
            if (this.mDownloadThread != null) {
                this.mDownloadThread.setAttachementView(this);
            }
        }
    }

    public void setImageBitmap(Bitmap paramBitmap) {
        super.setImageBitmap(paramBitmap);
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
    }

    public String getImageUrl() {
        if (this.message == null || this.message.getFileMetas() == null) {
            return null;
        }
        return new MobiComKitClientService(this.getContext().getApplicationContext()).getFileUrl() + this.message.getFileMetas().getBlobKeyString();
    }

    public String getLocalPath() {
        return this.message.getFilePaths() != null && !this.message.getFilePaths().isEmpty() ? this.message.getFilePaths().get(0) : null;
    }

    public String contentType() {
        return this.message.getFileMetas().getContentType();
    }

    public ProgressBar getProressBar() {
        return this.proressBar;
    }

    public void setProressBar(ProgressBar proressBar) {
        this.proressBar = proressBar;
    }

    public RelativeLayout getDownloadProgressLayout() {
        return this.downloadProgressLayout;
    }

    public void setDownloadProgressLayout(RelativeLayout downloadProgressLayout) {
        this.downloadProgressLayout = downloadProgressLayout;
    }

    public void cancelDownload() {
        AttachmentManager.removeDownload(this.mDownloadThread, false);
        this.getDownloadProgressLayout().setVisibility(8);
        this.mIsDrawn = false;
    }

    public void setMCacheFlag(boolean cacheFlag) {
        this.mCacheFlag = cacheFlag;
    }
}

