/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.register.RegisterUserClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserClientService;

public class UserLoginTask
extends AsyncTask<Void, Void, Boolean> {
    private final TaskListener taskListener;
    private final String mUserId;
    private final String mEmail;
    private final String mPassword;
    private final String mPhoneNumber;
    private final String mDisplayName;
    private final Context context;
    private User user;
    private String mImageLink;
    private Exception mException;
    private RegistrationResponse registrationResponse;

    public UserLoginTask(User user, TaskListener listener, Context context) {
        this.mUserId = user.getUserId();
        this.mEmail = user.getEmail();
        this.mPassword = user.getPassword();
        this.mPhoneNumber = user.getContactNumber();
        this.mDisplayName = user.getDisplayName();
        this.mImageLink = user.getImageLink();
        this.taskListener = listener;
        this.context = context;
        this.user = user;
    }

    protected Boolean doInBackground(Void ... params) {
        try {
            new UserClientService(this.context).clearDataAndPreference();
            this.registrationResponse = new RegisterUserClientService(this.context).createAccount(this.user);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mException = e;
            return false;
        }
        return true;
    }

    protected void onPostExecute(Boolean result) {
        if (result.booleanValue() && this.taskListener != null) {
            this.taskListener.onSuccess(this.registrationResponse, this.context);
        } else if (this.mException != null && this.taskListener != null) {
            this.taskListener.onFailure(this.registrationResponse, this.mException);
        }
    }

    public static interface TaskListener {
        public void onSuccess(RegistrationResponse var1, Context var2);

        public void onFailure(RegistrationResponse var1, Exception var2);
    }
}

