/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.ConversationReadService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.sync.SyncUserDetailsResponse;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.AnnotationExclusionStrategy;
import com.applozic.mobicommons.json.ArrayAdapterFactory;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class MobiComConversationService {
    public static final String SERVER_SYNC = "SERVER_SYNC_[CONVERSATION]_[CONTACT]_[CHANNEL]";
    private static final String TAG = "Conversation";
    protected Context context = null;
    protected MessageClientService messageClientService;
    protected MessageDatabaseService messageDatabaseService;
    private SharedPreferences sharedPreferences;
    private BaseContactService baseContactService;
    private ConversationService conversationService;
    private ChannelService channelService;

    public MobiComConversationService(Context context) {
        this.context = context;
        this.messageClientService = new MessageClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.baseContactService = new AppContactService(context);
        this.conversationService = ConversationService.getInstance(context);
        this.channelService = ChannelService.getInstance(context);
        this.sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey(context), 0);
    }

    public void sendMessage(Message message) {
        this.sendMessage(message, MessageIntentService.class);
    }

    public void sendMessage(Message message, Class messageIntentClass) {
        Intent intent = new Intent(this.context, messageIntentClass);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        this.context.startService(intent);
    }

    public List<Message> getLatestMessagesGroupByPeople() {
        return this.getLatestMessagesGroupByPeople(null, null);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt, String searchString) {
        boolean emptyTable = this.messageDatabaseService.isMessageTableEmpty();
        if (emptyTable || createdAt != null && createdAt != 0L) {
            this.getMessages(null, createdAt, null, null, null, false);
        }
        return this.messageDatabaseService.getMessages(createdAt, searchString);
    }

    public List<Message> getMessages(String userId, Long startTime, Long endTime) {
        return this.getMessages(startTime, endTime, new Contact(userId), null, null, false);
    }

    public synchronized List<Message> getMessages(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId) {
        return this.getMessages(startTime, endTime, contact, channel, conversationId, false);
    }

    public synchronized List<Message> getMessages(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId, boolean isSkipRead) {
        String data;
        ArrayList messageList = new ArrayList();
        List<Message> cachedMessageList = this.messageDatabaseService.getMessages(startTime, endTime, contact, channel, conversationId);
        boolean isServerCallNotRequired = false;
        if (channel != null) {
            Channel newChannel = ChannelService.getInstance(this.context).getChannelByChannelKey(channel.getKey());
            isServerCallNotRequired = newChannel != null && !Channel.GroupType.OPEN.getValue().equals(newChannel.getType()) || this.channelService.processIsUserPresentInChannel(channel.getKey());
        } else if (contact != null) {
            isServerCallNotRequired = true;
        }
        if (isServerCallNotRequired && (!cachedMessageList.isEmpty() && (cachedMessageList.size() > 1 || this.wasServerCallDoneBefore(contact, channel, conversationId)) || contact == null && channel == null && cachedMessageList.isEmpty() && this.wasServerCallDoneBefore(contact, channel, conversationId))) {
            Log.i((String)TAG, (String)("cachedMessageList size is : " + cachedMessageList.size()));
            return cachedMessageList;
        }
        try {
            data = this.messageClientService.getMessages(contact, channel, startTime, endTime, conversationId, isSkipRead);
            Log.i((String)TAG, (String)("Received response from server for Messages: " + data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return cachedMessageList;
        }
        if (data == null || TextUtils.isEmpty((CharSequence)data) || data.equals("UnAuthorized Access") || !data.contains("{")) {
            if (channel != null && channel.getKey() != null) {
                return cachedMessageList;
            }
            return cachedMessageList;
        }
        this.updateServerCallDoneStatus(contact, channel, conversationId);
        try {
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ArrayAdapterFactory()).setExclusionStrategies(new ExclusionStrategy[]{new AnnotationExclusionStrategy()}).create();
            JsonParser parser = new JsonParser();
            JSONObject jsonObject = new JSONObject(data);
            String channelFeedResponse = "";
            String conversationPxyResponse = "";
            String element = parser.parse(data).getAsJsonObject().get("message").toString();
            String userDetailsElement = parser.parse(data).getAsJsonObject().get("userDetails").toString();
            if (!TextUtils.isEmpty((CharSequence)userDetailsElement)) {
                UserDetail[] userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)userDetailsElement, UserDetail[].class);
                this.processUserDetails(userDetails);
            }
            if (jsonObject.has("groupFeeds")) {
                channelFeedResponse = parser.parse(data).getAsJsonObject().get("groupFeeds").toString();
                ChannelFeed[] channelFeeds = (ChannelFeed[])GsonUtils.getObjectFromJson((String)channelFeedResponse, ChannelFeed[].class);
                ChannelService.getInstance(this.context).processChannelFeedList(channelFeeds, false);
                if (channel != null && !isServerCallNotRequired) {
                    BroadcastService.sendUpdate(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_TITLE_SUBTITLE.toString());
                }
            }
            if (jsonObject.has("conversationPxys")) {
                conversationPxyResponse = parser.parse(data).getAsJsonObject().get("conversationPxys").toString();
                Conversation[] conversationPxy = (Conversation[])GsonUtils.getObjectFromJson((String)conversationPxyResponse, Conversation[].class);
                ConversationService.getInstance(this.context).processConversationArray(conversationPxy, channel, contact);
            }
            Message[] messages = (Message[])gson.fromJson(element, Message[].class);
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            if (messages != null && messages.length > 0 && cachedMessageList.size() > 0 && cachedMessageList.get(0).isLocalMessage() && cachedMessageList.get(0).equals((Object)messages[0])) {
                Log.i((String)TAG, (String)"Both messages are same.");
                this.deleteMessage(cachedMessageList.get(0));
            }
            for (Message message : messages) {
                if (message.isCall() && !userPreferences.isDisplayCallRecordEnable() || message.getTo() == null) continue;
                if (message.hasAttachment() && message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    this.setFilePathifExist(message);
                }
                if (message.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                    FileClientService fileClientService = new FileClientService(this.context);
                    fileClientService.loadContactsvCard(message);
                }
                if (Message.MetaDataType.HIDDEN.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) continue;
                if (contact == null && channel == null && message.isHidden()) {
                    if (message.getGroupId() != null) {
                        Channel newChannel = ChannelService.getInstance(this.context).getChannelByChannelKey(message.getGroupId());
                        if (newChannel != null) {
                            this.getMessages(null, null, null, newChannel, null, true);
                        }
                    } else {
                        this.getMessages(null, null, new Contact(message.getContactIds()), null, null, true);
                    }
                }
                this.messageDatabaseService.createMessage(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.messageDatabaseService.getMessages(startTime, endTime, contact, channel, conversationId);
    }

    private void processUserDetails(SyncUserDetailsResponse userDetailsResponse) {
        for (UserDetail userDetail : userDetailsResponse.getResponse()) {
            Contact newContact = this.baseContactService.getContactById(userDetail.getUserId());
            Contact contact = new Contact();
            contact.setUserId(userDetail.getUserId());
            contact.setContactNumber(userDetail.getPhoneNumber());
            contact.setStatus(userDetail.getStatusMessage());
            contact.setConnected(userDetail.isConnected());
            contact.setFullName(userDetail.getDisplayName());
            contact.setLastSeenAt(userDetail.getLastSeenAtTime());
            if (userDetail.getUnreadCount() != null) {
                contact.setUnreadCount(userDetail.getUnreadCount());
            }
            if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
                contact.setImageURL(userDetail.getImageLink());
            }
            if (newContact != null && newContact.isConnected() != contact.isConnected()) {
                BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), contact.getContactIds());
            }
            this.baseContactService.upsert(contact);
        }
        MobiComUserPreference.getInstance(this.context).setLastSeenAtSyncTime(userDetailsResponse.getGeneratedAt());
    }

    private boolean wasServerCallDoneBefore(Contact contact, Channel channel, Integer conversationId) {
        if (contact == null && channel == null) {
            return false;
        }
        return this.sharedPreferences.getBoolean(this.getServerSyncCallKey(contact, channel, conversationId), false);
    }

    private void updateServerCallDoneStatus(Contact contact, Channel channel, Integer conversationId) {
        if (contact == null && channel == null) {
            return;
        }
        Log.i((String)TAG, (String)"updating server call to true");
        this.sharedPreferences.edit().putBoolean(this.getServerSyncCallKey(contact, channel, conversationId), true).commit();
    }

    public String getServerSyncCallKey(Contact contact, Channel channel, Integer conversationId) {
        return SERVER_SYNC.replace("[CONVERSATION]", conversationId != null ? String.valueOf(conversationId) : "").replace("[CONTACT]", contact != null ? contact.getContactIds() : "").replace("[CHANNEL]", channel != null ? String.valueOf(channel.getKey()) : "");
    }

    private void setFilePathifExist(Message message) {
        FileMeta fileMeta = message.getFileMetas();
        File file = FileClientService.getFilePath(FileUtils.getName((String)fileMeta.getName()) + message.getCreatedAtTime() + "." + FileUtils.getFileFormat((String)fileMeta.getName()), this.context.getApplicationContext(), fileMeta.getContentType());
        if (file.exists()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            message.setFilePaths(arrayList);
        }
    }

    public boolean deleteMessage(Message message, Contact contact) {
        if (!message.isSentToServer()) {
            this.deleteMessageFromDevice(message, contact != null ? contact.getContactIds() : null);
            return true;
        }
        String response = this.messageClientService.deleteMessage(message, contact);
        if ("success".equals(response)) {
            this.deleteMessageFromDevice(message, contact != null ? contact.getContactIds() : null);
        } else {
            this.messageDatabaseService.updateDeleteSyncStatus(message, "1");
        }
        return true;
    }

    public boolean deleteMessage(Message message) {
        return this.deleteMessage(message, null);
    }

    public String deleteMessageFromDevice(Message message, String contactNumber) {
        if (message == null) {
            return null;
        }
        return this.messageDatabaseService.deleteMessage(message, contactNumber);
    }

    public void deleteConversationFromDevice(String contactNumber) {
        this.messageDatabaseService.deleteConversation(contactNumber);
    }

    public void deleteChannelConversationFromDevice(Integer channelKey) {
        this.messageDatabaseService.deleteChannelConversation(channelKey);
    }

    public void deleteAndBroadCast(final Contact contact, boolean deleteFromServer) {
        this.deleteConversationFromDevice(contact.getContactIds());
        if (deleteFromServer) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MobiComConversationService.this.messageClientService.deleteConversationThreadFromServer(contact);
                }
            });
            thread.setPriority(10);
            thread.start();
        }
        BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), contact.getContactIds(), 0, "success");
    }

    public String deleteSync(Contact contact, Channel channel, Integer conversationId) {
        String response = "";
        if (contact != null || channel != null) {
            response = this.messageClientService.syncDeleteConversationThreadFromServer(contact, channel);
        }
        if (!TextUtils.isEmpty((CharSequence)response) && "success".equals(response)) {
            if (contact != null) {
                this.messageDatabaseService.deleteConversation(contact.getContactIds());
                if (conversationId != null && conversationId != 0) {
                    this.conversationService.deleteConversation(contact.getContactIds());
                }
            } else {
                this.messageDatabaseService.deleteChannelConversation(channel.getKey());
            }
        }
        BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), contact != null ? contact.getContactIds() : null, channel != null ? channel.getKey() : null, response);
        return response;
    }

    public String deleteMessageFromDevice(String keyString, String contactNumber) {
        return this.deleteMessageFromDevice(this.messageDatabaseService.getMessage(keyString), contactNumber);
    }

    public synchronized void processLastSeenAtStatus() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncUserDetailsResponse userDetailsResponse = MobiComConversationService.this.messageClientService.getUserDetailsList(MobiComUserPreference.getInstance(MobiComConversationService.this.context).getLastSeenAtSyncTime());
                    if (userDetailsResponse != null && userDetailsResponse.getResponse() != null && "success".equals(userDetailsResponse.getStatus())) {
                        MobiComConversationService.this.processUserDetails(userDetailsResponse);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public void processUserDetails(UserDetail[] userDetails) {
        if (userDetails != null && userDetails.length > 0) {
            for (UserDetail userDetail : userDetails) {
                Contact contact = new Contact();
                contact.setUserId(userDetail.getUserId());
                contact.setContactNumber(userDetail.getPhoneNumber());
                contact.setConnected(userDetail.isConnected());
                contact.setFullName(userDetail.getDisplayName());
                contact.setLastSeenAt(userDetail.getLastSeenAtTime());
                contact.setStatus(userDetail.getStatusMessage());
                contact.setUnreadCount(userDetail.getUnreadCount());
                contact.setUserTypeId(userDetail.getUserTypeId());
                contact.setImageURL(userDetail.getImageLink());
                this.baseContactService.upsert(contact);
            }
        }
    }

    public String getConversationIdString(Integer conversationId) {
        return BroadcastService.isContextBasedChatEnabled() && conversationId != null && conversationId != 0 ? "_" + conversationId : "";
    }

    public void read(Contact contact, Channel channel) {
        try {
            int unreadCount = 0;
            if (contact != null) {
                Contact newContact = this.baseContactService.getContactById(contact.getContactIds());
                unreadCount = newContact.getUnreadCount();
                this.messageDatabaseService.updateReadStatusForContact(contact.getContactIds());
            } else if (channel != null) {
                Channel newChannel = this.channelService.getChannelByChannelKey(channel.getKey());
                unreadCount = newChannel.getUnreadCount();
                this.messageDatabaseService.updateReadStatusForChannel(String.valueOf(newChannel.getKey()));
            }
            Intent intent = new Intent(this.context, ConversationReadService.class);
            intent.putExtra("contact", (Serializable)contact);
            intent.putExtra("channel", (Serializable)channel);
            intent.putExtra("UNREAD_COUNT", unreadCount);
            this.context.startService(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

