/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.people;

import android.content.Context;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.people.ContactList;
import com.applozic.mobicommons.json.GsonUtils;

public class PeopleClientService
extends MobiComKitClientService {
    private HttpRequestUtils httpRequestUtils;
    public static final String GOOGLE_CONTACT_URL = "/rest/ws/user/session/contact/google/list";
    public static final String PLATFORM_CONTACT_URL = "/rest/ws/user/session/contact/google/list";

    public PeopleClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getGoogleContactUrl() {
        return this.getBaseUrl() + "/rest/ws/user/session/contact/google/list";
    }

    public String getPlatformContactUrl() {
        return this.getBaseUrl() + "/rest/ws/user/session/contact/google/list";
    }

    public String getGoogleContacts(int page) {
        return this.httpRequestUtils.getResponse(this.getGoogleContactUrl() + "?page=" + page, "application/json", "application/json");
    }

    public String getContactsInCurrentPlatform() {
        return this.httpRequestUtils.getResponse(this.getPlatformContactUrl() + "?mtexter=true", "application/json", "application/json");
    }

    public void addContacts(String url, ContactList contactList, boolean completed) throws Exception {
        String requestString = GsonUtils.getJsonWithExposeFromObject((Object)contactList, ContactList.class);
        if (completed) {
            url = url + "?completed=true";
        }
        this.httpRequestUtils.postData(url, "application/json", null, requestString);
    }
}

