/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.SyncBlockUserApiResponse;
import com.applozic.mobicomkit.feed.UserDetailListFeed;
import com.applozic.mobicommons.json.GsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class UserClientService
extends MobiComKitClientService {
    private static final String TAG = "UserClientService";
    public static final String SHARED_PREFERENCE_VERSION_UPDATE_KEY = "mck.version.update";
    public static final String PHONE_NUMBER_UPDATE_URL = "/rest/ws/registration/phone/number/update";
    public static final String NOTIFY_CONTACTS_ABOUT_JOINING_MT = "/rest/ws/registration/notify/contacts";
    public static final String VERIFICATION_CONTACT_NUMBER_URL = "/rest/ws/verification/number";
    public static final String VERIFICATION_CODE_CONTACT_NUMBER_URL = "/rest/ws/verification/code";
    public static final String APP_VERSION_UPDATE_URL = "/rest/ws/register/version/update";
    public static final String SETTING_UPDATE_URL = "/rest/ws/setting/single/update";
    public static final String TIMEZONE_UPDATAE_URL = "/rest/ws/setting/updateTZ";
    public static final String USER_INFO_URL = "/rest/ws/user/info?";
    public static final Short MOBICOMKIT_VERSION_CODE = 109;
    public static final String USER_DISPLAY_NAME_UPDATE = "/rest/ws/user/name?";
    public static final String BLOCK_USER_URL = "/rest/ws/user/block";
    public static final String BLOCK_USER_SYNC_URL = "/rest/ws/user/blocked/sync";
    public static final String UNBLOCK_USER_SYNC_URL = "/rest/ws/user/unblock";
    public static final String USER_DETAILS_URL = "/rest/ws/user/detail?";
    public static final String ONLINE_USER_LIST_URL = "/rest/ws/user/ol/list";
    public static final String REGISTERED_USER_LIST_URL = "/rest/ws/user/filter";
    public static final String USER_PROFILE_UPDATE_URL = "/rest/ws/user/update";
    public static final String USER_READ_URL = "/rest/ws/user/read";
    public static final String USER_DETAILS_LIST_POST_URL = "/rest/ws/user/detail";
    public static final int BATCH_SIZE = 60;
    private HttpRequestUtils httpRequestUtils;

    public UserClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getPhoneNumberUpdateUrl() {
        return this.getBaseUrl() + PHONE_NUMBER_UPDATE_URL;
    }

    public String getUserProfileUpdateUrl() {
        return this.getBaseUrl() + USER_PROFILE_UPDATE_URL;
    }

    public String getNotifyContactsAboutJoiningMt() {
        return this.getBaseUrl() + NOTIFY_CONTACTS_ABOUT_JOINING_MT;
    }

    public String getVerificationContactNumberUrl() {
        return this.getBaseUrl() + VERIFICATION_CONTACT_NUMBER_URL;
    }

    public String getVerificationCodeContactNumberUrl() {
        return this.getBaseUrl() + VERIFICATION_CODE_CONTACT_NUMBER_URL;
    }

    public String getAppVersionUpdateUrl() {
        return this.getBaseUrl() + APP_VERSION_UPDATE_URL;
    }

    public String getUpdateUserDisplayNameUrl() {
        return this.getBaseUrl() + USER_DISPLAY_NAME_UPDATE;
    }

    public String getSettingUpdateUrl() {
        return this.getBaseUrl() + SETTING_UPDATE_URL;
    }

    public String getTimezoneUpdataeUrl() {
        return this.getBaseUrl() + TIMEZONE_UPDATAE_URL;
    }

    public String getUserInfoUrl() {
        return this.getBaseUrl() + USER_INFO_URL;
    }

    public String getBlockUserUrl() {
        return this.getBaseUrl() + BLOCK_USER_URL;
    }

    public String getBlockUserSyncUrl() {
        return this.getBaseUrl() + BLOCK_USER_SYNC_URL;
    }

    public String getUnBlockUserSyncUrl() {
        return this.getBaseUrl() + UNBLOCK_USER_SYNC_URL;
    }

    public String getUserDetailsListUrl() {
        return this.getBaseUrl() + USER_DETAILS_URL;
    }

    public String getOnlineUserListUrl() {
        return this.getBaseUrl() + ONLINE_USER_LIST_URL;
    }

    public String getRegisteredUserListUrl() {
        return this.getBaseUrl() + REGISTERED_USER_LIST_URL;
    }

    public String getUserDetailsListPostUrl() {
        return this.getBaseUrl() + USER_DETAILS_LIST_POST_URL;
    }

    public String getUserReadUrl() {
        return this.getBaseUrl() + USER_READ_URL;
    }

    public void logout() {
        this.logout(false);
    }

    public void logout(boolean fromLogin) {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        String deviceKeyString = mobiComUserPreference.getDeviceKeyString();
        String userKeyString = mobiComUserPreference.getSuUserKeyString();
        String url = mobiComUserPreference.getUrl();
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        notificationManager.cancelAll();
        mobiComUserPreference.clearAll();
        MessageDatabaseService.recentlyAddedMessage.clear();
        MobiComDatabaseHelper.getInstance(this.context).delDatabase();
        mobiComUserPreference.setUrl(url);
        if (!fromLogin) {
            Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
            intent.putExtra("userKeyString", userKeyString);
            intent.putExtra("deviceKeyString", deviceKeyString);
            this.context.startService(intent);
        }
    }

    public boolean sendVerificationCodeToServer(String verificationCode) {
        try {
            String response = this.httpRequestUtils.getResponse(this.getVerificationCodeContactNumberUrl() + "?verificationCode=" + verificationCode, "application/json", "application/json");
            JSONObject json = new JSONObject(response);
            return json.has("code") && json.get("code").equals("200");
        }
        catch (Exception e) {
            Log.e((String)"Verification Code", (String)("Got Exception while submitting verification code to server: " + e));
            return false;
        }
    }

    public void updateCodeVersion(String deviceKeyString) {
        String url = this.getAppVersionUpdateUrl() + "?appVersionCode=" + MOBICOMKIT_VERSION_CODE + "&deviceKey=" + deviceKeyString;
        String response = this.httpRequestUtils.getResponse(url, "text/plain", "text/plain");
        Log.i((String)TAG, (String)("Version update response: " + response));
    }

    public String updatePhoneNumber(String contactNumber) throws UnsupportedEncodingException {
        return this.httpRequestUtils.getResponse(this.getPhoneNumberUpdateUrl() + "?phoneNumber=" + URLEncoder.encode(contactNumber, "UTF-8"), "text/plain", "text/plain");
    }

    public void notifyFriendsAboutJoiningThePlatform() {
        String response = this.httpRequestUtils.getResponse(this.getNotifyContactsAboutJoiningMt(), "text/plain", "text/plain");
        Log.i((String)TAG, (String)("Response for notify contact about joining MT: " + response));
    }

    public String sendPhoneNumberForVerification(String contactNumber, String countryCode, boolean viaSms) {
        try {
            String viaSmsParam = "";
            if (viaSms) {
                viaSmsParam = "&viaSms=true";
            }
            return this.httpRequestUtils.getResponse(this.getVerificationContactNumberUrl() + "?countryCode=" + countryCode + "&contactNumber=" + URLEncoder.encode(contactNumber, "UTF-8") + viaSmsParam, "application/json", "application/json");
        }
        catch (Exception e) {
            Log.e((String)"Verification Code", (String)("Got Exception while submitting contact number for verification to server: " + e));
            return null;
        }
    }

    public void updateSetting(String key, String value) {
        new Thread(new Runnable(){

            @Override
            public void run() {
            }
        }).start();
    }

    public Map<String, String> getUserInfo(Set<String> userIds) throws JSONException, UnsupportedEncodingException {
        if (userIds == null && userIds.isEmpty()) {
            return new HashMap<String, String>();
        }
        String userIdParam = "";
        for (String userId : userIds) {
            userIdParam = userIdParam + "&userIds=" + URLEncoder.encode(userId, "UTF-8");
        }
        String response = this.httpRequestUtils.getResponse(this.getUserInfoUrl() + userIdParam, "application/json", "application/json");
        Log.i((String)TAG, (String)("Response: " + response));
        JSONObject jsonObject = new JSONObject(response);
        HashMap<String, String> info = new HashMap<String, String>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            info.put(key, value);
        }
        return info;
    }

    public void updateUserDisplayName(final String userId, final String displayName) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String parameters = "";
                try {
                    if (!TextUtils.isEmpty((CharSequence)userId) && !TextUtils.isEmpty((CharSequence)displayName)) {
                        parameters = "userId=" + URLEncoder.encode(userId, "UTF-8") + "&displayName=" + URLEncoder.encode(displayName, "UTF-8");
                        String response = UserClientService.this.httpRequestUtils.getResponse(UserClientService.this.getUpdateUserDisplayNameUrl() + parameters, "application/json", "application/json");
                        ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                        if (apiResponse != null) {
                            Log.i((String)UserClientService.TAG, (String)(" Update display name Response :" + apiResponse.getStatus()));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public ApiResponse userBlock(String userId, boolean block) {
        String response = "";
        ApiResponse apiResponse = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                response = this.httpRequestUtils.getResponse((block ? this.getBlockUserUrl() : this.getUnBlockUserSyncUrl()) + "?userId=" + URLEncoder.encode(userId, "UTF-8"), "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public ApiResponse userUnBlock(String userId) {
        String response = "";
        ApiResponse apiResponse = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                response = this.httpRequestUtils.getResponse(this.getUnBlockUserSyncUrl() + "?userId=" + URLEncoder.encode(userId, "UTF-8"), "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public SyncBlockUserApiResponse getSyncUserBlockList(String lastSyncTime) {
        try {
            String url = this.getBlockUserSyncUrl() + "?lastSyncTime=" + lastSyncTime;
            String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
            if (response == null || TextUtils.isEmpty((CharSequence)response) || response.equals("UnAuthorized Access")) {
                return null;
            }
            return (SyncBlockUserApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, SyncBlockUserApiResponse.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUserDetails(Set<String> userIds) {
        try {
            if (userIds != null && userIds.size() > 0) {
                String response = "";
                String userIdParam = "";
                for (String userId : userIds) {
                    userIdParam = userIdParam + "&userIds=" + URLEncoder.encode(userId, "UTF-8");
                }
                response = this.httpRequestUtils.getResponse(this.getUserDetailsListUrl() + userIdParam, "application/json", "application/json");
                Log.i((String)TAG, (String)("User details response is :" + response));
                if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
                    return null;
                }
                return response;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String postUserDetailsByUserIds(Set<String> userIds) {
        try {
            if (userIds != null && userIds.size() > 0) {
                ArrayList<String> userDetailsList = new ArrayList<String>();
                String response = "";
                int count = 0;
                for (String userId : userIds) {
                    userDetailsList.add(userId);
                    if (++count % 60 != 0) continue;
                    UserDetailListFeed userDetailListFeed = new UserDetailListFeed();
                    userDetailListFeed.setContactSync(true);
                    userDetailListFeed.setUserIdList(userDetailsList);
                    String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)userDetailListFeed), ((Object)((Object)userDetailListFeed)).getClass());
                    Log.i((String)TAG, (String)("Sending json:" + jsonFromObject));
                    response = this.httpRequestUtils.postData(this.getUserDetailsListPostUrl() + "?contactSync=true", "application/json", "application/json", jsonFromObject);
                    userDetailsList = new ArrayList();
                    if (TextUtils.isEmpty((CharSequence)response)) continue;
                    UserService.getInstance(this.context).processUserDetailsResponse(response);
                }
                if (!userDetailsList.isEmpty() && userDetailsList.size() > 0) {
                    UserDetailListFeed userDetailListFeed = new UserDetailListFeed();
                    userDetailListFeed.setContactSync(true);
                    userDetailListFeed.setUserIdList(userDetailsList);
                    String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)userDetailListFeed), ((Object)((Object)userDetailListFeed)).getClass());
                    response = this.httpRequestUtils.postData(this.getUserDetailsListPostUrl() + "?contactSync=true", "application/json", "application/json", jsonFromObject);
                    Log.i((String)TAG, (String)("User details response is :" + response));
                    if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html>")) {
                        return null;
                    }
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        UserService.getInstance(this.context).processUserDetailsResponse(response);
                    }
                }
                return response;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, String> getOnlineUserList(int numberOfUser) {
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            String response = this.httpRequestUtils.getResponse(this.getOnlineUserListUrl() + "?startIndex=0&pageSize=" + numberOfUser, "application/json", "application/json");
            if (response != null && !"error".equals(response)) {
                JSONObject jsonObject = new JSONObject(response);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = jsonObject.getString(key);
                    info.put(key, value);
                }
                return info;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public String getRegisteredUsers(Long startTime, int pageSize) {
        String response = null;
        try {
            String url = "?pageSize=" + pageSize;
            if (startTime > 0L) {
                url = url + "&startTime=" + startTime;
            }
            response = this.httpRequestUtils.getResponse(this.getRegisteredUserListUrl() + url, "application/json", "application/json");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public ApiResponse updateDisplayNameORImageLink(String displayName, String profileImageLink, String status) {
        JSONObject jsonFromObject = new JSONObject();
        try {
            User user = new User();
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                jsonFromObject.put("displayName", (Object)displayName);
            }
            if (!TextUtils.isEmpty((CharSequence)profileImageLink)) {
                jsonFromObject.put("imageLink", (Object)profileImageLink);
            }
            if (!TextUtils.isEmpty((CharSequence)status)) {
                jsonFromObject.put("statusMessage", (Object)status);
            }
            String response = this.httpRequestUtils.postData(this.getUserProfileUpdateUrl(), "application/json", "application/json", jsonFromObject.toString());
            Log.i((String)TAG, (String)response);
            return (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ApiResponse getUserReadServerCall() {
        String response = null;
        ApiResponse apiResponse = null;
        try {
            response = this.httpRequestUtils.getResponse(this.getUserReadUrl(), null, null);
            if (response != null) {
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            }
            Log.i((String)TAG, (String)("User read response: " + response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }
}

