/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.feed.SyncBlockUserApiResponse;
import com.applozic.mobicomkit.sync.SyncUserBlockFeed;
import com.applozic.mobicomkit.sync.SyncUserBlockListFeed;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserService {
    Context context;
    UserClientService userClientService;
    private static UserService userService;
    private MobiComUserPreference userPreference;
    BaseContactService baseContactService;

    private UserService(Context context) {
        this.context = context;
        this.userClientService = new UserClientService(context);
        this.userPreference = MobiComUserPreference.getInstance(context);
        this.baseContactService = new AppContactService(context);
    }

    public static UserService getInstance(Context context) {
        if (userService == null) {
            userService = new UserService(context.getApplicationContext());
        }
        return userService;
    }

    public synchronized void processSyncUserBlock() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncBlockUserApiResponse apiResponse = UserService.this.userClientService.getSyncUserBlockList(UserService.this.userPreference.getUserBlockSyncTime());
                    if (apiResponse != null && "success".equals(apiResponse.getStatus())) {
                        SyncUserBlockListFeed syncUserBlockListFeed = apiResponse.getResponse();
                        if (syncUserBlockListFeed != null) {
                            Contact contact;
                            List<SyncUserBlockFeed> blockedToUserList = syncUserBlockListFeed.getBlockedToUserList();
                            List<SyncUserBlockFeed> blockedByUserList = syncUserBlockListFeed.getBlockedByUserList();
                            if (blockedToUserList != null && blockedToUserList.size() > 0) {
                                for (SyncUserBlockFeed syncUserBlockedFeed : blockedToUserList) {
                                    contact = new Contact();
                                    if (syncUserBlockedFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockedFeed.getBlockedTo())) continue;
                                    if (UserService.this.baseContactService.isContactExists(syncUserBlockedFeed.getBlockedTo())) {
                                        UserService.this.baseContactService.updateUserBlocked(syncUserBlockedFeed.getBlockedTo(), syncUserBlockedFeed.getUserBlocked());
                                        continue;
                                    }
                                    contact.setBlocked(syncUserBlockedFeed.getUserBlocked().booleanValue());
                                    contact.setUserId(syncUserBlockedFeed.getBlockedTo());
                                    UserService.this.baseContactService.upsert(contact);
                                    UserService.this.baseContactService.updateUserBlocked(syncUserBlockedFeed.getBlockedTo(), syncUserBlockedFeed.getUserBlocked());
                                }
                            }
                            if (blockedByUserList != null && blockedByUserList.size() > 0) {
                                for (SyncUserBlockFeed syncUserBlockByFeed : blockedByUserList) {
                                    contact = new Contact();
                                    if (syncUserBlockByFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockByFeed.getBlockedBy())) continue;
                                    if (UserService.this.baseContactService.isContactExists(syncUserBlockByFeed.getBlockedBy())) {
                                        UserService.this.baseContactService.updateUserBlockedBy(syncUserBlockByFeed.getBlockedBy(), syncUserBlockByFeed.getUserBlocked());
                                        continue;
                                    }
                                    contact.setBlockedBy(syncUserBlockByFeed.getUserBlocked().booleanValue());
                                    contact.setUserId(syncUserBlockByFeed.getBlockedBy());
                                    UserService.this.baseContactService.upsert(contact);
                                    UserService.this.baseContactService.updateUserBlockedBy(syncUserBlockByFeed.getBlockedBy(), syncUserBlockByFeed.getUserBlocked());
                                }
                            }
                        }
                        UserService.this.userPreference.setUserBlockSyncTime(apiResponse.getGeneratedAt());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public ApiResponse processUserBlock(String userId, boolean block) {
        ApiResponse apiResponse = this.userClientService.userBlock(userId, block);
        if (apiResponse != null && apiResponse.isSuccess()) {
            this.baseContactService.updateUserBlocked(userId, block);
            return apiResponse;
        }
        return null;
    }

    public synchronized void processUserDetail(Set<UserDetail> userDetails) {
        if (userDetails != null && userDetails.size() > 0) {
            for (UserDetail userDetail : userDetails) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUserDetails(String userId) {
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.processUserDetails(userIds);
    }

    public synchronized void processUserDetails(Set<String> userIds) {
        String response = this.userClientService.getUserDetails(userIds);
        if (!TextUtils.isEmpty((CharSequence)response)) {
            UserDetail[] userDetails;
            for (UserDetail userDetail : userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)response, UserDetail[].class)) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUser(UserDetail userDetail) {
        Contact contact = new Contact();
        contact.setUserId(userDetail.getUserId());
        contact.setContactNumber(userDetail.getPhoneNumber());
        contact.setConnected(userDetail.isConnected());
        contact.setStatus(userDetail.getStatusMessage());
        contact.setFullName(userDetail.getDisplayName());
        contact.setLastSeenAt(userDetail.getLastSeenAtTime());
        contact.setUnreadCount(Integer.valueOf(0));
        if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
            contact.setImageURL(userDetail.getImageLink());
        }
        this.baseContactService.upsert(contact);
    }

    public synchronized String[] getOnlineUsers(int numberOfUser) {
        try {
            Map<String, String> userMapList = this.userClientService.getOnlineUserList(numberOfUser);
            if (userMapList != null && userMapList.size() > 0) {
                String[] userIdArray = new String[userMapList.size()];
                HashSet<String> userIds = new HashSet<String>();
                int i = 0;
                for (Map.Entry<String, String> keyValue : userMapList.entrySet()) {
                    Contact contact = new Contact();
                    contact.setUserId(keyValue.getKey());
                    contact.setConnected(keyValue.getValue().contains("true"));
                    userIdArray[i] = keyValue.getKey();
                    userIds.add(keyValue.getKey());
                    this.baseContactService.upsert(contact);
                    ++i;
                }
                this.processUserDetails(userIds);
                return userIdArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized RegisteredUsersApiResponse getRegisteredUsersList(Long startTime, int pageSize) {
        String response = this.userClientService.getRegisteredUsers(startTime, pageSize);
        RegisteredUsersApiResponse apiResponse = null;
        if (!TextUtils.isEmpty((CharSequence)response) && !"error".equals(response)) {
            apiResponse = (RegisteredUsersApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, RegisteredUsersApiResponse.class));
            if (apiResponse != null) {
                this.processUserDetail(apiResponse.getUsers());
                this.userPreference.setRegisteredUsersLastFetchTime(apiResponse.getLastFetchTime());
            }
            return apiResponse;
        }
        return null;
    }

    public void updateDisplayNameORImageLink(String displayName, String profileImageLink, String localURL, String status) {
        ApiResponse response = this.userClientService.updateDisplayNameORImageLink(displayName, profileImageLink, status);
        if (response != null && response.isSuccess()) {
            Contact contact = this.baseContactService.getContactById(MobiComUserPreference.getInstance(this.context).getUserId());
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                contact.setFullName(displayName);
            }
            if (!TextUtils.isEmpty((CharSequence)profileImageLink)) {
                contact.setImageURL(profileImageLink);
            }
            contact.setLocalImageUrl(localURL);
            if (!TextUtils.isEmpty((CharSequence)status)) {
                contact.setStatus(status);
            }
            this.baseContactService.upsert(contact);
            Contact contact1 = this.baseContactService.getContactById(MobiComUserPreference.getInstance(this.context).getUserId());
            Log.i((String)"UserService", (String)(contact1.getImageURL() + ", " + contact1.getDisplayName() + "," + contact1.getStatus()));
        }
    }

    public ApiResponse processUserReadConversation() {
        return this.userClientService.getUserReadServerCall();
    }
}

