/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.app.IntentService;
import android.content.Intent;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.ApplozicMqttService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class ApplozicMqttIntentService
extends IntentService {
    public static final String TAG = "ApplozicMqttIntentService";
    public static final String SUBSCRIBE = "subscribe";
    public static final String SUBSCRIBE_TO_TYPING = "subscribeToTyping";
    public static final String UN_SUBSCRIBE_TO_TYPING = "unSubscribeToTyping";
    public static final String USER_KEY_STRING = "userKeyString";
    public static final String CONNECTED_PUBLISH = "connectedPublish";
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String TYPING = "typing";
    public static final String STOP_TYPING = "STOP_TYPING";

    public ApplozicMqttIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        boolean stop;
        boolean connectedStatus;
        boolean subscribe = intent.getBooleanExtra(SUBSCRIBE, false);
        if (subscribe) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).subscribe();
        }
        Contact contact = (Contact)intent.getSerializableExtra(CONTACT);
        Channel channel = (Channel)intent.getSerializableExtra(CHANNEL);
        boolean subscribeToTyping = intent.getBooleanExtra(SUBSCRIBE_TO_TYPING, false);
        if (subscribeToTyping) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).subscribeToTypingTopic(channel);
            return;
        }
        boolean unSubscribeToTyping = intent.getBooleanExtra(UN_SUBSCRIBE_TO_TYPING, false);
        if (unSubscribeToTyping) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).unSubscribeToTypingTopic(channel);
            return;
        }
        String userKeyString = intent.getStringExtra(USER_KEY_STRING);
        if (!TextUtils.isEmpty((CharSequence)userKeyString)) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).disconnectPublish(userKeyString, "0");
        }
        if (connectedStatus = intent.getBooleanExtra(CONNECTED_PUBLISH, false)) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).connectPublish(MobiComUserPreference.getInstance(this.getApplicationContext()).getSuUserKeyString(), "1");
        }
        if (contact != null && (stop = intent.getBooleanExtra(STOP_TYPING, false))) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).typingStopped(contact, null);
        }
        if (contact != null && (contact.isBlocked() || contact.isBlockedBy())) {
            return;
        }
        if (contact != null || channel != null) {
            boolean typing = intent.getBooleanExtra(TYPING, false);
            if (typing) {
                ApplozicMqttService.getInstance(this.getApplicationContext()).typingStarted(contact, channel);
            } else {
                ApplozicMqttService.getInstance(this.getApplicationContext()).typingStopped(contact, channel);
            }
        }
    }
}

