/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.api.people.ChannelInfo;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelClientService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChannelService {
    public static boolean isUpdateTitle = false;
    private static ChannelService channelService;
    public Context context;
    private ChannelDatabaseService channelDatabaseService;
    private ChannelClientService channelClientService;
    private BaseContactService baseContactService;
    private UserService userService;

    private ChannelService(Context context) {
        this.context = context;
        this.channelClientService = ChannelClientService.getInstance(context);
        this.channelDatabaseService = ChannelDatabaseService.getInstance(context);
        this.userService = UserService.getInstance(context);
        this.baseContactService = new AppContactService(context);
    }

    public static synchronized ChannelService getInstance(Context context) {
        if (channelService == null) {
            channelService = new ChannelService(context);
        }
        return channelService;
    }

    public Channel getChannelInfoFromLocalDb(Integer key) {
        return this.channelDatabaseService.getChannelByChannelKey(key);
    }

    public Channel getChannelInfo(Integer key) {
        ChannelFeed channelFeed;
        if (key == null) {
            return null;
        }
        Channel channel = this.channelDatabaseService.getChannelByChannelKey(key);
        if (channel == null && (channelFeed = this.channelClientService.getChannelInfo(key)) != null) {
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds, false);
            channel = this.getChannel(channelFeed);
            return channel;
        }
        return channel;
    }

    public void createMultipleChannels(List<ChannelInfo> channelInfo) {
        List<ChannelFeed> channelFeeds = this.channelClientService.createMultipleChannels(channelInfo);
        if (channelFeeds != null) {
            this.processChannelList(channelFeeds);
        }
    }

    public void processChannelFeedList(ChannelFeed[] channelFeeds, boolean isUserDetails) {
        if (channelFeeds != null && channelFeeds.length > 0) {
            for (ChannelFeed channelFeed : channelFeeds) {
                Set<String> memberUserIds = channelFeed.getMembersName();
                Channel channel = this.getChannel(channelFeed);
                if (this.channelDatabaseService.isChannelPresent(channel.getKey())) {
                    this.channelDatabaseService.updateChannel(channel);
                } else {
                    this.channelDatabaseService.addChannel(channel);
                }
                if (channelFeed.getConversationPxy() != null) {
                    channelFeed.getConversationPxy().setGroupId(channelFeed.getId());
                    ConversationService.getInstance(this.context).addConversation(channelFeed.getConversationPxy());
                }
                if (memberUserIds == null || memberUserIds.size() <= 0) continue;
                for (String userId : memberUserIds) {
                    ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelFeed.getId(), userId);
                    if (this.channelDatabaseService.isChannelUserPresent(channelFeed.getId(), userId)) {
                        this.channelDatabaseService.updateChannel(channelUserMapper);
                        continue;
                    }
                    this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
                }
                if (!isUserDetails) continue;
                this.userService.processUserDetail(channelFeed.getUsers());
            }
        }
    }

    public synchronized Channel getChannelByChannelKey(Integer channelKey) {
        if (channelKey == null) {
            return null;
        }
        return this.channelDatabaseService.getChannelByChannelKey(channelKey);
    }

    public List<ChannelUserMapper> getListOfUsersFromChannelUserMapper(Integer channelKey) {
        return this.channelDatabaseService.getChannelUserList(channelKey);
    }

    public Channel getChannel(Integer channelKey) {
        Channel channel = this.channelDatabaseService.getChannelByChannelKey(channelKey);
        if (channel == null) {
            channel = new Channel(channelKey);
        }
        return channel;
    }

    public void updateChannel(Channel channel) {
        if (this.channelDatabaseService.getChannelByChannelKey(channel.getKey()) == null) {
            this.channelDatabaseService.addChannel(channel);
        } else {
            this.channelDatabaseService.updateChannel(channel);
        }
    }

    public List<Channel> getChannelList() {
        return this.channelDatabaseService.getAllChannels();
    }

    public synchronized void syncChannels() {
        MobiComUserPreference userpref = MobiComUserPreference.getInstance(this.context);
        SyncChannelFeed syncChannelFeed = this.channelClientService.getChannelFeed(userpref.getChannelSyncTime());
        if (syncChannelFeed.isSuccess()) {
            this.processChannelList(syncChannelFeed.getResponse());
            BroadcastService.sendUpdateForChannelSync(this.context, BroadcastService.INTENT_ACTIONS.CHANNEL_SYNC.toString());
        }
        userpref.setChannelSyncTime(syncChannelFeed.getGeneratedAt());
    }

    public synchronized Channel createChannel(ChannelInfo channelInfo) {
        Channel channel = null;
        ChannelFeed channelFeed = this.channelClientService.createChannel(channelInfo);
        if (channelFeed != null) {
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds, true);
            channel = this.getChannel(channelFeed);
        }
        return channel;
    }

    public Channel getChannel(ChannelFeed channelFeed) {
        Channel channel = new Channel(channelFeed.getId(), channelFeed.getName(), channelFeed.getAdminName(), Short.valueOf(channelFeed.getType()), channelFeed.getUnreadCount(), channelFeed.getImageUrl());
        channel.setClientGroupId(channelFeed.getClientGroupId());
        return channel;
    }

    public String removeMemberFromChannelProcess(Integer channelKey, String userId) {
        if (channelKey == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.removeMemberFromChannel(channelKey, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.removeMemberFromChannel(channelKey, userId);
        }
        return apiResponse.getStatus();
    }

    public String removeMemberFromChannelProcess(String clientGroupId, String userId) {
        if (clientGroupId == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.removeMemberFromChannel(clientGroupId, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.removeMemberFromChannel(clientGroupId, userId);
        }
        return apiResponse.getStatus();
    }

    public String addMemberToChannelProcess(Integer channelKey, String userId) {
        if (channelKey == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(channelKey, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelKey, userId);
            this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
        }
        return apiResponse.getStatus();
    }

    public String addMemberToChannelProcess(String clientGroupId, String userId) {
        if (TextUtils.isEmpty((CharSequence)clientGroupId) && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(clientGroupId, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            Channel channel = this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
            ChannelUserMapper channelUserMapper = new ChannelUserMapper(channel.getKey(), userId);
            this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
        }
        return apiResponse.getStatus();
    }

    public String addMemberToMultipleChannelsProcess(Set<String> clientGroupIds, String userId) {
        if (clientGroupIds == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToMultipleChannelsByClientGroupIds(clientGroupIds, userId);
        if (apiResponse == null) {
            return null;
        }
        return apiResponse.getStatus();
    }

    public String addMemberToMultipleChannelsProcessByChannelKeys(Set<Integer> channelKeys, String userId) {
        if (channelKeys == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToMultipleChannelsByChannelKey(channelKeys, userId);
        if (apiResponse == null) {
            return null;
        }
        return apiResponse.getStatus();
    }

    public String leaveMemberFromChannelProcess(String clientGroupId, String userId) {
        if (TextUtils.isEmpty((CharSequence)clientGroupId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.leaveMemberFromChannel(clientGroupId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.leaveMemberFromChannel(clientGroupId, userId);
        }
        return apiResponse.getStatus();
    }

    public String leaveMemberFromChannelProcess(Integer channelKey, String userId) {
        if (channelKey == null) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.leaveMemberFromChannel(channelKey);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.leaveMemberFromChannel(channelKey, userId);
        }
        return apiResponse.getStatus();
    }

    public String updateChannel(GroupInfoUpdate groupInfoUpdate) {
        if (groupInfoUpdate == null) {
            return null;
        }
        ApiResponse apiResponse = this.channelClientService.updateChannel(groupInfoUpdate);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.updateChannel(groupInfoUpdate);
        }
        return apiResponse.getStatus();
    }

    public synchronized void processChannelList(List<ChannelFeed> channelFeedList) {
        if (channelFeedList != null && channelFeedList.size() > 0) {
            for (ChannelFeed channelFeed : channelFeedList) {
                Set<String> memberUserIds = channelFeed.getMembersName();
                HashSet<String> userIds = new HashSet<String>();
                Channel channel = this.getChannel(channelFeed);
                if (this.channelDatabaseService.isChannelPresent(channel.getKey())) {
                    this.channelDatabaseService.updateChannel(channel);
                    this.channelDatabaseService.deleteChannelUserMappers(channel.getKey());
                } else {
                    this.channelDatabaseService.addChannel(channel);
                }
                if (memberUserIds == null || memberUserIds.size() <= 0) continue;
                for (String userId : memberUserIds) {
                    ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelFeed.getId(), userId);
                    this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
                    if (this.baseContactService.isContactExists(userId)) continue;
                    userIds.add(userId);
                }
                if (userIds == null || userIds.size() <= 0) continue;
                this.userService.processUserDetails(userIds);
            }
        }
    }

    public synchronized boolean processIsUserPresentInChannel(Integer channelKey) {
        return this.channelDatabaseService.isChannelUserPresent(channelKey, MobiComUserPreference.getInstance(this.context).getUserId());
    }

    public synchronized boolean isUserAlreadyPresentInChannel(Integer channelKey, String userId) {
        return this.channelDatabaseService.isChannelUserPresent(channelKey, userId);
    }

    public synchronized boolean processIsUserPresentInChannel(String clientGroupId) {
        Channel channel = this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
        return this.channelDatabaseService.isChannelUserPresent(channel.getKey(), MobiComUserPreference.getInstance(this.context).getUserId());
    }

    public synchronized boolean isUserAlreadyPresentInChannel(String clientGroupId, String userId) {
        Channel channel = this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
        return this.channelDatabaseService.isChannelUserPresent(channel.getKey(), userId);
    }

    public synchronized String processChannelDeleteConversation(Channel channel, Context context) {
        String response = new MobiComConversationService(context).deleteSync(null, channel, null);
        if (!TextUtils.isEmpty((CharSequence)response) && "success".equals(response)) {
            this.channelDatabaseService.deleteChannelUserMappers(channel.getKey());
            this.channelDatabaseService.deleteChannel(channel.getKey());
        }
        return response;
    }

    public void updateChannelLocalImageURI(Integer channelKey, String localImageURI) {
        this.channelDatabaseService.updateChannelLocalImageURI(channelKey, localImageURI);
    }
}

