/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.MultipleChannelFeedApiResponse;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.people.ChannelInfo;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.json.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import java.util.Set;

public class ChannelClientService
extends MobiComKitClientService {
    private static final String CHANNEL_INFO_URL = "/rest/ws/group/info";
    private static final String CHANNEL_SYNC_URL = "/rest/ws/group/list";
    private static final String CREATE_CHANNEL_URL = "/rest/ws/group/create";
    private static final String CREATE_MULTIPLE_CHANNEL_URL = "/rest/ws/group/create/multiple";
    private static final String ADD_MEMBER_TO_CHANNEL_URL = "/rest/ws/group/add/member";
    private static final String REMOVE_MEMBER_FROM_CHANNEL_URL = "/rest/ws/group/remove/member";
    private static final String CHANNEL_UPDATE_URL = "/rest/ws/group/update";
    private static final String CHANNEL_LEFT_URL = "/rest/ws/group/left";
    private static final String ADD_MEMBER_TO_MULTIPLE_CHANNELS_URL = "/rest/ws/group/add/user";
    private static final String CHANNEL_DELETE_URL = "/rest/ws/group/delete";
    private static final String REMOVE_MEMBERS_FROM_MULTIPE_CHANNELS = "/rest/ws/group/remove/user";
    private static final String UPDATED_AT = "updatedAt";
    private static final String USER_ID = "userId";
    private static final String GROUP_ID = "groupId";
    private static final String CLIENT_GROUPID = "clientGroupId";
    private static final String GROUPIDS = "groupIds";
    private static final String CLIENT_GROUPIDs = "clientGroupIds";
    private static final String TAG = "ChannelClientService";
    private static ChannelClientService channelClientService;
    private HttpRequestUtils httpRequestUtils;

    private ChannelClientService(Context context) {
        super(context);
        this.context = context;
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public static ChannelClientService getInstance(Context context) {
        if (channelClientService == null) {
            channelClientService = new ChannelClientService(context);
        }
        return channelClientService;
    }

    public String getChannelInfoUrl() {
        return this.getBaseUrl() + CHANNEL_INFO_URL;
    }

    public String getChannelSyncUrl() {
        return this.getBaseUrl() + CHANNEL_SYNC_URL;
    }

    public String getCreateChannelUrl() {
        return this.getBaseUrl() + CREATE_CHANNEL_URL;
    }

    public String getCreateMultipleChannelUrl() {
        return this.getBaseUrl() + CREATE_MULTIPLE_CHANNEL_URL;
    }

    public String getAddMemberToGroup() {
        return this.getBaseUrl() + ADD_MEMBER_TO_CHANNEL_URL;
    }

    public String getRemoveMemberUrl() {
        return this.getBaseUrl() + REMOVE_MEMBER_FROM_CHANNEL_URL;
    }

    public String getChannelUpdateUrl() {
        return this.getBaseUrl() + CHANNEL_UPDATE_URL;
    }

    public String getChannelLeftUrl() {
        return this.getBaseUrl() + CHANNEL_LEFT_URL;
    }

    public String getChannelDeleteUrl() {
        return this.getBaseUrl() + CHANNEL_DELETE_URL;
    }

    public String getAddMemberToMultipleChannelsUrl() {
        return this.getBaseUrl() + ADD_MEMBER_TO_MULTIPLE_CHANNELS_URL;
    }

    public String getRemoveMembersFromMultipChannels() {
        return this.getBaseUrl() + REMOVE_MEMBERS_FROM_MULTIPE_CHANNELS;
    }

    public ChannelFeed getChannelInfoByParameters(String parameters) {
        String response = "";
        try {
            response = this.httpRequestUtils.getResponse(this.getCredentials(), this.getChannelInfoUrl() + "?" + parameters, "application/json", "application/json");
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ChannelFeedApiResponse.class));
            Log.i((String)TAG, (String)("Channel info response  is :" + response));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
                return channelFeed;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ChannelFeed getChannelInfo(String clientGroupId) {
        return this.getChannelInfoByParameters("clientGroupId=" + clientGroupId);
    }

    public ChannelFeed getChannelInfo(Integer channelKey) {
        return this.getChannelInfoByParameters("groupId=" + channelKey);
    }

    public SyncChannelFeed getChannelFeed(String lastChannelSyncTime) {
        String url = this.getChannelSyncUrl() + "?" + UPDATED_AT + "=" + lastChannelSyncTime;
        try {
            String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
            Log.i((String)TAG, (String)("Channel sync call response: " + response));
            return (SyncChannelFeed)((Object)GsonUtils.getObjectFromJson((String)response, SyncChannelFeed.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    public ChannelFeed createChannel(ChannelInfo channelInfo) {
        ChannelFeed channelFeed = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)channelInfo), ((Object)((Object)channelInfo)).getClass());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCredentials(), this.getCreateChannelUrl(), "application/json", "application/json", jsonFromObject);
            Log.i((String)TAG, (String)("Create channel Response :" + createChannelResponse));
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                channelFeed = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return channelFeed;
    }

    public List<ChannelFeed> createMultipleChannels(List<ChannelInfo> channels) {
        List<ChannelFeed> channelFeeds = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject(channels, (Type)new TypeToken<List<ChannelInfo>>(){}.getType());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCredentials(), this.getCreateMultipleChannelUrl(), "application/json", "application/json", jsonFromObject);
            Log.i((String)TAG, (String)("Create Multiple channel Response :" + createChannelResponse));
            MultipleChannelFeedApiResponse channelFeedApiResponse = (MultipleChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)createChannelResponse, MultipleChannelFeedApiResponse.class));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                channelFeeds = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return channelFeeds;
    }

    public ApiResponse removeMembersFromMultipleChannelsByChannelKeys(Set<Integer> channelKeys, Set<String> userIds) {
        return this.removeMembersFromMultipleChannels(null, channelKeys, userIds);
    }

    public ApiResponse removeMembersFromMultipleChannelsByClientGroupIds(Set<String> clientGroupIds, Set<String> userIds) {
        return this.removeMembersFromMultipleChannels(clientGroupIds, null, userIds);
    }

    private ApiResponse removeMembersFromMultipleChannels(Set<String> clientGroupIds, Set<Integer> channelKeys, Set<String> userIds) {
        ApiResponse apiResponse;
        block9: {
            apiResponse = null;
            try {
                if (userIds == null || userIds.size() <= 0) break block9;
                String parameters = "";
                if (clientGroupIds != null && clientGroupIds.size() > 0) {
                    for (String clientGroupId : clientGroupIds) {
                        parameters = parameters + "clientGroupIds=" + URLEncoder.encode(clientGroupId, "UTF-8") + "&";
                    }
                } else if (channelKeys != null && channelKeys.size() > 0) {
                    for (Integer channelKey : channelKeys) {
                        parameters = parameters + "groupIds=" + channelKey + "&";
                    }
                }
                for (String userId : userIds) {
                    parameters = parameters + "userId=" + URLEncoder.encode(userId, "UTF-8") + "&";
                }
                String url = this.getRemoveMembersFromMultipChannels() + "?" + parameters;
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel remove members from channels response: " + apiResponse.getStatus()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return apiResponse;
    }

    public synchronized ApiResponse addMemberToMultipleChannels(Set<String> clientGroupIds, Set<Integer> channelKeys, String userId) {
        ApiResponse apiResponse;
        block7: {
            apiResponse = null;
            try {
                if (TextUtils.isEmpty((CharSequence)userId)) break block7;
                String parameters = "";
                if (clientGroupIds != null && clientGroupIds.size() > 0) {
                    for (String clientGroupId : clientGroupIds) {
                        parameters = parameters + "clientGroupIds=" + URLEncoder.encode(clientGroupId, "UTF-8") + "&";
                    }
                } else {
                    for (Integer channelKey : channelKeys) {
                        parameters = parameters + "groupIds=" + channelKey + "&";
                    }
                }
                String url = this.getAddMemberToMultipleChannelsUrl() + "?" + parameters + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel add member call response: " + apiResponse.getStatus()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return apiResponse;
    }

    public ApiResponse addMemberToMultipleChannelsByChannelKey(Set<Integer> channelKeys, String userId) {
        return this.addMemberToMultipleChannels(null, channelKeys, userId);
    }

    public ApiResponse addMemberToMultipleChannelsByClientGroupIds(Set<String> clientGroupIds, String userId) {
        return this.addMemberToMultipleChannels(clientGroupIds, null, userId);
    }

    public synchronized ApiResponse addMemberToChannel(String clientGroupId, Integer channelKey, String userId) {
        try {
            String parameters = "";
            parameters = !TextUtils.isEmpty((CharSequence)clientGroupId) ? "clientGroupId=" + URLEncoder.encode(clientGroupId, "UTF-8") : "groupId=" + channelKey;
            if (!TextUtils.isEmpty((CharSequence)parameters) && !TextUtils.isEmpty((CharSequence)userId)) {
                String url = this.getAddMemberToGroup() + "?" + parameters + "&" + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel add member call response: " + apiResponse.getStatus()));
                }
                return apiResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized ApiResponse addMemberToChannel(Integer channelKey, String userId) {
        return this.addMemberToChannel(null, channelKey, userId);
    }

    public synchronized ApiResponse addMemberToChannel(String clientGroupId, String userId) {
        return this.addMemberToChannel(clientGroupId, null, userId);
    }

    public synchronized ApiResponse removeMemberFromChannel(String clientGroupId, Integer channelKey, String userId) {
        ApiResponse apiResponse = null;
        try {
            String parameters = "";
            parameters = !TextUtils.isEmpty((CharSequence)clientGroupId) ? "clientGroupId=" + URLEncoder.encode(clientGroupId, "UTF-8") : "groupId=" + channelKey;
            if (!TextUtils.isEmpty((CharSequence)parameters) && !TextUtils.isEmpty((CharSequence)userId)) {
                String url = this.getRemoveMemberUrl() + "?" + parameters + "&" + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel remove member response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse removeMemberFromChannel(Integer channelKey, String userId) {
        return this.removeMemberFromChannel(null, channelKey, userId);
    }

    public synchronized ApiResponse removeMemberFromChannel(String clientGroupId, String userId) {
        return this.removeMemberFromChannel(clientGroupId, null, userId);
    }

    public synchronized ApiResponse updateChannel(GroupInfoUpdate groupInfoUpdate) {
        ApiResponse apiResponse = null;
        try {
            if (!(groupInfoUpdate == null || TextUtils.isEmpty((CharSequence)groupInfoUpdate.getClientGroupId()) && groupInfoUpdate.getGroupId() == null || TextUtils.isEmpty((CharSequence)groupInfoUpdate.getNewName()) && TextUtils.isEmpty((CharSequence)groupInfoUpdate.getImageUrl()))) {
                String channelNameUpdateJson = GsonUtils.getJsonFromObject((Object)((Object)groupInfoUpdate), GroupInfoUpdate.class);
                String response = this.httpRequestUtils.postData(this.getCredentials(), this.getChannelUpdateUrl(), "application/json", "application/json", channelNameUpdateJson);
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Update Channel response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public ApiResponse leaveMemberFromChannel(Integer channelKey) {
        return this.leaveMemberFromChannel(null, channelKey);
    }

    public ApiResponse leaveMemberFromChannel(String clientGroupId) {
        return this.leaveMemberFromChannel(clientGroupId, null);
    }

    public synchronized ApiResponse leaveMemberFromChannel(String clientGroupId, Integer channelKey) {
        ApiResponse apiResponse = null;
        try {
            String parameters = "";
            parameters = !TextUtils.isEmpty((CharSequence)clientGroupId) ? "clientGroupId=" + URLEncoder.encode(clientGroupId, "UTF-8") : "groupId=" + channelKey;
            if (!TextUtils.isEmpty((CharSequence)clientGroupId) || channelKey != null && channelKey != 0) {
                String url = this.getChannelLeftUrl() + "?" + parameters;
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel leave member call response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse deleteChannel(Integer channelKey) {
        try {
            if (channelKey != null) {
                String url = this.getChannelDeleteUrl() + "?" + GROUP_ID + "=" + URLEncoder.encode(String.valueOf(channelKey), "UTF-8");
                String response = this.httpRequestUtils.getResponse(this.getCredentials(), url, "application/json", "application/json");
                ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Log.i((String)TAG, (String)("Channel delete call response: " + apiResponse.getStatus()));
                }
                return apiResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

