/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.feed.SyncBlockUserApiResponse;
import com.applozic.mobicomkit.sync.SyncUserBlockFeed;
import com.applozic.mobicomkit.sync.SyncUserBlockListFeed;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserService {
    Context context;
    UserClientService userClientService;
    private static UserService userService;
    private MobiComUserPreference userPreference;
    BaseContactService baseContactService;

    private UserService(Context context) {
        this.context = context;
        this.userClientService = new UserClientService(context);
        this.userPreference = MobiComUserPreference.getInstance(context);
        this.baseContactService = new AppContactService(context);
    }

    public static UserService getInstance(Context context) {
        if (userService == null) {
            userService = new UserService(context);
        }
        return userService;
    }

    public synchronized void processSyncUserBlock() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncBlockUserApiResponse apiResponse = UserService.this.userClientService.getSyncUserBlockList(UserService.this.userPreference.getUserBlockSyncTime());
                    if (apiResponse != null && "success".equals(apiResponse.getStatus())) {
                        Contact contact = new Contact();
                        SyncUserBlockListFeed syncUserBlockListFeed = apiResponse.getResponse();
                        if (syncUserBlockListFeed != null) {
                            List<SyncUserBlockFeed> blockedToUserList = syncUserBlockListFeed.getBlockedToUserList();
                            List<SyncUserBlockFeed> blockedByUserList = syncUserBlockListFeed.getBlockedByUserList();
                            if (blockedToUserList != null && blockedToUserList.size() > 0) {
                                for (SyncUserBlockFeed syncUserBlockedFeed : blockedToUserList) {
                                    if (syncUserBlockedFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockedFeed.getBlockedTo())) continue;
                                    contact.setBlocked(syncUserBlockedFeed.getUserBlocked().booleanValue());
                                    contact.setUserId(syncUserBlockedFeed.getBlockedTo());
                                    UserService.this.baseContactService.upsert(contact);
                                }
                            }
                            if (blockedByUserList != null && blockedByUserList.size() > 0) {
                                for (SyncUserBlockFeed syncUserBlockByFeed : blockedByUserList) {
                                    if (syncUserBlockByFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockByFeed.getBlockedBy())) continue;
                                    contact.setBlockedBy(syncUserBlockByFeed.getUserBlocked().booleanValue());
                                    contact.setUserId(syncUserBlockByFeed.getBlockedBy());
                                    UserService.this.baseContactService.upsert(contact);
                                }
                            }
                        }
                        UserService.this.userPreference.setUserBlockSyncTime(apiResponse.getGeneratedAt());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    public String processUserBlock(String userId) {
        ApiResponse apiResponse = this.userClientService.userBlock(userId);
        if (apiResponse != null && apiResponse.isSuccess()) {
            this.baseContactService.updateUserBlocked(userId, true);
            return apiResponse.getStatus();
        }
        return null;
    }

    public String processUserUnBlockUser(String userId) {
        ApiResponse apiResponse = this.userClientService.userUnBlock(userId);
        if (apiResponse != null && apiResponse.isSuccess()) {
            this.baseContactService.updateUserBlocked(userId, false);
            return apiResponse.getStatus();
        }
        return null;
    }

    public synchronized void processUserDetail(Set<UserDetail> userDetails) {
        if (userDetails != null && userDetails.size() > 0) {
            for (UserDetail userDetail : userDetails) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUserDetails(String userId) {
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.processUserDetails(userIds);
    }

    public synchronized void processUserDetails(Set<String> userIds) {
        String response = this.userClientService.getUserDetails(userIds);
        if (!TextUtils.isEmpty((CharSequence)response)) {
            UserDetail[] userDetails;
            for (UserDetail userDetail : userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)response, UserDetail[].class)) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUser(UserDetail userDetail) {
        Contact contact = new Contact();
        contact.setUserId(userDetail.getUserId());
        contact.setContactNumber(userDetail.getPhoneNumber());
        contact.setConnected(userDetail.isConnected());
        contact.setFullName(userDetail.getDisplayName());
        contact.setLastSeenAt(userDetail.getLastSeenAtTime());
        contact.setUnreadCount(Integer.valueOf(0));
        if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
            contact.setImageURL(userDetail.getImageLink());
        }
        this.baseContactService.upsert(contact);
    }

    public synchronized String[] getOnlineUsers(int numberOfUser) {
        try {
            Map<String, String> userMapList = this.userClientService.getOnlineUserList(numberOfUser);
            if (userMapList != null && userMapList.size() > 0) {
                String[] userIdArray = new String[userMapList.size()];
                HashSet<String> userIds = new HashSet<String>();
                int i = 0;
                for (Map.Entry<String, String> keyValue : userMapList.entrySet()) {
                    Contact contact = new Contact();
                    contact.setUserId(keyValue.getKey());
                    contact.setConnected(keyValue.getValue().contains("true"));
                    userIdArray[i] = keyValue.getKey();
                    userIds.add(keyValue.getKey());
                    this.baseContactService.upsert(contact);
                    ++i;
                }
                this.processUserDetails(userIds);
                return userIdArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized RegisteredUsersApiResponse getRegisteredUsersList(Long startTime, int pageSize) {
        String response = this.userClientService.getRegisteredUsers(startTime, pageSize);
        RegisteredUsersApiResponse apiResponse = null;
        if (!TextUtils.isEmpty((CharSequence)response) && !"error".equals(response)) {
            apiResponse = (RegisteredUsersApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, RegisteredUsersApiResponse.class));
            if (apiResponse != null) {
                this.processUserDetail(apiResponse.getUsers());
                this.userPreference.setRegisteredUsersLastFetchTime(apiResponse.getLastFetchTime());
            }
            return apiResponse;
        }
        return apiResponse;
    }
}

