/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.contact.MobiComVCFParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ContactService {
    private Context context;

    public ContactService(Context context) {
        this.context = context;
    }

    public File vCard(Uri contactData) throws Exception {
        Cursor cursor = this.context.getContentResolver().query(contactData, null, null, null, null);
        cursor.moveToFirst();
        String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_VCARD_URI, (String)lookupKey);
        String name = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "CONTACT_" + timeStamp + "_" + ".vcf";
        File outputFile = FileClientService.getFilePath(imageFileName, this.context, "text/x-vcard");
        AssetFileDescriptor fd = this.context.getContentResolver().openAssetFileDescriptor(uri, "r");
        FileInputStream fis = fd.createInputStream();
        byte[] buf = new byte[(int)fd.getDeclaredLength()];
        fis.read(buf);
        String cvFdata = new String(buf);
        if (!MobiComVCFParser.validateData(cvFdata)) {
            Log.i((String)"vCard ::", (String)cvFdata.toString());
            throw new Exception("contact exported is not proper in proper format");
        }
        Log.i((String)" data:", (String)new String(buf));
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile.getAbsoluteFile());
        fileOutputStream.write(buf);
        fileOutputStream.close();
        return outputFile;
    }
}

