/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.applozic.mobicomkit.api.attachment.AttachmentDownloader;
import com.applozic.mobicomkit.api.attachment.AttachmentManager;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicommons.commons.image.PhotoDecodeRunnable;
import com.applozic.mobicommons.file.FileUtils;
import java.lang.ref.WeakReference;

public class AttachmentTask
implements AttachmentDownloader.TaskRunnableDownloadMethods,
PhotoDecodeRunnable.TaskRunnableDecodeMethods {
    private static AttachmentManager sPhotoManager;
    Thread mThreadThis;
    byte[] mImageBuffer;
    private WeakReference<AttachmentView> mImageWeakRef;
    private String mImageURL;
    private int mTargetHeight;
    private int mTargetWidth;
    private boolean mCacheEnabled;
    private Context context;
    private Runnable mDownloadRunnable = new AttachmentDownloader(this);
    private Runnable mDecodeRunnable = new PhotoDecodeRunnable((PhotoDecodeRunnable.TaskRunnableDecodeMethods)this);
    private Bitmap mDecodedImage;
    private Thread mCurrentThread;
    private Message message;

    AttachmentTask() {
        sPhotoManager = AttachmentManager.getInstance();
    }

    void initializeDownloaderTask(AttachmentManager photoManager, AttachmentView photoView, boolean cacheFlag) {
        sPhotoManager = photoManager;
        this.mImageURL = photoView.getImageUrl();
        this.message = photoView.getMessage();
        this.setAttachementView(photoView);
        this.mCacheEnabled = cacheFlag;
        this.mTargetWidth = photoView.getWidth();
        this.mTargetHeight = photoView.getHeight();
        this.context = photoView.getContext();
    }

    public void setAttachementView(AttachmentView photoView) {
        this.mImageWeakRef = new WeakReference<AttachmentView>(photoView);
    }

    void recycle() {
        if (null != this.mImageWeakRef) {
            this.mImageWeakRef.clear();
            this.mImageWeakRef = null;
        }
        this.mImageBuffer = null;
        this.mDecodedImage = null;
    }

    public int getTargetWidth() {
        return this.mTargetWidth;
    }

    public int getTargetHeight() {
        return this.mTargetHeight;
    }

    boolean isCacheEnabled() {
        return this.mCacheEnabled;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public String getContentType() {
        if (this.message == null) {
            return null;
        }
        if (this.message.isAttachmentUploadInProgress() || this.message.getFileMetas() == null) {
            String filePath = this.message.getFilePaths().get(0);
            String mimeType = FileUtils.getMimeType((String)filePath);
            return mimeType;
        }
        if (this.message.getFileMetas() != null) {
            return this.message.getFileMetas().getContentType();
        }
        return null;
    }

    void handleState(int state) {
        sPhotoManager.handleState(this, state);
    }

    Bitmap getImage() {
        return this.mDecodedImage;
    }

    public void setImage(Bitmap decodedImage) {
        this.mDecodedImage = decodedImage;
    }

    Runnable getHTTPDownloadRunnable() {
        return this.mDownloadRunnable;
    }

    Runnable getPhotoDecodeRunnable() {
        return this.mDecodeRunnable;
    }

    public AttachmentView getPhotoView() {
        if (null != this.mImageWeakRef) {
            return (AttachmentView)((Object)this.mImageWeakRef.get());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getCurrentThread() {
        AttachmentManager attachmentManager = sPhotoManager;
        synchronized (attachmentManager) {
            return this.mCurrentThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentThread(Thread thread) {
        AttachmentManager attachmentManager = sPhotoManager;
        synchronized (attachmentManager) {
            this.mCurrentThread = thread;
        }
    }

    public String getLocalPath() {
        if (this.getPhotoView() == null) {
            Log.e((String)"AttachmentTask", (String)("@@@photoView ia coming as null.." + this.getMessage().getKeyString()));
            return null;
        }
        return this.getPhotoView().getLocalPath();
    }

    @Override
    public void setDownloadThread(Thread currentThread) {
        this.setCurrentThread(currentThread);
    }

    @Override
    public void handleDownloadState(int state) {
        int outState;
        switch (state) {
            case 1: {
                outState = 2;
                AttachmentTask.sPhotoManager.attachmentInProgress.remove(this.getMessage().getKeyString());
                AttachmentTask.sPhotoManager.attachmentTaskList.remove(this);
                break;
            }
            case -1: {
                outState = -1;
                AttachmentTask.sPhotoManager.attachmentInProgress.remove(this.getMessage().getKeyString());
                AttachmentTask.sPhotoManager.attachmentTaskList.remove(this);
                break;
            }
            default: {
                outState = 1;
            }
        }
        this.handleState(outState);
    }

    @Override
    public String getImageURL() {
        return this.getPhotoView().getImageUrl();
    }

    public void setImageDecodeThread(Thread currentThread) {
        this.setCurrentThread(currentThread);
    }

    public void handleDecodeState(int state) {
        int outState;
        switch (state) {
            case 1: {
                outState = 4;
                break;
            }
            case -1: {
                outState = -2;
                break;
            }
            default: {
                outState = 3;
            }
        }
        this.handleState(outState);
    }

    public Message getMessageDetail() {
        return null;
    }
}

