/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.app.RemoteInput;

public class WearableNotificationWithVoice {
    Class<?> notificationHandler;
    Context mContext;
    int actionIconResId;
    NotificationCompat.Builder notificationBuilder;
    int replyLabelResourceId;
    int actionTitleId;
    int notificationId;
    PendingIntent pendingIntent;
    public static final String EXTRA_VOICE_REPLY = "extra_voice_reply";

    public WearableNotificationWithVoice(NotificationCompat.Builder notificationBuilder, int actionTitleId, int replyLabelResourceId, int actionIcon, int notificationId) {
        this.notificationBuilder = notificationBuilder;
        this.replyLabelResourceId = replyLabelResourceId;
        this.actionIconResId = actionIcon;
        this.actionTitleId = actionTitleId;
        this.notificationId = notificationId;
    }

    public void setNotificationHandler(Class<?> replyActivityClass) {
        this.notificationHandler = replyActivityClass;
    }

    public void setCurrentContext(Context currentContext) {
        this.mContext = currentContext;
    }

    public void setPendingIntent(PendingIntent pendingIntent) {
        this.pendingIntent = pendingIntent;
    }

    public void sendNotification() throws Exception {
        if (this.pendingIntent == null && this.notificationHandler == null) {
            throw new RuntimeException("Either pendingIntent or handler class requires.");
        }
        NotificationCompat.Action action = this.buildWearableAction();
        Notification notification = this.notificationBuilder.extend((NotificationCompat.Extender)new NotificationCompat.WearableExtender().addAction(action)).build();
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.mContext);
        notificationManager.notify(this.notificationId, notification);
    }

    private NotificationCompat.Action buildWearableAction() {
        String replyLabel = this.mContext.getString(this.replyLabelResourceId);
        RemoteInput remoteInput = new RemoteInput.Builder(EXTRA_VOICE_REPLY).setLabel((CharSequence)replyLabel).build();
        if (this.pendingIntent == null) {
            Intent replyIntent = new Intent(this.mContext, this.notificationHandler);
            this.pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)((int)(System.currentTimeMillis() & 0xFFFFFFFL)), (Intent)replyIntent, (int)0x8000000);
        }
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(this.actionIconResId, (CharSequence)this.mContext.getString(this.actionTitleId), this.pendingIntent).addRemoteInput(remoteInput).build();
        return action;
    }
}

