/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.List;

public class AppContactService
implements BaseContactService {
    private static final String TAG = "AppContactService";
    ContactDatabase contactDatabase;
    Context context;

    public AppContactService(Context context) {
        this.context = context;
        this.contactDatabase = new ContactDatabase(context);
    }

    @Override
    public void add(Contact contact) {
        this.contactDatabase.addContact(contact);
    }

    @Override
    public void addAll(List<Contact> contactList) {
        for (Contact contact : contactList) {
            this.upsert(contact);
        }
    }

    @Override
    public void deleteContact(Contact contact) {
        this.contactDatabase.deleteContact(contact);
    }

    @Override
    public void deleteContactById(String contactId) {
        this.contactDatabase.deleteContactById(contactId);
    }

    @Override
    public List<Contact> getAll() {
        return this.contactDatabase.getAllContact();
    }

    @Override
    public Contact getContactById(String contactId) {
        Contact contact = this.contactDatabase.getContactById(contactId);
        if (contact != null) {
            contact.processContactNumbers(this.context);
        } else {
            contact = new Contact(this.context, contactId);
            this.add(contact);
        }
        return contact;
    }

    @Override
    public void updateContact(Contact contact) {
        this.contactDatabase.updateContact(contact);
    }

    @Override
    public void upsert(Contact contact) {
        if (this.contactDatabase.getContactById(contact.getUserId()) == null) {
            this.contactDatabase.addContact(contact);
        } else {
            this.contactDatabase.updateContact(contact);
        }
    }

    @Override
    public List<Contact> getAllContactListExcludingLoggedInUser() {
        return this.contactDatabase.getAllContactListExcludingLoggedInUser();
    }

    @Override
    public Bitmap downloadContactImage(Context context, Contact contact) {
        try {
            if (TextUtils.isEmpty((CharSequence)contact.getImageURL()) && TextUtils.isEmpty((CharSequence)contact.getLocalImageUrl())) {
                return null;
            }
            Bitmap attachedImage = null;
            String contactImageURL = contact.getImageURL();
            String contentType = "image";
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            String imageLocalPath = contact.getLocalImageUrl();
            if (imageLocalPath != null) {
                try {
                    attachedImage = BitmapFactory.decodeFile((String)imageLocalPath);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("File not found on local storage: " + ex.getMessage()));
                }
            }
            if (attachedImage == null) {
                HttpURLConnection connection = new MobiComKitClientService(context).openHttpConnection(contactImageURL);
                if (connection.getResponseCode() == 200) {
                    attachedImage = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
                    new FileClientService(context);
                    imageLocalPath = FileClientService.saveImageToInternalStorage(attachedImage, contact.getUserId(), context, "image");
                    contact.setLocalImageUrl(imageLocalPath);
                    this.updateContact(contact);
                } else {
                    Log.w((String)TAG, (String)("Download is failed response code is ...." + connection.getResponseCode()));
                }
            }
            options.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)options, (int)100, (int)50);
            options.inJustDecodeBounds = false;
            attachedImage = BitmapFactory.decodeFile((String)imageLocalPath, (BitmapFactory.Options)options);
            return attachedImage;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("File not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        return null;
    }

    @Override
    public Contact getContactReceiver(List<String> items, List<String> userIds) {
        if (userIds != null && !userIds.isEmpty()) {
            return this.getContactById(userIds.get(0));
        }
        if (items != null && !items.isEmpty()) {
            return this.getContactById(items.get(0));
        }
        return null;
    }

    @Override
    public boolean isContactExists(String contactId) {
        return this.contactDatabase.getContactById(contactId) != null;
    }

    @Override
    public void updateConnectedStatus(String contactId, Date date, boolean connected) {
        Contact contact = this.getContactById(contactId);
        if (contact != null && contact.isConnected() != connected) {
            this.contactDatabase.updateConnectedOrDisconnectedStatus(contactId, date, connected);
            BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), contactId);
        }
    }

    @Override
    public void updateUserBlocked(String userId, boolean userBlocked) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            this.contactDatabase.updateUserBlockStatus(userId, userBlocked);
            BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), userId);
        }
    }

    @Override
    public void updateUserBlockedBy(String userId, boolean userBlockedBy) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            this.contactDatabase.updateUserBlockByStatus(userId, userBlockedBy);
            BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), userId);
        }
    }

    @Override
    public boolean isContactPresent(String userId) {
        return this.contactDatabase.isContactPresent(userId);
    }
}

