/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.app.IntentService;
import android.content.Intent;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.ApplozicMqttService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicommons.people.contact.Contact;

public class ApplozicMqttIntentService
extends IntentService {
    public static final String TAG = "ApplozicMqttIntentService";
    public static final String SUBSCRIBE = "subscribe";
    public static final String USER_KEY_STRING = "userKeyString";
    public static final String CONNECTED_PUBLISH = "connectedPublish";
    public static final String CONTACT = "contact";
    public static final String TYPING = "typing";
    public static final String STOP_TYPING = "STOP_TYPING";

    public ApplozicMqttIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        boolean stop;
        Contact contact;
        boolean connectedStatus;
        String userKeyString;
        boolean subscribe = intent.getBooleanExtra(SUBSCRIBE, false);
        if (subscribe) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).subscribe();
        }
        if (!TextUtils.isEmpty((CharSequence)(userKeyString = intent.getStringExtra(USER_KEY_STRING)))) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).disconnectPublish(userKeyString, "0");
        }
        if (connectedStatus = intent.getBooleanExtra(CONNECTED_PUBLISH, false)) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).connectPublish(MobiComUserPreference.getInstance(this.getApplicationContext()).getSuUserKeyString(), "1");
        }
        if ((contact = (Contact)intent.getSerializableExtra(CONTACT)) != null && !contact.isBlocked() && !contact.isBlockedBy()) {
            boolean typing = intent.getBooleanExtra(TYPING, false);
            if (typing) {
                ApplozicMqttService.getInstance(this.getApplicationContext()).typingStarted(contact);
            } else {
                ApplozicMqttService.getInstance(this.getApplicationContext()).typingStopped(contact);
            }
        }
        if (contact != null && (stop = intent.getBooleanExtra(STOP_TYPING, false))) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).typingStopped(contact);
        }
    }
}

