/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.people.ChannelCreate;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelClientService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import java.util.List;
import java.util.Set;

public class ChannelService {
    private static ChannelService channelService;
    public Context context;
    private ChannelDatabaseService channelDatabaseService;
    private ChannelClientService channelClientService;

    private ChannelService(Context context) {
        this.context = context;
        this.channelClientService = ChannelClientService.getInstance(context);
        this.channelDatabaseService = ChannelDatabaseService.getInstance(context);
    }

    public static synchronized ChannelService getInstance(Context context) {
        if (channelService == null) {
            channelService = new ChannelService(context);
        }
        return channelService;
    }

    public Channel getChannelInfo(Integer key) {
        ChannelFeed channelFeed;
        if (key == null) {
            return null;
        }
        Channel channel = this.channelDatabaseService.getChannelByChannelKey(key);
        if (channel == null && (channelFeed = this.channelClientService.getChannelInfo(key)) != null) {
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds);
            BroadcastService.sendUpdateForName(this.context, channelFeed.getId(), BroadcastService.INTENT_ACTIONS.UPDATE_NAME.toString());
            channel = new Channel(channelFeed.getId(), channelFeed.getName(), channelFeed.getAdminName(), Short.valueOf(channelFeed.getType()), channelFeed.getUnreadCount());
            return channel;
        }
        return channel;
    }

    public void processChannelFeedList(ChannelFeed[] channelFeeds) {
        if (channelFeeds != null && channelFeeds.length > 0) {
            for (ChannelFeed channelFeed : channelFeeds) {
                Set<String> memberUserIds = channelFeed.getMembersName();
                Channel channel = new Channel(channelFeed.getId(), channelFeed.getName(), channelFeed.getAdminName(), Short.valueOf(channelFeed.getType()), channelFeed.getUnreadCount());
                if (this.channelDatabaseService.isChannelPresent(channel.getKey())) {
                    this.channelDatabaseService.updateChannel(channel);
                } else {
                    this.channelDatabaseService.addChannel(channel);
                }
                if (memberUserIds == null || memberUserIds.size() <= 0) continue;
                for (String userId : memberUserIds) {
                    ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelFeed.getId(), userId, channelFeed.getUnreadCount());
                    if (this.channelDatabaseService.isChannelUserPresent(channelFeed.getId(), userId)) {
                        this.channelDatabaseService.updateChannel(channelUserMapper);
                        continue;
                    }
                    this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
                }
            }
        }
    }

    public synchronized Channel getChannelByChannelKey(Integer channelKey) {
        if (channelKey == null) {
            return null;
        }
        return this.channelDatabaseService.getChannelByChannelKey(channelKey);
    }

    public List<ChannelUserMapper> getListOfUsersFromChannelUserMapper(Integer channelKey) {
        return this.channelDatabaseService.getChannelUserList(channelKey);
    }

    public Channel getChannel(Integer channelKey) {
        Channel channel = this.channelDatabaseService.getChannelByChannelKey(channelKey);
        if (channel == null) {
            channel = new Channel(channelKey);
        }
        return channel;
    }

    public void updateChannel(Channel channel) {
        if (this.channelDatabaseService.getChannelByChannelKey(channel.getKey()) == null) {
            this.channelDatabaseService.addChannel(channel);
        } else {
            this.channelDatabaseService.updateChannel(channel);
        }
    }

    public List<Channel> getChannelList() {
        return this.channelDatabaseService.getAllChannels();
    }

    public synchronized void syncChannels() {
        MobiComUserPreference userpref = MobiComUserPreference.getInstance(this.context);
        SyncChannelFeed syncChannelFeed = this.channelClientService.getChannelFeed(userpref.getChannelSyncTime());
        if (syncChannelFeed.isSuccess()) {
            channelService.processChannelFeedList(syncChannelFeed.getResponse().toArray(new ChannelFeed[syncChannelFeed.getResponse().size()]));
        }
        userpref.setChannelSyncTime(syncChannelFeed.getUpdatedAt());
    }

    public synchronized Channel createChannel(ChannelCreate channelCreate) {
        Channel channel = null;
        ChannelFeed channelFeed = this.channelClientService.createChannel(channelCreate);
        if (channelFeed != null) {
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            channelService.processChannelFeedList(channelFeeds);
            channel = new Channel(channelFeed.getId(), channelFeed.getName(), channelFeed.getAdminName(), Short.valueOf(channelFeed.getType()), channelFeed.getUnreadCount());
        }
        return channel;
    }
}

