/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static final String TAG = "ConnectivityReceiver";
    private static final String CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
    Context context;

    public void onReceive(final Context context, Intent intent) {
        this.context = context;
        String action = intent.getAction();
        Log.i((String)TAG, (String)action);
        if (action.equalsIgnoreCase(CONNECTIVITY_CHANGE)) {
            if (!Utils.isInternetAvailable((Context)context)) {
                return;
            }
            if (!MobiComUserPreference.getInstance(context).isLoggedIn()) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SyncCallService.getInstance(context).syncMessages(null);
                    MessageClientService.syncPendingMessages(context);
                    MessageClientService.syncDeleteMessages(context);
                }
            });
            thread.setPriority(10);
            thread.start();
        }
    }
}

